import code
from numpy import arange, linspace
import matplotlib.pyplot as plt
from itertools import accumulate as acc

def read_file(fn):
    with open('csv/{}.csv'.format(fn)) as f:
        return [float(x.strip()) for x in f.readlines()]

def load_case(s):
    a = sorted(read_file('good_'+s))
    b = sorted(read_file('bad_'+s))
    return a, b

def get_diff(a, b):
    ax = [(x, 1) for x in a]
    bx = [(x, -1) for x in b]
    c = sorted(ax+bx)
    ret, r = zip(*c)
    return ret, list(acc(r))

def hist_count(a, b, label=None):
    mi = min(min(a), min(b))
    ma = max(max(a), max(b))
    bins = linspace(mi, ma, 30)
    plt.xlabel('Penalty')
    plt.ylabel('Number of alignments')
    # ax = fig.add_subplot(111)
    good = plt.hist(a, bins=bins, label='Good alignments', alpha=0.6, color='blue')
    bad = plt.hist(b, bins=bins, label='Bad alignments', alpha=0.6, color='red')
    # _ = plt.plot([], label='Cut-off count: {}'.format(len([x for x in a if x< min(b)])), color='white')
    plt.legend()
    plt.grid()
    plt.show()

def plot_count(a, b, label=None):
    '''plt.subplot(211)
    good = plt.plot(a, range(len(a)), label='Good alignments')
    bad = plt.plot(b, range(len(b)), label='Bad alignments')
    if label is not None:
        plt.label(label)
    plt.legend()
    plt.grid()
    #plt.show()
    plt.subplot(212)'''
    # plt.figure(figsize=(100, 100))
    gi, gv = get_diff(a, [])
    bi, bv = get_diff(b, [])
    di, dv = get_diff(a, b)
    good = plt.plot(gi, gv, label='Good alignments', color='blue')
    bad = plt.plot(bi, bv, label='Bad alignments', color='red')
    diff = plt.plot(di, dv, label='Difference', color='black', alpha=0.8)
    _ = plt.plot([], label='Cut-off count: {}'.format(len([x for x in a if x< min(b)])), color='white')
    plt.xlabel('Penalty')
    plt.ylabel('# of alignments with penalty < x')
    plt.legend()
    plt.grid()
    plt.show()

code.interact(local=locals())
