<?php

date_default_timezone_set("Europe/Bratislava");

function showErrorTemplate($type, $extra_param="") {
	global $_path;
	$ret = include_once $_path['core_error'] . $type . ".tmpl.php";
	die($ret);
}

function __autoload($className) {
	global $_path;
	$plugin = "{$_path['plugins']}{$className}/{$className}.php";
	$file = "{$_path['core_class']}{$className}.class.php";
	$core = "{$_path['core_plugin']}{$className}.php";
	if (file_exists($plugin)) {
		require_once $plugin;
		return;
	} elseif (file_exists($file)) {
		require_once $file;
		return;
	} elseif (file_exists($core)) {
		require_once $core;
		return;
	} else {
		// if (class_exists($className))
		//	showErrorTemplate("class",$className);
	}
}

function checkPHP5($version) {
	if (phpversion() < $version) {
		showErrorTemplate("php5");
	}
}

function includeFile($file,$exceptionMsg) {
	global $_cfg;
	try {
		if (file_exists($file))
			include $file;
		else
			throw new Exception($exceptionMsg);
	} catch (Exception $e) {
		showErrorTemplate($e->getMessage());
	}
}

function encryptPass($pass) {
	return md5($pass);
}

?>