<?php

class cMenu {

	public $oDb, $oUrl;
	public $langKey;
	private $key;
	
	function __construct($oDb, $oUrl) {
		$this->oDb = $oDb;
		$this->oUrl = $oUrl;
		$this->key = Array();
	}
	
	public final function getHtmlMenu($parentID = 0, $depth = 1, $curDepth = 0, $hideMenuItems = Array()) {
		$curDepth++;
		$ret = "";
		$sql = "SELECT * FROM menu WHERE id_parent = '".$parentID."'
			AND show_menu = '1'
			AND uri NOT IN ('".implode("','",$hideMenuItems)."')
			ORDER BY position ASC";
		$menuQ = $this->oDb->query($sql);
		$menuCntRows = $this->oDb->numrows($menuQ);
		$cnt = 0;
		while ($menuR = $this->oDb->get($menuQ)) {
			$idMenu = $menuR['id_menu'];
			$rights = $this->oUrl->oSession->getRights($idMenu, 0);
			if (!@$rights[$idMenu][0]['can_read'])
				continue;
			$subMenu = "";
			if ($curDepth < $depth)
				$subMenu = $this->getHtmlMenu($menuR['id_menu'], $depth, $curDepth, $hideMenuItems);
			$classes = Array($menuR['uri'],"level".$curDepth."");
			if ($this->oUrl->page == $menuR['uri'])
				$classes[] = "selected";
			if ($cnt == 0)
				$classes[] = "first";
			if ($cnt == $menuCntRows - 1)
				$classes[] = "last";
			$classA = "";
			if ($menuR['module_type'] == "redir")
				$link = $menuR['module_name'] . '" target="_blank';
			elseif ($menuR['module_type'] == "js")
				$link = 'javascript:void(null);" onclick="' . $menuR['module_name'];
			elseif (empty($subMenu))
				$link = $this->oUrl->menuLink($menuR['uri'], $menuR['module_protocol']);
			else {
				$link = 'javascript:void(null);';
				$classes[] = "inactive";
				$classA = "inactive";
			}
			$titleKey =$menuR['title' . $this->langKey()];
			$menuTitleKey = $menuR['menu_title' . $this->langKey()];
			$ret .= $this->depthSpace($curDepth) . '<li'.(count($classes > 0) ? ' class="'.implode(" ",$classes).'"' : "").'><a href="'.
				$link.'" title="'.$titleKey.'" class="'.$classA.'"><span>'.
				$menuTitleKey.'</span></a>'.$subMenu.'</li>'."\n";
			$cnt++;
		}
		if ($cnt == 0)
			return "";
		else
			return "<ul class=\"level".$curDepth."\">\n". $ret . $this->depthSpace($curDepth) . '</ul>' .
				($curDepth == 1 ? "\n" : "");
	}
	
	private function depthSpace($d) {
		if ($d == 0) return "";
		return "\t" . $this->depthSpace($d - 1);
	}
	
	public final function getFormMenu($parentID = 0, $depth = 0) {
		$depth++;
		$depthX = Array("","&gt;","&gt; &gt;");
		$ret = "";
		$sql = "SELECT * FROM menu
			WHERE id_parent = '".$parentID."'
			AND show_menu = '1' ORDER BY position ASC";
		$menuQ = $this->oDb->query($sql);
		while ($menuR = $this->oDb->get($menuQ)) {
			$ret .= '<option value="'.$menuR['id_menu'].'">'.
				$depthX.' '.$menuR['menu_title'].'</option>'."\n";
			$ret .= $this->getFormMenu($menuR['id_menu'], $depth);
		}
		return $ret;
	}
	
	public final function navigation($title = "Homepage") {
		$pole = Array('<a href="'.$this->oUrl->page($this->oUrl->pageDefault).'">'.$title.'</a>');
		$pole = array_merge($pole, $this->navigationArray($this->getID($this->oUrl->page)));
		for ($i=0;$i<count($pole);$i++)
			if ($i <> count($pole)-1 && $i <> 0)
				$pole[$i] = strip_tags($pole[$i]);
		return implode(" &raquo; ",$pole);
	}
	
	private function navigationArray($idParent) {
		$res = $this->oDb->obtain("SELECT id_parent,uri,menu_title".$this->langKey()." FROM menu WHERE id_menu = '{$idParent}'");
		$ret = Array();
		if ($res['id_parent'] > 0)
			$ret = $this->navigationArray($res['id_parent']);
		return array_merge($ret, Array('<a href="'.$this->oUrl->page($res['uri']).'">'.$res['menu_title'.$this->langKey()].'</a>'));
	}
	
	public final function getTypeOfMenu($uri) {
		return $this->getKey("module_type",$uri);
	}
	
	public final function getModule($uri) {
		return $this->getKey("module_name",$uri);
	}
	
	public final function getNadpis($uri) {
		return $this->getKey("title" . $this->langKey(),$uri);
	}
	
	public final function getParentID($uri) {
		return $this->getKey("id_parent",$uri);
	}
	
	public final function getID($uri) {
		return $this->getKey("id_menu",$uri);
	}
	
	public final function pageID() {
		return $this->getKey("id_menu",$this->oUrl->page);
	}
	
	public final function getMenuTitle($uri) {
		return $this->getKey("menu_title" . $this->langKey(),$uri);
	}
	
	private function langKey() {
		if (isset($langKey))
			return $this->langKey;
		$key = "";
		if (array_key_exists("lang",$_GET)) {
			$key = "_".$_GET['lang'];
			if ($_GET['lang'] == "default")
				$key = "";
		}
		$this->langKey = $key;
		return $key;
	}
	
	public final function getDepth($uri) {
		return $this->getKey("depth",$uri);
	}
	
	public final function getParentPage($uri) {
		if (empty($uri)) $uri = $this->oUrl->page;
		$mT = $this->oDb->obtain("SELECT id_parent FROM menu WHERE uri = '".$uri."'");
		$sT = $this->oDb->obtain("SELECT uri FROM menu WHERE id_menu = '".$mT['id_parent']."'");
		return $sT['uri'];
	}
	
	private function getKey($key, $uri) {
		if (array_key_exists($uri,$this->key))
			if (array_key_exists($key,$this->key[$uri]))
				return $this->key[$uri][$key];
		$mT = $this->oDb->obtain("SELECT `".$key."` FROM menu WHERE uri = '".$uri."'");
		if (is_array($mT) && array_key_exists($key,$mT)) {
			$this->key[$uri][$key] = $mT[$key];
			return $this->key[$uri][$key];
		}
		showErrorTemplate("menu");
	}

}

?>
