<?php

class cUrl extends cApp {

	public $pageDefault, $page, $action, $rightsAction, $cat, $pos, $proto, $lang;
	public $oSession;
	
	function __construct($oSession, $mainPage) {
		parent::__construct();
		$this->pageDefault = $mainPage;
		$this->page = array_key_exists("page",$_GET) ? $_GET['page'] : $this->pageDefault;
		$this->action = array_key_exists("action",$_GET) ? $_GET['action'] : 0;
		$this->rightsAction = 0;
		$this->cat = array_key_exists("cat",$_GET) ? $_GET['cat'] : "";
		$this->pos = array_key_exists("pos",$_GET) ? $_GET['pos'] : 0;
		$this->lang = array_key_exists("lang",$_GET) ? $_GET['lang'] : "";
		$this->order = array_key_exists("order",$_GET) ? $_GET['order'] : "";
		$this->proto = array_key_exists("https",$_SERVER) ? "https" : "http";
		$this->oSession = $oSession;
	}
	
	public function href() {
		return $this->link($this->page, $this->action, "", 0, $this->lang);
	}
	
	public function fullHref($page = "") {
		if ($page == "")
			$page = $this->page;
		return $this->link($page, $this->action, $this->cat, $this->pos, $this->lang, $this->order);
	}
	
	public function page($page) {
		return $this->link($page, 0, "", 0, $this->lang);
	}
	
	public function iid($iid) {
		return $this->link($this->page, $iid, "", 0, $this->lang);
	}
	
	public function hrefCat($cat = "", $page = "") {
		if (empty($cat)) $cat = $this->cat;
		
		if (empty($page)) $page = $this->page;
		return $this->link($page, 0, $cat, 0, $this->lang);
	}
	
	public function pageLink($pos) {
		return $this->link($this->page, 0, $this->cat, $pos, $this->lang, $this->order);
	}
	
	public function orderLink($order) {
		if (ereg("-DESC",$order))
			$order = str_replace("-DESC","",$order);
		elseif ($order == $this->order)
			$order .= "-DESC";
		return $this->link($this->page, 0, $this->cat, 0, $this->lang, $order);
	}
	
	public function menuLink($page, $proto) {
		return $this->link($page, 0, "", 0, $this->lang, "", TRUE, $proto);
	}
	
	public function langLink($lang) {
		if ($lang == "default")
			$lang = "";
		return $this->link($this->page, $this->action, $this->cat, $this->pos, $lang, $this->order);
	}

	public function link($page="", $action=0, $cat="", $pos=0, $lang="", $order="", $s=TRUE, $proto="http") {
		if ($proto == "https")
			$ret = $this->path['https'];
		else
			$ret = $this->path['url'];
		if ($this->cfg['mod_rewrite']) {
			if (strlen($page) > 0) $ret .= $page . "/";
			if ($action > 0) $ret .= "i" .$action . "/";
			if (strlen($cat) > 0) $ret .= $cat . "/";
			if ($pos > 0) $ret .= $pos . "/";
			$ret .= $this->returnSid($s);
			$addit = Array();
			if (strlen($lang) > 0) $addit[] = "lang=" . $lang;
			if (strlen($order) > 0) $addit[] = "order=" . $order;
			if (count($addit) > 0)
				$ret .= "?" . implode("&",$addit);
		} else {
			$ret .= "?";
			if (strlen($page) > 0) $ret .= "&page=" . $page;
			if ($action > 0) $ret .= "&action=" . $action;
			if (strlen($cat) > 0) $ret .= "&cat=" . $cat;
			if ($pos > 0) $ret .= "&pos=" . $pos;
			if (strlen($lang) > 0) $ret .= "&lang=" . $lang;
			if (strlen($order) > 0) $ret .= "&order=" . $order;
			$ret .= $this->returnSid($s);
		}
		return $ret;
	}
	
	private function returnSid($s) {
		if ($this->cookies)
			return "";
		if ($s && strlen($this->oSession->ssid) > 0) 
		if ($this->cfg['mod_rewrite'])
			return "ssid-" . $this->oSession->ssid . "/";
		else
			return "&ssid=" . $this->oSession->ssid;
		return "";
	}
	
	public function cleanLink() {
		return $this->link("","",0,FALSE);
	}
	
}

?>
