<?php

class lang_keys extends cData {

	public $pluginName, $pluginMenuTitle, $tables, $joins, $rights, $order, 
		$perPage, $insertText, $urlLink, $moduleType, $childClass;

	function __construct($oDb, $oUrl, $oSession, $action) {
		$this->pluginName = "Language keys";
		$this->pluginMenuTitle = "Language keys";
		$this->tables = Array (
			Array(
				"name" => "lang_keys"
			)
		);
		$this->order = "lang_keys.tabname ASC, lang_keys.keyname ASC";
		$this->perPage = 30;
		$this->insertText = "Add language key";
		$this->urlLink = "lang-keys";
		$this->moduleType = "class";
		$this->childClass = __CLASS__;
		parent::__construct($oDb, $oUrl, $oSession, $action);
	}
	
	final function validateData($array) {
		try {
			if (!$this->columnExists($array['tabname'], $array['keyname']))
				throw new Exception("Column not exists in table.");
		} catch (Exception $e) {
			$this->errorMsg($e->getMessage());
			return FALSE;
		}
		parent::validateData($array);
		return TRUE;	
	}
	
	final function beforeSubmit($postData) {
		return parent::beforeSubmit($postData);
	}
	
	final function printList() {
		$ret = "";
		$ret .= $this->tableHead("Languages keys for multilang",Array(
			"Table name","Table key name",
		));
		while ($bR = $this->oDb->get($this->query)) {
			$ret .= $this->inTable(Array(
				$this->pp($bR,"tabname"),
				$this->pp($bR,"keyname"),
			),$this->pp($bR,$this->primaryKey));
		}
		$ret .= $this->tableEnd();
		return parent::printList($ret);
	}
	
	final function printForm($action, $id) {
		$ret = "";
		$ar = $this->tableSelectbox();
		$ret .= $this->oForm->selectBox("Tabname", "tabname", $ar, $this->pp($this->row, "tabname"));
		$ret .= $this->oForm->inputBox("Keyname", "keyname", 32, $this->pp($this->row, "keyname"));
		return parent::printForm($action, $id, $ret);
	}

	final function tableSelectbox() {
		$q = $this->oDb->query("SHOW TABLES");
		$pole = Array();
		$pole[0]['value'] = "";
		$pole[0]['name'] = "-- Choose --";
		while ($bR = $this->oDb->get($q)) {
			foreach ($bR as $key => $val)
				$tabName = $val;
			$pole[]['value'] = $tabName;
			$pole[count($pole)-1]['name'] = $tabName;
		}
		return $pole;
	}
	
	function columnExists($db, $column) {
   	$columns = mysql_query("SHOW COLUMNS FROM {$db}");
   	while ($c = mysql_fetch_assoc($columns))
   		if ($c['Field'] == $column)
   			return TRUE;
   	return FALSE;
	}
	
}

?>