<?php

class languages extends cData {

	public $pluginName, $pluginMenuTitle, $tables, $joins, $rights, $order, 
		$perPage, $insertText, $urlLink, $moduleType, $childClass;

	function __construct($oDb, $oUrl, $oSession, $action) {
		$this->pluginName = "Languages";
		$this->pluginMenuTitle = "Languages";
		$this->tables = Array (
			Array(
				"name" => "langs"
			)
		);
		$this->order = "langs.id_langs ASC";
		$this->perPage = 30;
		$this->insertText = "Add language";
		$this->urlLink = "languages";
		$this->moduleType = "class";
		$this->childClass = __CLASS__;
		parent::__construct($oDb, $oUrl, $oSession, $action);
	}
	
	final function validateData($array) {
		try { 
		} catch (Exception $e) {
			$this->errorMsg($e->getMessage());
			return FALSE;
		}
		parent::validateData($array);
		return TRUE;	
	}
	
	final function beforeSubmit($postData) {
		return parent::beforeSubmit($postData);
	}
	
	final function printList() {
		$ret = "";
		$ret .= $this->tableHead("Languages list (default excluded)",Array(
			"Icon","Language shortcut","Language name",
		));
		while ($bR = $this->oDb->get($this->query)) {
			$ret .= $this->inTable(Array(
				'<img src="'.$this->path['core_flags_url'].$this->pp($bR,"flag").'" alt="Lang" width="18" height="12" />',
				$this->pp($bR,"lang"),
				$this->pp($bR,"langname"),
			),$this->pp($bR,$this->primaryKey));
		}
		$ret .= $this->tableEnd();
		return parent::printList($ret);
	}
	
	final function printForm($action, $id) {
		$ret = "";
		$ret .= $this->oForm->inputBox("Language shortcut", "lang", 8, $this->pp($this->row, "lang"));
		$ret .= $this->oForm->inputBox("Language name", "langname", 32, $this->pp($this->row, "langname"));
		$ret .= $this->iconPrint($this->pp($this->row, "flag"));
		return parent::printForm($action, $id, $ret);
	}
	
	final function iconPrint($default) {
		$handle = opendir($this->path['core_flags']);
		$pole = Array();
		while (false !== ($file = readdir($handle)))
			if (eregi(".gif",$file)) {
				$img = $this->path['core_flags_url'] . $file;
				$pole[] = Array("name" => '<img src="'.$img.'" width="18" height="12" />', "value" => $file);
			}
      return $this->oForm->optionBox("Language icon", "flag", $pole, $default);
	}
	
}

?>