<?php

class settings extends cData {

	public $pluginName, $pluginMenuTitle, $tables, $joins, $rights, $order, 
		$perPage, $insertText, $urlLink, $moduleType, $childClass;

	function __construct($oDb, $oUrl, $oSession, $action) {
		$this->pluginName = "Settings";
		$this->pluginMenuTitle = "Settings";
		$this->tables = Array (
			Array(
				"name" => "settings"
			)
		);
		$this->order = "settings.variable ASC";
		$this->perPage = 60;
		$this->insertText = "Add configuration";
		$this->urlLink = "settings";
		$this->moduleType = "class";
		$this->childClass = __CLASS__;
		parent::__construct($oDb, $oUrl, $oSession, $action);
	}
	
	final function validateData($array) {
		try { 
		} catch (Exception $e) {
			$this->errorMsg($e->getMessage());
			return FALSE;
		}
		parent::validateData($array);
		return TRUE;	
	}
	
	final function beforeSubmit($postData) {
		return parent::beforeSubmit($postData);
	}
	
	final function printList() {
		$ret = "";
		$variableLink = '<a href="'.$this->oUrl->orderLink("variable").'">Variable</a>';
		$typeLink = '<a href="'.$this->oUrl->orderLink("variable_type").'">Type</a>';
		$ret .= $this->tableHead("System variables",Array(
			$variableLink,"Description",$typeLink,"Value"
		));
		while ($bR = $this->oDb->get($this->query)) {
			$type = $this->pp($bR,"variable_type");
			$value = $type == "short" ? $this->pp($bR,"value") : "...";
			$ret .= $this->inTable(Array(
				$this->pp($bR,"variable"),
				$this->pp($bR,"description"),
				$type,
				$value
			),$this->pp($bR,$this->primaryKey));
		}
		$ret .= $this->tableEnd();
		return parent::printList($ret);
	}
	
	final function printForm($action, $id) {
		$ret = "";
		$ret .= $this->oForm->inputBox("Description", "description", 64, $this->pp($this->row, "description"));
		$ret .= $this->oForm->inputBox("Variable name", "variable", 32, $this->pp($this->row, "variable"));
		$type = $this->pp($this->row, "variable_type");	
		$ret .= $this->oForm->optionBox("Type", "variable_type", Array (
			Array (
				"name" => "Short variable",
				"value" => "short"
			),
			Array (
				"name" => "Long text / data",
				"value" => "long"
			)
		), $type);
		if ($type == "long")
			$ret .= $this->oForm->TextBox("Value", "value", $this->pp($this->row, "value"));
		else
			$ret .= $this->oForm->inputBox("Value", "value", 255, $this->pp($this->row, "value"));
		return parent::printForm($action, $id, $ret);
	}
	
}

?>