<?php

class tmpl extends cData {

	public $pluginName, $pluginMenuTitle, $tables, $joins, $rights, $order, 
		$perPage, $insertText, $urlLink, $moduleType, $childClass;

	function __construct($oDb, $oUrl, $oSession, $action) {
		$this->pluginName = "Obsahova podstránka";
		$this->pluginMenuTitle = "Podstránka";
		$this->tables = Array (
			Array(
				"name" => "tmpl"
			)
		);
		$this->joins = Array();
		$this->rights = Array (
			"update" => "admin",
			"insert" => "admin",
			"delete" => "admin",
			"listen" => "admin"
		);
		$this->order = "tmpl.id_tmpl DESC";
		$this->perPage = 30;
		$this->insertText = "Upraviť text na tejto podstránke";
		$this->urlLink = "tmpl";
		$this->moduleType = "class";
		$this->childClass = __CLASS__;
		parent::__construct($oDb, $oUrl, $oSession, $action);
	}
	
	final function validateData($array) {
		try {
		} catch (Exception $e) {
			$this->errorMsg($e->getMessage());
			return FALSE;
		}
		parent::validateData($array);
		return TRUE;	
	}
	
	final function beforeSubmit($postData) {
		$postData['content'] = $postData['megaBox1'];
		return parent::beforeSubmit($postData);
	}
	
	final function printList() {
		$ret = "";
		if ($this->hasRights("can_insert") && !empty($this->insertText)) {
			$insert = '<input type="hidden" name="submit" value="New" /><input type="submit" name="sub" class="submit input_new" value="'.$this->insertText.'" />'."\n";
			$ret = '<div class="insert">' .
				$this->HTMLForm($insert) . '</div>' . "\n" . $ret;
		}
		if ($this->oDb->dbnumrows("SELECT * FROM tmpl_stats
			WHERE uri = '".$this->oUrl->page."'") > 0)
			$this->oDb->query("UPDATE tmpl_stats SET
				access_count=access_count+1
				WHERE uri = '".$this->oUrl->page."'");
			/*$this->oDb->queryWithBids("UPDATE tmpl_stats SET
				access_count=access_count+1
				WHERE uri = ?", array($this->oUrl->page));*/
		
		else
			$this->oDb->query("INSERT INTO tmpl_stats SET
				uri = '".$this->oUrl->page."',
				access_count = '1'");
			/*$this->oDb->queryWithBids("INSERT INTO tmpl_stats SET
				uri = ?, access_count = '1'", array($this->oUrl->page));*/
		if (count($this->row) > 0)
			$ret .= $this->customReplace($this->pp($this->row,"content"));
		return $ret;
	}
	
	final function printForm($action, $id) {
		$ret = "";
		if ($this->action == "New") {
			$tRes = $this->oDb->obtain("SELECT id_tmpl FROM tmpl
				WHERE module = (SELECT module_name FROM menu WHERE uri = '".$this->oUrl->page."' LIMIT 1)
				ORDER BY id_tmpl DESC LIMIT 1");
			if (is_array($tRes) && array_key_exists("id_tmpl",$tRes))
				$this->getDB($tRes['id_tmpl']);
		}
		$ret .= $this->oForm->megaBox($this->pp($this->row, "content"));
		$this->oMenu = new cMenu($this->oDb, $this->oUrl);
		$ret .= $this->oForm->hiddenF("module",$this->oMenu->getModule($this->oUrl->page));
		return parent::printForm($action, $id, $ret);
	}
	
	final function customReplace($str) {
		$file = $this->path['plugins']."replace/replace.php";
		if (file_exists($file)) {
			include_once($file);
			$cReplace = new cReplace($this->oDb, $this->oUrl);
			return $cReplace->parse($str);
		}
		return $str;
	}
	
	final function dbInsert() {
		if (!$this->validateData($_POST)) return;
		$sql = "INSERT INTO `{$this->primaryTable}` () VALUES ()";
		$this->oDb->query($sql);
		$insertID = $this->oDb->insertID();
		$maxKey = $this->oDb->getKey("maximum", "SELECT MAX(id_tmpl) AS maximum FROM tmpl
			WHERE module = (SELECT module_name FROM menu
				WHERE uri = '{$this->oUrl->page}' LIMIT 1)");
		$this->dbUpdate($insertID);
		$q = $this->oDb->query("SELECT * FROM langs");
		if ($this->oDb->numrows($q) > 1)
			while ($res = $this->oDb->get($q)) {
				$prefix = "_".$res['lang'];
				if ($res['lang'] == "default") {
					$prefix = "";
					$res['lang'] = "";
				}
				$key = "content" . $prefix;
				if ($res['lang'] != $this->lang) {
					$sql = "SELECT `{$key}` FROM tmpl WHERE id_tmpl = '".$maxKey."'";
					$content = addslashes($this->oDb->getKey($key, $sql));
					$this->oDb->query("UPDATE tmpl SET `{$key}` = '{$content}' WHERE id_tmpl = '{$insertID}'");
					//$this->oDb->queryWithBids("UPDATE tmpl SET `{$key}` = '{$content}' WHERE id_tmpl = '{$insertID}'", array($key,$content,$insertID));
				}
			}
	}
	
}

?>
