<?php

class userrights extends cData {

	public $pluginName, $pluginMenuTitle, $tables, $joins, $rights, $order, 
		$perPage, $insertText, $urlLink, $moduleType, $childClass;

	function __construct($oDb, $oUrl, $oSession, $action) {
		$this->pluginName = "Global rights";
		$this->pluginMenuTitle = "Rights";
		$this->tables = Array (
			Array(
				"name" => "perms"
			),
			Array(
				"name" => "namespace"
			),
			Array(
				"name" => "users"
			)
		);
		$this->joins = Array (
			"namespace" => "namespace.id_namespace = perms.id_namespace",
			"users" => "users.id = perms.id_user"
		);
		$this->order = "id_menu ASC, id_element ASC, perms.id_user ASC, owner_type ASC, id_owner ASC";
		$this->perPage = 50;
		$this->insertText = "Add right";
		$this->urlLink = "menu";
		$this->moduleType = "class";
		$this->childClass = __CLASS__;
		parent::__construct($oDb, $oUrl, $oSession, $action);
		if (isset($_POST)) {
			$postData = $_POST;
			if ($this->aKe($postData,"page_uri")) {
				$_SESSION['page_uri'] = $postData['page_uri'];
				$_SESSION['g_id'] = $postData['g_id'];
			}
		}
		if ($this->aKe($_SESSION,"page_uri")) {
			$this->searchDb[] = "id_menu IN (SELECT id_menu FROM menu
				WHERE uri LIKE '%".$_SESSION['page_uri']."%')";
			$this->searchDb[] = "id_owner IN (SELECT id_group FROM `group`
				WHERE `title` LIKE '%".$_SESSION['g_id']."%') AND owner_type = 'group'";
		}
	}
	
	final function validateData($array) {
		try { 
			if ($array['id_element'] == "")
				throw new Exception("Instance ID is mandatory (default value: 0).");
		} catch (Exception $e) {
			$this->errorMsg($e->getMessage());
			return FALSE;
		}
		parent::validateData($array);
		return TRUE;	
	}
	
	final function beforeSubmit($postData) {
		if ($postData['owner_type'] == "user")
			$postData['id_owner'] = $postData['id_user_own'];
		elseif ($postData['owner_type'] == "group")
			$postData['id_owner'] = $postData['id_group'];
		$list = Array("can_read","can_write","can_grant","can_comment");
		for ($i=0;$i<count($list);$i++)
			if (!$this->aKe($postData,$list[$i]))
				$postData[$list[$i]] = '0';
		return parent::beforeSubmit($postData);
	}
	
	final function printList() {
		$ret = "";
		$pageUriVal = $this->aKe($_SESSION,"page_uri") ? $_SESSION['page_uri'] : "";
		$gIdVal = $this->aKe($_SESSION,"g_id") ? $_SESSION['g_id'] : "";
		$ret .= '<form method="post" action="'.$this->oUrl->page($this->oUrl->page).'" class="nofloat">
			Uri: <input type="text" class="input input_medium" name="page_uri" value="'.$pageUriVal.'" />
			&nbsp;
			Group: <input type="text" class="input input_medium" name="g_id" value="'.$gIdVal.'" />
			&nbsp;
			<input type="submit" class="submit input_search" value="Search" />
		</form>'."\n";
		$ret .= $this->tableHead("List of rights",Array(
			"Where","What","User","Who","R W G C"
		));
		
		while ($bR = $this->oDb->get($this->query)) {
			$ID = $this->pp($bR,$this->primaryKey);
			$where = '<span title="'.$this->getUri($this->pp($bR,"id_menu")).'">'.
				$this->getMenuTitle($this->pp($bR,"id_menu")).'</span>';
			if (empty($where))
				$where = "Anywhere";
			$refType = $this->pp($bR,"owner_type");
			$refID = $this->pp($bR,"id_owner");
			$who = "Anyone";
			if ($refType == "user") {
				$res = $this->oDb->obtain("SELECT login FROM `users` WHERE id = '{$refID}'");
				$who = "User(".$res['login'].")";
			} elseif ($refType == "group") {
				$res = $this->oDb->obtain("SELECT `title` FROM `group` WHERE id_group = '{$refID}'");
				$who = "Group(".$res['title'].")";
			}
			$ret .= $this->inTable(Array(
				$where,
				$this->pp($bR,"id_element"),
				$this->oDb->getKey("login","SELECT login FROM `users`
					WHERE id = '".$this->pp($bR,"id")."'"),
				$who,
				$this->pp($bR,"can_read")." ".
				$this->pp($bR,"can_write")." ".
				$this->pp($bR,"can_grant")." ".
				$this->pp($bR,"can_comment")
			),$ID);
		}
		$ret .= $this->tableEnd();
		return parent::printList($ret);
	}
	
	final function printForm($action, $id) {
		$postData = $_POST;
		$ret = '<script type="text/javascript">
function changeReference() {
	var module = document.getElementById("owner_type");
	var user = document.getElementById("userSel");
	var group = document.getElementById("groupSel");
	if (module.value == "public") {
		user.style.display = "none";
		group.style.display = "none";
	} else if (module.value == "user") {
		user.style.display = "block";
		group.style.display = "none";
	} else if (module.value == "group") {
		user.style.display = "none";
		group.style.display = "block";
	}
}
</script>';
		if (array_key_exists("page_id",$postData)) {
			$ret .= $this->oForm->hiddenF("id_menu", $postData['page_id']);
			$ret .= '<p>Granting rights to page '.$postData['page_name'].'</p>'."\n";
		} else
			$ret .= $this->menuParent($this->pp($this->row, "id_menu"));
		
		if (array_key_exists("i_id",$postData))
			$ret .= $this->oForm->hiddenF("id_element", $postData['i_id']);
		else
			$ret .= $this->oForm->inputBox("Instance ID", "id_element", 10, $this->pp($this->row, "id_element"));
		$ret .= $this->oForm->selectBox("Namespace", "id_namespace", $this->oFunctions->namespaceSelect(), $this->pp($this->row, "id_namespace"));
		echo 'tu<br>';
		$ret .= $this->oFunctions->userSelectbox($this->pp($this->row, "id_user"));
		echo 'tu<br>';
		$ret .= $this->oForm->selectBox("Reference type", "owner_type", Array (
			Array (
				"name" => "Public",
				"value" => "public"
			),
			Array (
				"name" => "User",
				"value" => "user"
			),
			Array (
				"name" => "Group",
				"value" => "group"
			),
		), $this->pp($this->row, "owner_type"), "changeReference()");
		$ret .= '<div id="userSel">'."\n";
		$ret .= $this->oFunctions->userSelectbox($this->pp($this->row, "id_owner"), "id_user_own");
		$ret .= '</div>'."\n";
		$ret .= '<div id="groupSel">'."\n";
		$ret .= $this->oFunctions->groupSelectbox($this->pp($this->row, "id_owner"));
		$ret .= '</div>'."\n";
		$ret .= '<script type="text/javascript">changeReference();</script>'."\n";
		$ret .= '<div class="ramcek">'."\n";
		$list = Array("can_read","can_write","can_grant","can_comment");
		for ($i=0;$i<count($list);$i++) {
			$label = ucfirst(substr($list[$i],strpos($list[$i],"_")+1));
			$value = $this->pp($this->row, $list[$i]);
			if (!$id && $list[$i] == "can_read")
				$value = '1';
			$ret .= $this->oForm->checkBox($label, $list[$i], $value);
		}
		$ret .= '</div>'."\n";
		return parent::printForm($action, $id, $ret);
	}
	
	final function getMenuTitle($ID) {
		if ($ID == 0) return "";
		return $this->getKey("menu_title",$ID);
	}
	
	final function getUri($ID) {
		if ($ID == 0) return "";
		return $this->getKey("uri",$ID);
	}
	
	private function getKey($key, $ID) {
		
		$mT = $this->oDb->obtain("SELECT `".$key."` FROM menu WHERE id_menu = '".$ID."'");
		if (is_array($mT) && array_key_exists($key,$mT))
			return $mT[$key];
		return '<div class="chyba">Missing</div>';
	}
	
	private function menuParent($default) {
		$pole = $this->poleGenerator(0, 1);
		
		return $this->oForm->selectBox("Where", "id_menu", $pole, $default);
	}
	
	private function poleGenerator($idParent, $depth) {
		$pole = Array();
		if ($depth == 1)
			$pole = Array(Array(
				"name" => "-- Anywhere --",
				"value" => 0
			));
		$q = $this->oDb->query("SELECT id_menu,`title` FROM menu WHERE id_parent = '{$idParent}'");
		//$q= $this->oDb->queryWithBids("SELECT id_menu,`title` FROM menu WHERE id_parent = ?", array($idParent));
		while ($res = $this->oDb->get($q)) {
			
			$length = count($pole);
			$prefix = "";
			for ($j=0;$j<$depth;$j++)
				$prefix .= "&raquo; ";
			$pole[$length]['name'] = $prefix . $res['title'];
			$pole[$length]['value'] = $res['id_menu'];
			if ($depth < 3) {
				$pole = array_merge($pole, $this->poleGenerator($res['id_menu'],$depth+1));
			}
		}
		return $pole;
	}
	
}

?>
