'''
Created on May 3, 2012

@author: Igor Liska
'''

from t1fonts import Type1FontFile
from metricfiles import MetricFile
import random
import os
import subprocess
import StringIO
import config

class Encrypted(object):

    def __init__(self):
        self.INFO_MODE_COMMAND = '\\global\\def\\readcontextbc{}'
        
        self.rendering_command = config.RENDERER

    def encrypt(self, filename):
        if self.check_utilities(['kpsewhich', 'tftopl', 'vptovf']):
            self.verbose('All necessary tools were found, continuing...')
        else:
            self.verbose('Some of the necessary tools were NOT found, please install them first. Exiting...')
    
    
#        self.verbose("Enabling info mode in document...")
#        if not self.enable_info_mode(filename):
#            self.verbose("Cannot enable info mode, is '%s' writeable?" % (filename))
#            self.verbose("Exiting...")
#            return
        
        self.verbose("Reading font list...")
        status, output = self.render_pdf(filename)
        if not status:
            self.verbose("There was an unexpected error while reading font list from file '%s'" % (filename))
            self.verbose('Exiting...')
            return
        
        print output
        
        self.verbose("Found these fonts:")
        font_list = self.read_font_list(output)
        
        msg = {
            "ep" : "New paragraph",
            "bf" : "User defined (TeX)",
            "sf" : "User defined (NFSS)",
            "eg" : "Group end - restore"
        }
        
        for font in font_list:
            self.verbose("    %s - %s" % (font[2], msg[font[3]]))
        
        
#        self.verbose("Disabling info mode in document...")
#        if not self.disable_info_mode(filename):
#            self.verbose("Cannot disable info mode, is '%s' writeable?" % (filename))
#            self.verbose("Exiting...")
#            return
        
        self.verbose('Reading pdftex.map file...')
        status, location, pdfmap = self.read_pdf_map()
        if not status:
            self.verbose("File pdftex.map cannot be found or is not readable")
            self.verbose("Exiting...")
            return  
        
        self.verbose('File pdftex.map found, location: %s' % (location))
        self.verbose('Generating encrypted font files...')     
        
        status, cleanup = self.generate_encrypted_fonts(font_list, pdfmap)
        
        if not status:
            self.verbose("There was an unexpected error while generating encrypted font files.")
            self.verbose("Exiting...")
            return               
        
        self.verbose("Enabling info mode in document...")
        if not self.enable_info_mode(filename, font_list):
            self.verbose("Cannot enable info mode, is '%s' writeable?" % (filename))
            self.verbose("Exiting...")
            return
        
        self.verbose('Encrypted font files has been generated successfully, producing final PDF file...')  
        status, output = self.render_pdf(filename)
        if not status:
            self.verbose("There was an unexpected error while producing the final pdf file")
            self.verbose(output)
            self.verbose('Exiting...')
            return
        
        self.verbose("Disabling info mode in document...")
        if not self.disable_info_mode(filename):
            self.verbose("Cannot disable info mode, is '%s' writeable?" % (filename))
            self.verbose("Exiting...")
            return
        
        self.verbose(output)       
        
        self.verbose()
        self.verbose()
        
        self.verbose("Cleaning up...")
        self.cleanup(cleanup)
        
        self.verbose("Finished.")

    def verbose(self, text = ''):
        print text

    def check_utilities(self, utils_list):
        result = True
        for utility in utils_list:
            r = os.system(''.join(['which "', utility, '" > /dev/null']))
            if r == 0:
                self.verbose(''.join([utility, ' found']))
            else:
                result = False
                self.verbose(''.join([utility, ' not found, this utility is required in order to run this program']))
        return result

    def enable_info_mode(self, filename, font_list):
        try:
            f = open(filename, "r+")       
            data = f.read()
            f.seek(0)
            f.truncate()
            f.write(self.INFO_MODE_COMMAND)
            f.write(chr(10))
            
            f.write('\\global\\edef\\fontorderbc{')
            for font in font_list:
                f.write(font[4].strip())
                f.write(':')
                
            f.write('}%')
            f.write(chr(10))
            
            f.write('\\global\\edef\\fontorderrawbc{')
            for font in font_list:
                f.write(font[2].strip())
                f.write(':')
                
            f.write('}%')
            f.write(chr(10))
            
            f.write(data)
            f.close()
            
            return True
        except:
            return False
        
    def disable_info_mode(self, filename):
        try:
            f = open(filename, "r+")       
            f.readline()
            f.readline()
            f.readline()
            data = f.read()
            f.seek(0)
            f.truncate()
            f.write(data)
            f.close()
            
            return True
        except:
            return False
                
    def read_font_list(self, data):
        fd = StringIO.StringIO(data)
        
        output = []
        
        for line in fd:
            params = line.split(':')
            if params[0] == 'bcencryption' and params[1] == 'fch':
                output.append(map(lambda x: x.strip(), params))
        
        fd.close()
        
        return output

    def get_file_path(self, filename):
        status, output = self.call_command('kpsewhich "%s"' % (filename))
        
        if status != 0:
            return None
        
        return output.strip()

    def generate_encrypted_fonts(self, font_list, pdf_map):
        pdfmap = PdfMap(pdf_map)
        cleanup = []
        
        for font in font_list:
            fontname = font[2].split()[0]
            pfb_name = pdfmap.get_pfb(fontname)
            output_name = font[4].split()[0]
            output_path = ""
            
            self.verbose("Generating encrypted font '%s' from '%s'" % (output_name, fontname))
            
            if pfb_name is None:
                self.verbose("Cannot find PFB file name for font '%s'" % (fontname))
                return False
            
            source_tfm = self.get_file_path(''.join([fontname, '.tfm']))
            
            if source_tfm is None:
                self.verbose("Cannot find TFM file for font '%s'" % (fontname))
                return False

            source_pfb = self.get_file_path(pfb_name)
            
            if source_pfb is None:
                self.verbose("Cannot find PFB file for font '%s'" % (fontname))
                return False
            
            output = self.generate_encrypted_font(source_tfm, source_pfb, output_name, output_path)
            
            cleanup.append(output)
            
            self.verbose("Encrypted font has been successfully generated")
            
        return True, cleanup 

    def generate_encrypted_font(self, source_tfm, source_pfb, output_name, output_path):
        source_tfm_basename = os.path.basename(source_tfm)
        source_vpl = ''.join([output_path, source_tfm_basename[0:(len(source_tfm_basename) - 4)], '.vpl'])
        
        self.verbose("Converting source TFM file to VPL file...")
        os.system(''.join(['tftopl "', source_tfm, '" "', source_vpl, '"']))
        
        
        base_output_tfm = ''.join([output_path, output_name, 'b.tfm'])
        
        self.verbose("Creating base TFM file...")
        os.system(''.join(['cp "', source_tfm, '" "', base_output_tfm, '"']))
        
        t1file = Type1FontFile()
        mf = MetricFile(source_vpl, output_name + 'b')
    
        t1file.load_from_pfb_file(source_pfb)
        
        encoding = t1file.firstAsciiSegment.process_encoding()
    
        _, charstrings = t1file.binarySegment.process_segment()    
    
        encoding.resolve_duplicates(charstrings)
    
        pfb_vector = encoding.get_character_vector()
        mf_vector = mf.get_character_vector()
    
        intersect = set(pfb_vector).intersection(set(mf_vector))
        
        l1 = list(intersect)
        l2 = list(intersect)
        
        self.verbose("Generating random encoding permutation...")
        random.shuffle(l2)
    
        pfb_encoding_vector = [l2[l1.index(item)] if (item in l1) else item for item in pfb_vector]
        mf_encoding_vector = [l2[l1.index(item)] if (item in l1) else item for item in mf_vector]
    
        encoding.map_characters(charstrings, pfb_encoding_vector)
        mf.map_characters(mf_encoding_vector)
        
        t1file.firstAsciiSegment.save_encoding(encoding)
        t1file.binarySegment.save_charstrings(charstrings)
        
        output_vpl = ''.join([output_path, output_name, '.vpl'])
        
        mf.save_pl(output_vpl)
        
        output_pfb = ''.join([output_path, output_name, '.pfb'])
        
        self.verbose("Generating encrypted PFB file...")
        t1file.save_as_pfb_file(output_pfb)
        
        output_vf = ''.join([output_path, output_name, '.vf'])
        output_tfm = ''.join([output_path, output_name, '.tfm'])
        
        self.verbose("Generating virtual font file and encrypted TFM file...")
        os.system(''.join(['vptovf "', output_vpl, '" "', output_vf, '" "', output_tfm, '"']))
        
        os.remove(source_vpl)
        os.remove(output_vpl)
        
        return [base_output_tfm, output_tfm, output_vf, output_pfb]
       
    def call_command(self, command):
        try:
            return 0, subprocess.check_output(command, stderr=subprocess.STDOUT, shell=True)
        except subprocess.CalledProcessError as e:
            return e.returncode, e.output
    
    def render_pdf(self, filename):
        
        command = self.rendering_command % (filename)
        status, output = self.call_command(command)

        if status != 0:
            return False, output
    
        return True, output
    
    def read_pdf_map(self):
        output = self.get_file_path("pdftex.map")
        
        if output is None:
            return False, None, None
        
        try:
            f = open(output, "r")
            data = [item for item in map(lambda x: x.split('%')[0].split(), f.readlines()) if len(item) > 0]
            f.close()

            return True, output, data
        except:
            return False, None, None
        
        
    def cleanup(self, data):
        for item in data:
            for f in item:
                os.remove(f)
        
class PdfMap():
    def __init__(self, pdf_map):
        self.map = {}
        self.load_map(pdf_map)
        
    def load_map(self, pdf_map):
        for item in pdf_map:
            last_item = item[len(item) - 1]
            if last_item[len(last_item)-4:].lower() == '.pfb':
                if last_item[0] == '<':
                    last_item = last_item[1:]
                self.map[item[0]] = last_item
                
    def get_pfb(self, name):
        if name in self.map:
            return self.map[name]
        return None