/*
 * Decompiled with CFR 0.152.
 */
package bakalarka;

import bakalarka.AutomatonIterator;
import bakalarka.FastPrint;
import bakalarka.Identificator;
import bakalarka.Matrix;
import bakalarka.NoSuchStateException;
import bakalarka.SetOfIdentificators;
import bakalarka.State;
import bakalarka.Tuple;
import bakalarka.Variables;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Automaton {
    private HashMap<Identificator, State> idStateMap;
    private HashSet<Identificator> allStatesIds;
    private SetOfIdentificators finalStatesIds;
    private SetOfIdentificators initialStatesIds;
    private Identificator currentStateId;
    private int numberOfTransitions = 0;
    HashMap<Character, Matrix> transitionMap;
    Automaton cache_minDFA = null;
    Tuple hash_cache = Tuple.minusOne();

    public Automaton() {
        this.idStateMap = new HashMap();
        this.allStatesIds = new HashSet();
        this.finalStatesIds = new SetOfIdentificators();
        this.initialStatesIds = new SetOfIdentificators();
        this.numberOfTransitions = 0;
    }

    public Automaton switchLetters() throws Exception {
        HashMap<Character, Matrix> switchedLettersTransitionMap = new HashMap<Character, Matrix>();
        if (this.transitionMap != null) {
            if (Variables.alphabet.size() != 2) {
                try {
                    throw new Exception("You have to disable some optimisations due to alphabet size - look for !!!! in comments");
                }
                catch (Exception ex) {
                    Logger.getLogger(AutomatonIterator.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            for (int i = 0; i < 2; ++i) {
                switchedLettersTransitionMap.put(Variables.alphabet.get(i), this.transitionMap.get(Variables.alphabet.get(1 - i)));
            }
            return new Automaton(switchedLettersTransitionMap, this.initialStatesIds.iterator().next(), this.finalStatesIds);
        }
        throw new Exception("THIS AUTOMATON HAS NOT TRANSITION MAP IN MATRIX");
    }

    public Automaton(HashMap<Character, Matrix> transitionMap, Identificator initialStateId, HashSet<Identificator> finalStatesIds) throws Exception {
        this.idStateMap = new HashMap();
        this.allStatesIds = new HashSet();
        this.finalStatesIds = new SetOfIdentificators();
        this.initialStatesIds = new SetOfIdentificators();
        this.transitionMap = transitionMap;
        int n = transitionMap.get((Object)Variables.alphabet.get((int)0)).n;
        for (int i = 0; i < n; ++i) {
            this.addState(new Identificator(i));
        }
        for (Character c : Variables.alphabet) {
            Matrix transitionsIds = transitionMap.get(c);
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    if (!transitionsIds.get(i, j)) continue;
                    this.addTransition(new Identificator(i), new Identificator(j), c);
                }
            }
        }
        for (Identificator id : finalStatesIds) {
            this.finalStatesIds.add(id);
        }
        this.setInitialStateId(initialStateId);
    }

    public Automaton(Automaton a) {
        if (this.currentStateId != null) {
            this.currentStateId = a.currentStateId.copy();
        }
        this.allStatesIds = new HashSet();
        this.initialStatesIds = new SetOfIdentificators();
        this.idStateMap = new HashMap();
        for (Identificator id : a.initialStatesIds) {
            this.initialStatesIds.add(id.copy());
        }
        this.numberOfTransitions = a.numberOfTransitions;
        for (Identificator id : a.allStatesIds) {
            this.allStatesIds.add(id.copy());
            this.idStateMap.put(id.copy(), a.idStateMap.get(id).copy());
        }
        this.finalStatesIds = new SetOfIdentificators();
        for (Identificator id : a.finalStatesIds) {
            this.finalStatesIds.add(id.copy());
        }
    }

    public boolean doTransition(Character input) throws NoSuchStateException {
        if (!Variables.alphabet.contains(input)) {
            throw new IllegalArgumentException();
        }
        if (this.idStateMap.get(this.currentStateId).get(input) == null) {
            throw new NoSuchStateException("Can't make this transition");
        }
        this.currentStateId = ((SetOfIdentificators)this.idStateMap.get(this.currentStateId).get(input)).iterator().next();
        if (this.currentStateId == null) {
            throw new IllegalStateException();
        }
        return this.finalStatesIds.contains(this.currentStateId);
    }

    public void setInitialStateId(Identificator stateId) throws NoSuchStateException {
        if (this.idStateMap.get(stateId) == null) {
            throw new NoSuchStateException(stateId);
        }
        this.initialStatesIds.clear();
        this.initialStatesIds.add(stateId);
        this.setCurrentState(stateId);
    }

    public int numberOfStates() {
        return this.allStatesIds.size();
    }

    public void setInitialStateId(int stateId) throws NoSuchStateException {
        this.setInitialStateId(new Identificator(stateId));
    }

    public void addInitialState(Identificator stateId) throws NoSuchStateException {
        State s = this.idStateMap.get(stateId);
        if (s == null) {
            throw new NoSuchStateException("FAILED TO ADD FINAL STATE");
        }
        this.initialStatesIds.add(s.id);
    }

    public void setCurrentState(Identificator stateId) throws NoSuchStateException {
        if (this.idStateMap.get(stateId) == null) {
            throw new NoSuchStateException(stateId);
        }
        this.currentStateId = stateId;
    }

    public final boolean addState(Identificator stateId) throws Exception {
        if (this.allStatesIds.contains(stateId)) {
            return false;
        }
        State s = new State(stateId);
        this.idStateMap.put(stateId, s);
        this.allStatesIds.add(stateId);
        return true;
    }

    public void addState(int stateId) throws Exception {
        this.addState(new Identificator(stateId));
    }

    public final void addTransition(Identificator idFrom, Identificator idTo, Character c) throws NoSuchStateException, Exception {
        State from = this.idStateMap.get(idFrom);
        State to = this.idStateMap.get(idTo);
        if (from != null && to != null) {
            boolean isNew = from.addTransition(c, idTo);
            if (isNew) {
                ++this.numberOfTransitions;
            }
        } else {
            throw new NoSuchStateException("FAILED TO ADD TRANSITION");
        }
    }

    public void addTransition(int idFrom, int idTo, Character c) throws Exception {
        this.addTransition(new Identificator(idFrom), new Identificator(idTo), c);
    }

    public void addFinalState(Identificator stateId) throws NoSuchStateException {
        State s = this.idStateMap.get(stateId);
        if (s == null) {
            throw new NoSuchStateException("FAILED TO ADD FINAL STATE");
        }
        this.finalStatesIds.add(s.id);
    }

    public void addFinalState(int stateId) throws NoSuchStateException {
        this.addFinalState(new Identificator(stateId));
    }

    public State getState(Identificator id) {
        return this.idStateMap.get(id);
    }

    public Automaton determinize(boolean allowTrashState) throws Exception {
        if (this.finalStatesIds.isEmpty() || this.initialStatesIds.isEmpty()) {
            Automaton ret = new Automaton();
            Identificator id = new Identificator(0);
            ret.addState(id);
            ret.setInitialStateId(id);
            for (Character c : Variables.alphabet) {
                ret.addTransition(id, id, c);
            }
            return ret;
        }
        Automaton pom = new Automaton(this);
        Automaton ret = new Automaton();
        int currentMaxStateId = 0;
        HashMap<SetOfIdentificators, Identificator> MapOfSeenPowerSets = new HashMap<SetOfIdentificators, Identificator>();
        SetOfIdentificators InitialPowerSetStatesIds = new SetOfIdentificators(this.initialStatesIds);
        Identificator retInitialStateId = new Identificator(currentMaxStateId++);
        MapOfSeenPowerSets.put(InitialPowerSetStatesIds, retInitialStateId);
        ret.addState(retInitialStateId);
        ret.setInitialStateId(retInitialStateId);
        ret.setCurrentState(retInitialStateId);
        LinkedList<SetOfIdentificators> queue = new LinkedList<SetOfIdentificators>();
        queue.add(InitialPowerSetStatesIds);
        for (Identificator id : InitialPowerSetStatesIds) {
            if (!pom.finalStatesIds.contains(id)) continue;
            ret.addFinalState(retInitialStateId);
            break;
        }
        while (!queue.isEmpty()) {
            SetOfIdentificators currentRetId = (SetOfIdentificators)queue.peek();
            for (Character c : Variables.alphabet) {
                Identificator idToAdd;
                SetOfIdentificators newId = new SetOfIdentificators();
                boolean thisIsFinalState = false;
                for (Identificator IdentificatorInPom : currentRetId) {
                    if (pom.getState(IdentificatorInPom).getTransition(c) == null) continue;
                    for (Identificator identificatorOfTransitionState : pom.getState(IdentificatorInPom).getTransition(c)) {
                        if (pom.finalStatesIds.contains(identificatorOfTransitionState)) {
                            thisIsFinalState = true;
                        }
                        newId.add(identificatorOfTransitionState);
                    }
                }
                if (!newId.isEmpty()) {
                    idToAdd = (Identificator)MapOfSeenPowerSets.get(newId);
                    if (idToAdd == null) {
                        idToAdd = new Identificator(currentMaxStateId++);
                        MapOfSeenPowerSets.put(newId, idToAdd);
                        ret.addState(idToAdd);
                        queue.add(newId);
                    }
                    if (thisIsFinalState) {
                        ret.finalStatesIds.add(idToAdd);
                    }
                    ret.addTransition((Identificator)MapOfSeenPowerSets.get(currentRetId), (Identificator)MapOfSeenPowerSets.get(newId), c);
                    continue;
                }
                if (!allowTrashState) continue;
                if (!MapOfSeenPowerSets.containsKey(newId)) {
                    idToAdd = new Identificator(currentMaxStateId++);
                    ret.addState(idToAdd);
                    MapOfSeenPowerSets.put(newId, idToAdd);
                }
                ret.addTransition((Identificator)MapOfSeenPowerSets.get(currentRetId), (Identificator)MapOfSeenPowerSets.get(newId), c);
            }
            queue.remove();
        }
        SetOfIdentificators emptyState = new SetOfIdentificators();
        Identificator emptyStateInRet = (Identificator)MapOfSeenPowerSets.get(emptyState);
        if (allowTrashState && emptyStateInRet != null) {
            for (Character c : Variables.alphabet) {
                ret.addTransition(emptyStateInRet, emptyStateInRet, c);
            }
        }
        return ret;
    }

    public Automaton reverse() throws Exception {
        Automaton pom = new Automaton(this);
        Automaton ret = new Automaton();
        ret.initialStatesIds = pom.finalStatesIds;
        ret.finalStatesIds = pom.initialStatesIds;
        if (ret.finalStatesIds.isEmpty() || ret.initialStatesIds.isEmpty()) {
            return new Automaton();
        }
        ret.currentStateId = ret.initialStatesIds.iterator().next();
        for (Identificator id : pom.allStatesIds) {
            ret.addState(id);
        }
        for (Identificator pomStateFromId : pom.allStatesIds) {
            State s = this.idStateMap.get(pomStateFromId);
            for (Character c : Variables.alphabet) {
                if (s.get(c) == null) continue;
                for (Identificator pomStateToId : (SetOfIdentificators)s.get(c)) {
                    ret.addTransition(pomStateToId, pomStateFromId, c);
                }
            }
        }
        return ret;
    }

    public String toString() {
        String ret = "The states are " + this.allStatesIds.toString() + "\n" + "The transitions: \n";
        for (Identificator id : this.allStatesIds) {
            for (Character c : Variables.alphabet) {
                if (this.getState(id).getTransition(c) == null) continue;
                ret = ret + id.toString() + "-" + c + "->" + this.getState(id).getTransition(c) + "\n";
            }
        }
        ret = ret + "The initial states: " + this.initialStatesIds.toString() + "\n";
        ret = ret + "The final states: " + this.finalStatesIds.toString() + "\n";
        return ret;
    }

    public void print(FastPrint out, long counter) throws IOException, Exception {
        if (counter != -1L) {
            out.println("/" + Long.valueOf(counter).toString());
        }
        out.println(new Integer(this.allStatesIds.size()).toString());
        if (this.initialStatesIds.iterator().hasNext()) {
            out.println(this.initialStatesIds.iterator().next().toString());
        } else {
            out.println("-1");
        }
        out.println(new Integer(this.finalStatesIds.size()).toString());
        for (Identificator id : this.finalStatesIds) {
            out.println(id.toString());
        }
        out.println(new Integer(this.numberOfTransitions).toString());
        for (Identificator idFrom : this.allStatesIds) {
            for (Character c : Variables.alphabet) {
                if (this.getState(idFrom).getTransition(c) == null) continue;
                for (Identificator idTo : this.getState(idFrom).getTransition(c)) {
                    out.println(idFrom.toString() + " " + idTo.toString() + " " + c);
                }
            }
        }
        if (counter != -1L) {
            this.minimalDFA().print(out, -1L);
            out.println("----");
        }
        if (counter != -1L) {
            Variables.outputStream.println(this.getNumberOfStates() + " " + this.minimalDFA().getNumberOfStates());
        }
    }

    public int getNumberOfStates() {
        return this.allStatesIds.size();
    }

    public HashSet<Identificator> getInitialStatesIds() {
        return this.initialStatesIds;
    }

    public HashSet<Identificator> getFinalStatesIds() {
        return this.finalStatesIds;
    }

    public Automaton minimalDFA() throws Exception {
        if (this.cache_minDFA != null) {
            return this.cache_minDFA;
        }
        Automaton pom = new Automaton(this);
        Automaton cache_minDFA = pom.determinize(Variables.disableTrashState).reverse().determinize(Variables.disableTrashState).reverse().determinize(Variables.allowTrashState);
        return cache_minDFA;
    }

    public Automaton complement() {
        Automaton ret = new Automaton(this);
        SetOfIdentificators complementFinalStatesIds = new SetOfIdentificators();
        for (Identificator id : ret.allStatesIds) {
            if (ret.finalStatesIds.contains(id)) continue;
            complementFinalStatesIds.add(id);
        }
        ret.finalStatesIds = complementFinalStatesIds;
        return ret;
    }

    public boolean emptyLanguage() {
        if (this.finalStatesIds.isEmpty() || this.initialStatesIds.isEmpty()) {
            return true;
        }
        LinkedList<Identificator> queue = new LinkedList<Identificator>();
        HashSet<Identificator> seen = new HashSet<Identificator>();
        for (Identificator id : this.initialStatesIds) {
            queue.add(id);
            seen.add(id);
        }
        while (!queue.isEmpty()) {
            Identificator currentStateId = (Identificator)queue.peek();
            if (this.finalStatesIds.contains(currentStateId)) {
                return false;
            }
            for (Character c : Variables.alphabet) {
                if (this.getState(currentStateId).getTransition(c) == null) continue;
                for (Identificator id : this.getState(currentStateId).getTransition(c)) {
                    if (seen.contains(id)) continue;
                    queue.add(id);
                    seen.add(id);
                }
            }
            queue.remove();
        }
        return true;
    }

    private static Tuple hashFromMinDFA(Automaton minA) throws Exception {
        LinkedList<Identificator> statesToVisit = new LinkedList<Identificator>();
        statesToVisit.add(minA.initialStatesIds.iterator().next());
        SetOfIdentificators seen = new SetOfIdentificators();
        seen.add(minA.initialStatesIds.iterator().next());
        int counter = 0;
        HashMap renumberingMapFromCanonicalToMin = new HashMap();
        HashMap renumberingMapFromMinToCanonical = new HashMap();
        while (!statesToVisit.isEmpty()) {
            renumberingMapFromCanonicalToMin.put(counter, statesToVisit.peek());
            renumberingMapFromMinToCanonical.put(statesToVisit.peek(), counter);
            ++counter;
            for (Character c : Variables.alphabet) {
                for (Identificator id : minA.getState((Identificator)statesToVisit.peek()).getTransition(c)) {
                    if (seen.contains(id)) continue;
                    statesToVisit.add(id);
                    seen.add(id);
                }
            }
            statesToVisit.remove();
        }
        BigInteger mat = BigInteger.valueOf(0L);
        for (Character c : Variables.alphabet) {
            Matrix m = new Matrix(counter);
            for (int i = 0; i < counter; ++i) {
                Identificator idFrom = (Identificator)renumberingMapFromCanonicalToMin.get(i);
                for (Identificator idTo : minA.getState(idFrom).getTransition(c)) {
                    m.set(i, (Integer)renumberingMapFromMinToCanonical.get(idTo), true);
                }
            }
            mat = mat.shiftLeft(minA.numberOfStates() * minA.numberOfStates()).add(m.getNumericRepresentationDFA());
        }
        SetOfIdentificators canonicalFinalStates = new SetOfIdentificators();
        for (Identificator id : minA.finalStatesIds) {
            canonicalFinalStates.add(new Identificator((Integer)renumberingMapFromMinToCanonical.get(id)));
        }
        return new Tuple(mat, canonicalFinalStates.getBitMap());
    }

    private void dfsWordsSearch(int maxDepth, Identificator stateId, String currentWord, HashSet<String> generatedWords) throws Exception {
        if (maxDepth >= 0 && this.finalStatesIds.contains(stateId)) {
            generatedWords.add(new String(currentWord));
        }
        if (maxDepth == 0) {
            return;
        }
        if (this.transitionMap != null && stateId.getClass() == Identificator.class) {
            for (Character c : Variables.alphabet) {
                for (int id = 0; id < this.getNumberOfStates(); ++id) {
                    if (!this.transitionMap.get(c).get(stateId.getValue(), id)) continue;
                    this.dfsWordsSearch(maxDepth - 1, new Identificator(id), currentWord + c, generatedWords);
                }
            }
        } else {
            for (Character c : Variables.alphabet) {
                if (this.getState(stateId).getTransition(c) == null) continue;
                for (Identificator id : this.getState(stateId).getTransition(c)) {
                    this.dfsWordsSearch(maxDepth - 1, id, currentWord + c, generatedWords);
                }
            }
        }
    }

    public HashSet<String> allWordsOfLength(int n) throws Exception {
        HashSet<String> ret = new HashSet<String>();
        for (Identificator id : this.initialStatesIds) {
            this.dfsWordsSearch(n, id, "", ret);
        }
        return ret;
    }

    public BigInteger hashCodeFromWords(int length) throws Exception {
        HashSet<String> words = this.allWordsOfLength(length);
        BigInteger ret = BigInteger.ZERO;
        for (String word : words) {
            ret = ret.add(BigInteger.ONE.shiftLeft(Variables.wordToNumberMap.get(word)));
        }
        return ret;
    }

    public Tuple myHashCode() throws Exception {
        if (!this.hash_cache.equals(Tuple.minusOne())) {
            return this.hash_cache;
        }
        this.hash_cache = Automaton.hashFromMinDFA(this.minimalDFA());
        return this.hash_cache;
    }

    public void buildTransitionMap() {
        this.transitionMap = new HashMap();
        int maxId = 0;
        for (Identificator id : this.allStatesIds) {
            if (id.getValue() <= maxId) continue;
            maxId = id.getValue();
        }
        for (Character c : Variables.alphabet) {
            Matrix m = new Matrix(maxId + 1);
            for (Identificator idFrom : this.allStatesIds) {
                if (this.idStateMap.get(idFrom).getTransition(c) == null) continue;
                for (Identificator idTo : this.idStateMap.get(idFrom).getTransition(c)) {
                    m.set(idFrom.getValue(), idTo.getValue(), true);
                }
            }
            this.transitionMap.put(c, m);
        }
    }

    public static Automaton readAutomaton(Scanner s) throws FileNotFoundException, Exception {
        Automaton ret = new Automaton();
        while (!s.hasNextInt()) {
            if (!s.hasNext()) {
                return null;
            }
            s.nextLine();
        }
        int numberOfStates = s.nextInt();
        for (int i = 0; i < numberOfStates; ++i) {
            ret.addState(i);
        }
        int initialStateId = s.nextInt();
        ret.setInitialStateId(initialStateId);
        int numberOfFinalStates = s.nextInt();
        for (int i = 0; i < numberOfFinalStates; ++i) {
            ret.addFinalState(s.nextInt());
        }
        int numberOfTransitions = s.nextInt();
        for (int i = 0; i < numberOfTransitions; ++i) {
            int idFrom = s.nextInt();
            int idTo = s.nextInt();
            Character c = Character.valueOf(s.next().charAt(0));
            ret.addTransition(idFrom, idTo, c);
        }
        ret.buildTransitionMap();
        return ret;
    }
}

