/*
 * Decompiled with CFR 0.152.
 */
package bakalarka;

import bakalarka.Automaton;
import bakalarka.FastPrint;
import bakalarka.Identificator;
import bakalarka.IntegerIterator;
import bakalarka.Matrix;
import bakalarka.MatrixIterator;
import bakalarka.NaiveSubsetIterator;
import bakalarka.SubsetIterator;
import bakalarka.TransitionsIterator;
import bakalarka.Variables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AutomatonIterator
implements Iterator {
    SubsetIterator allSubsetsIterator;
    IntegerIterator allStatesIterator;
    TransitionsIterator allTransitionsIterator;
    HashMap<Character, Matrix> currentTransitions;
    HashSet<Identificator> currentFinalStatesIds;
    Identificator currentInitialStateId;
    Integer numberOfStates;
    private boolean hasNext;

    public void printState(FastPrint out) throws IOException {
        out.println("#allSubsetsIterator state");
        out.println("#allTransitionsIterator state");
        out.println("#alphabet size");
        out.println("#charcter of alphabet followed by numeric representation of incidence matrix");
        out.println(Long.valueOf(this.allSubsetsIterator.state).toString());
        out.println(Long.valueOf(this.allTransitionsIterator.state).toString());
        out.println(Integer.valueOf(Variables.alphabet.size()).toString());
        for (Character c : Variables.alphabet) {
            out.println(c.toString());
            out.println(this.allTransitionsIterator.currentMatrices.get(c).getNumericRepresentation().toString());
        }
        out.println("#finish of Automaton iterator backup");
    }

    public AutomatonIterator(int n) throws Exception {
        if (n == 0) {
            this.numberOfStates = 0;
            return;
        }
        this.hasNext = true;
        this.numberOfStates = n;
        this.allTransitionsIterator = new TransitionsIterator(n);
        this.currentTransitions = this.allTransitionsIterator.next();
        this.allSubsetsIterator = new SubsetIterator(n);
        this.currentFinalStatesIds = this.allSubsetsIterator.next();
        this.allStatesIterator = new IntegerIterator(1);
        this.currentInitialStateId = this.allStatesIterator.next();
    }

    public void skip() {
        if (!this.hasNext()) {
            return;
        }
        this.checkNext();
        if (!this.allStatesIterator.hasNext()) {
            this.allStatesIterator = new IntegerIterator(1);
            this.allStatesIterator.skip();
            if (!this.allSubsetsIterator.hasNext()) {
                this.allSubsetsIterator = new SubsetIterator(this.numberOfStates);
                this.currentFinalStatesIds = this.allSubsetsIterator.next();
                this.currentTransitions = this.allTransitionsIterator.next();
            } else {
                this.currentFinalStatesIds = this.allSubsetsIterator.next();
            }
        } else {
            this.currentInitialStateId = this.allStatesIterator.next();
        }
    }

    public Automaton next() {
        if (!this.hasNext()) {
            return null;
        }
        this.checkNext();
        Automaton ret = new Automaton();
        try {
            ret = new Automaton(this.currentTransitions, this.currentInitialStateId, this.currentFinalStatesIds);
        }
        catch (Exception ex) {
            Logger.getLogger(AutomatonIterator.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (!this.allStatesIterator.hasNext()) {
            this.allStatesIterator = new IntegerIterator(1);
            this.currentInitialStateId = this.allStatesIterator.next();
            if (!this.allSubsetsIterator.hasNext()) {
                this.allSubsetsIterator.reset();
                this.currentFinalStatesIds = this.allSubsetsIterator.next();
                this.currentTransitions = this.allTransitionsIterator.next();
            } else {
                this.currentFinalStatesIds = this.allSubsetsIterator.next();
            }
        } else {
            this.currentInitialStateId = this.allStatesIterator.next();
        }
        return ret;
    }

    private boolean checkNext() {
        boolean ret = this.hasNext;
        if (this.allStatesIterator.hasNext() || this.allSubsetsIterator.hasNext() || this.allTransitionsIterator.hasNext()) {
            this.hasNext = true;
            return this.hasNext;
        }
        this.hasNext = false;
        return ret;
    }

    @Override
    public boolean hasNext() {
        if (this.numberOfStates == 0) {
            return false;
        }
        return this.hasNext;
    }

    public Automaton random() throws Exception {
        MatrixIterator matrixIt = new MatrixIterator(this.numberOfStates);
        NaiveSubsetIterator subsetIt = new NaiveSubsetIterator(this.numberOfStates);
        HashMap<Character, Matrix> transitions = new HashMap<Character, Matrix>();
        ArrayList<Matrix> arr = new ArrayList<Matrix>();
        while (true) {
            Matrix union = new Matrix(0);
            for (Character c : Variables.alphabet) {
                arr.add(matrixIt.random());
                union = ((Matrix)arr.get(arr.size() - 1)).union(union);
            }
            if (union.isConnected()) break;
            arr.clear();
        }
        for (int i = 0; i < arr.size(); ++i) {
            transitions.put(Variables.alphabet.get(i), (Matrix)arr.get(i));
        }
        return new Automaton(transitions, new Identificator(0), subsetIt.random());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

