/*
 * Decompiled with CFR 0.152.
 */
package bakalarka;

import bakalarka.Identificator;
import java.util.HashSet;
import java.util.Iterator;

public class SetOfIdentificators
extends HashSet<Identificator> {
    int hash_cache = -1;
    private boolean hasIntegerIdentificatorsOnly = true;
    private int bitMap = 0;
    private int size = 0;

    public SetOfIdentificators(HashSet<Identificator> statesSet) {
        for (Identificator id : statesSet) {
            this.add(id);
        }
    }

    public SetOfIdentificators() {
    }

    public SetOfIdentificators copy() {
        SetOfIdentificators ret = new SetOfIdentificators();
        ret.bitMap = this.bitMap;
        ret.hasIntegerIdentificatorsOnly = this.hasIntegerIdentificatorsOnly;
        if (!this.hasIntegerIdentificatorsOnly) {
            for (Identificator x : this) {
                ret.add(x.copy());
            }
        }
        ret.hash_cache = this.hash_cache;
        return ret;
    }

    @Override
    public boolean add(Identificator x) {
        this.hash_cache = -1;
        boolean ret = (this.bitMap >> x.getValue()) % 2 == 0;
        this.bitMap |= 1 << x.getValue();
        if (ret) {
            ++this.size;
        }
        return ret;
    }

    @Override
    public boolean contains(Object obj) {
        if (this.hasIntegerIdentificatorsOnly) {
            if (obj.getClass() == Identificator.class) {
                return (this.bitMap >> ((Identificator)obj).getValue()) % 2 == 1;
            }
            return false;
        }
        return super.contains(obj);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<Identificator> iterator() {
        if (!this.hasIntegerIdentificatorsOnly) {
            return super.iterator();
        }
        Iterator<Identificator> it = new Iterator<Identificator>(){
            private int state;
            private int index;
            {
                this.state = SetOfIdentificators.this.bitMap;
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.state > 0;
            }

            @Override
            public Identificator next() {
                while (this.state % 2 != 1) {
                    this.state >>= 1;
                    ++this.index;
                }
                this.state >>= 1;
                return new Identificator(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
        return it;
    }

    @Override
    public int hashCode() {
        if (this.hash_cache != -1) {
            return this.hash_cache;
        }
        if (!this.hasIntegerIdentificatorsOnly) {
            this.hash_cache = super.hashCode();
            return this.hash_cache;
        }
        this.hash_cache = this.bitMap;
        return this.hash_cache;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetOfIdentificators other = (SetOfIdentificators)obj;
        if (other.hasIntegerIdentificatorsOnly && this.hasIntegerIdentificatorsOnly) {
            return other.hashCode() == this.hashCode();
        }
        if (other.hashCode() != this.hashCode()) {
            return false;
        }
        return super.equals(other);
    }

    public int getBitMap() throws Exception {
        if (this.hasIntegerIdentificatorsOnly) {
            return this.bitMap;
        }
        throw new Exception("THIS POWER SET DOES NOT CONTAIN BIT MAP");
    }
}

