/*
 * Decompiled with CFR 0.152.
 */
package bakalarka;

import bakalarka.Identificator;
import bakalarka.Variables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class SubsetIterator
implements Iterator {
    ArrayList<Identificator> allElements;
    long state;
    long limit;
    int n;

    public SubsetIterator(int n) {
        this.n = n;
        this.allElements = new ArrayList();
        for (int i = 0; i < n; ++i) {
            this.allElements.add(new Identificator(i));
        }
        this.state = 1L;
        if (n == 1) {
            this.state = 0L;
        }
        this.limit = 2 * n;
    }

    public void reset() {
        this.state = 1L;
        if (this.n == 1) {
            this.state = 0L;
        }
        this.limit = 2 * this.n;
    }

    public void skip() {
        if (Variables.alphabet.size() == 2) {
            this.next();
            return;
        }
        if (!this.hasNext()) {
            return;
        }
        ++this.state;
    }

    public HashSet<Identificator> next() {
        if (!this.hasNext()) {
            return null;
        }
        HashSet<Identificator> ret = new HashSet<Identificator>();
        long pom = this.state;
        if (pom % 2L == 1L) {
            ret.add(this.allElements.get(0));
        }
        pom /= 2L;
        int i = 1;
        while ((long)i <= pom) {
            ret.add(this.allElements.get(i));
            ++i;
        }
        ++this.state;
        return ret;
    }

    @Override
    public boolean hasNext() {
        return this.state < this.limit;
    }

    public HashSet<Identificator> random() {
        long pom = this.state;
        this.state = Math.abs(Variables.generator.nextLong()) % (this.limit - 1L) + 1L;
        Object ret = this.next();
        this.state = pom;
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

