#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include "tpl.h"

#include "config.h"
#include "controller.h"
#include "node.h"
#include "debug.h"

const int MAX_MSG_SIZE = 255;

static int nodes_count;
static int tpl_count;
static int my_id;
static int schedule[MAX_TRANSACTIONS];
static int schedule_length;

static void read_config(void);

int main(int argc, char **argv)
{
  read_config();
  nodes_count = config_get_nodes_count();
  tpl_count = nodes_count + 1;
  tpl_initialize(&tpl_count, &my_id, &argc, &argv);

  switch (my_id)
  {
    case ID_CONTROLLER:
      debug_print(3, "%d", my_id);
      controller_init(nodes_count, schedule_length, schedule);
      break;
    default:
      debug_print(3, "%d", my_id);
      node_start_server(my_id, nodes_count);
      break;
  }

  tpl_deinitialize();
  return 0;
}

static void read_config(void)
{
    int i, temp;
    FILE *fp;

    if ((fp=fopen("config.txt","r")) == NULL)
    {
        printf("Cannot open file.\n");
    }

    fscanf(fp, "%d", &temp);
    printf("Starting protocol with %d nodes\n", temp);
    config_set_nodes_count(temp);

    fscanf(fp, "%d", &schedule_length);
    printf("Schedule has %d transactions\n", schedule_length);

    for (i=0; i<schedule_length; i++)
    {
        fscanf(fp, "%d\n", &schedule[i]);
    }
}

