#ifndef TRANSACTION_H_INCLUDED
#define TRANSACTION_H_INCLUDED

struct transaction_struct{

    struct transaction_struct *next;
    long id;
    int status;
    int coordinator;
};
typedef struct transaction_struct transaction;

struct transaction_list_struct
{
    struct transaction_struct *first;
    struct transaction_struct *last;
    int count;
};
typedef struct transaction_list_struct transaction_list;


enum transaction_status {
    TRANSACTION_CREATED = 1,
    TRANSACTION_COMMITED = 2,
    TRANSACTION_ABORTED = 3
};

transaction* transaction_begin(int transaction_id, int node_id, int coordinator);
void transaction_commit(transaction *t);
void transaction_abort(transaction *t);
void transaction_print(transaction *t);

transaction_list* transaction_list_create(void);
int transaction_list_add(transaction_list *list, transaction *t);
int transaction_list_remove(transaction_list *list, transaction *t);
void transaction_list_print(transaction_list *t);
transaction* transaction_list_find(transaction_list *list, long id);


#endif /* TRANSACTION_H_INCLUDED */
