#ifndef CONFIG_H_INCLUDED
#define CONFIG_H_INCLUDED

#define TRUE 1
#define FALSE 0

#define MAX_NODES 20
#define MAX_TRANSACTIONS 1000

enum
{
    DEBUG_MESSAGE = 3,
    DEBUG_START_STOP = 4,
    DEBUG_MUTEX = 5,
    DEBUG_SLEEP_WAKE = 6,
    DEBUG_MESSAGE_LIST = 7,
    DEBUG_CONTROLLER = 8,
    DEBUG_MESSAGE_SPECIAL = 9,
    DEBUG_VOTES = 10,
    DEBUG_VOTE_DATA = 11,
    DEBUG_COMMIT_ABORT = 12,
    DEBUG_TRANSACTION_COMPLETE = 13,
    DEBUG_TEMP = 255
};

static const int DEBUG = 2;
static const int DEBUG_LIST_COUNT = 4;
static const int DEBUG_LIST[] = {DEBUG_TRANSACTION_COMPLETE, DEBUG_COMMIT_ABORT, DEBUG_MESSAGE_LIST, DEBUG_VOTES};

static const int LOG_LEVEL = 0;

enum
{
  NODE_NULL = -1,
  ID_CONTROLLER = 0
};

enum
{
    VOTE_YES = 1,
    VOTE_NO = 2,
    VOTE_NONE = 0
};

enum {
 MESSAGE_NULL = -2,

 MESSAGE_2PC_VOTE_REQ = 101,
 MESSAGE_2PC_VOTE_YES = 102,
 MESSAGE_2PC_VOTE_NO = 103,
 MESSAGE_2PC_COMMIT = 104,
 MESSAGE_2PC_ABORT = 105,

 MESSAGE_SHUTDOWN = 155,

 CMESSAGE_TRANSACTION_BEGIN = 201,
 CMESSAGE_TRANSACTION_COMMIT = 202,
 CMESSAGE_TRANSACTION_ABORT = 203,
 CMESSAGE_SHUTDOWN_ACKNOWLEDGMENT = 254,
 CMESSAGE_SHUTDOWN = 255
};

int config_get_nodes_count(void);
void config_set_nodes_count(int count);

#endif /* CONFIG_H_INCLUDED */
