#include <stdio.h>
#include <unistd.h>

#include "controller.h"
#include "debug.h"
#include "config.h"

#include "tpl.h"

static int nodes_count;
static int schedule_length;
static int *schedule;

int controller_match(int sender, int tag, void *message)
{
    return 1;
}

void controller_init(int nodes, int schedlength, int *_schedule)
{
    nodes_count = nodes;
    schedule_length = schedlength;
    schedule = _schedule;

    controller_run();
}

void controller_run(void)
{
    controller_schedule();
    /*sleep(1);*/
    controller_stop_all();
}

void controller_schedule(void)
{
    void *message/*, *response*/;
    int i;

    /* DEBUG */
    /*schedule_length = 5;
    schedule[0] = 1;
    schedule[1] = 1;
    schedule[2] = 2;
    schedule[3] = 4;
    schedule[4] = 3;*/

    for (i=0; i<schedule_length; i++)
    {
        tpl_create(&message);
        tpl_pkbyte(message, &i, sizeof(int));
        tpl_send(&schedule[i], 1, CMESSAGE_TRANSACTION_BEGIN, message);
        debug_print(DEBUG_CONTROLLER, "Controller sent message TRANSACTION_BEGIN\n");
    }


}

void controller_stop_all(void)
{
    void *message, *response;
    int i, sender, tag, all_down;
    int running[MAX_NODES];

    all_down = 0;
    for (i=1; i<=nodes_count; i++)
    {
        running[i] = 1;
        tpl_create(&message);
        tpl_pkbyte(message, &schedule_length, sizeof(int));
        tpl_send(&i, 1, CMESSAGE_SHUTDOWN, message);
        debug_print(DEBUG_CONTROLLER, "Controller sent message MESSAGE_SHUTDOWN\n");
    }

    while (!all_down)
    {
        tpl_recv(controller_match, &sender, &tag, &response);
        debug_print(DEBUG_CONTROLLER, "Controller received message %d %d\n", sender, tag);
        tpl_destroy(response);
        if (tag == CMESSAGE_SHUTDOWN_ACKNOWLEDGMENT)
        {
            running[sender] = 0;
            debug_print(100, "DB server %d is down\n", sender);
        }

        all_down = 1;
        for (i=1; i<=nodes_count; i++)
        {
            if (running[i])
            {
                debug_print(100, "DB server %d is still running\n", i);
                all_down = 0;
            }
        }
    }

}
