#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>

#include "message.h"
#include "debug.h"
#include "config.h"

message message_create(int sender, int tag, void* msg)
{
    message m;
    m.sender = sender;
    m.tag = tag;
    m.message = msg;
    m.next = NULL;
    return m;
}

void message_print(message *m)
{
    if (m!=NULL)
    {
        debug_print(DEBUG_MESSAGE_SPECIAL, "M: (S)%d (T)%d\n", m->sender, m->tag);
    }
}


int message_list_put(message_list *list, int sender, int tag, void *msg)
{
    message *message_new;

    if (list == NULL)
    {
        printf("Error: Uninicialized message list\n");
        return 0;
    }

    message_new = (message*)malloc(sizeof(message));
    if (message_new == NULL)
    {
        printf("Error: Insufficient memory\n");
        return 0;
    }
    else
    {
        message_new->sender = sender;
        message_new->tag = tag;
        message_new->message = msg;
        message_new->next = NULL;

        if (list->first == NULL)
        {
            list->first = message_new;
            list->last = message_new;
        }
        else
        {
            list->last->next = message_new;
            list->last = list->last->next;
        }
        /*node_print_message_list();*/
        return 1;
    }

}

message message_list_get(message_list *list)
{
    message m, *temp;
    m.message = NULL;
    m.next = NULL;

    if (list == NULL)
    {
        printf("Error: Uninicialized message list\n");
        m.tag = MESSAGE_NULL;
        m.sender = NODE_NULL;
        return m;
    }

    if (list->first != NULL)
    {
      m = *list->first;
      temp = list->first;
      list->first = list->first->next;
      free(temp);
    }
    else
    {
        m.tag = MESSAGE_NULL;
        m.sender = NODE_NULL;
    }
    return m;
}

message_list* message_list_create(void)
{
    message_list *list = (message_list*)malloc(sizeof(message_list));
    list->first = NULL;
    list->last = NULL;
    list->count = 0;
    return list;
}

void message_list_print(message_list *list)
{
    message *temp;
    temp = list->first;

    while (temp != NULL)
    {
        debug_print(DEBUG_MESSAGE_LIST, "ML: (S)%d (T)%d\n", temp->sender, temp->tag);
        temp = temp->next;
    }
}
