#include <stdlib.h>
#include <stdio.h>

#include "transaction.h"

transaction* transaction_begin(int transaction_id, int node_id, int coordinator)
{
    transaction *t;
    t = (transaction*)malloc(sizeof(transaction));
    t->id = transaction_id;
    t->status = TRANSACTION_CREATED;
    t->coordinator = coordinator;
    t->next = NULL;
    return t;
}

void transaction_print(transaction *t)
{
    if (t!=NULL)
    {
        printf("Transaction %ld: status:%d coord:%d \n", t->id, t->status, t->coordinator);
    }
    else
    {
        printf("Transaction is empty\n");
    }
}


transaction_list* transaction_list_create(void)
{
    transaction_list *list;
    list = (transaction_list*)malloc(sizeof(transaction_list));
    list->first = NULL;
    list->last = NULL;
    list->count = 0;
    return list;
}

int transaction_list_add(transaction_list *list, transaction *t)
{
    if (list == NULL)
    {
        printf("Error: Uninicialized message list\n");
        return 0;
    }

    if (list->first == NULL)
    {
        list->first = t;
        list->last = t;
    }
    else
    {
        list->last->next = t;
        list->last = list->last->next;
    }
    list->count++;
    return 1;
}

void transaction_list_print(transaction_list *list)
{
    transaction *temp = list->first;

    while (temp != NULL)
    {
        transaction_print(temp);
        temp = temp->next;
    }
}

transaction* transaction_list_find(transaction_list *list, long id)
{
    transaction *temp = list->first;

    while (temp != NULL)
    {
        if (temp->id == id)
        {
            return temp;
        }
        temp = temp->next;
    }
    return NULL;
}
