import java.awt.*;
//import static java.lang.Math.random;
//import static java.lang.Math.round;

public class AANode extends BSTNode {
  int level = 1;
  public AANode (DataStructure D, int key, int x, int y) { super (D, key, x, y); }
  public AANode (DataStructure D, int key) { this (D, key, -10, -10); }
  public AANode (BSTNode v) { this (v.D, v.key, v.x, v.y); }

  public void draw (Graphics g) {
    if (key != NULL) {
      drawBg (g);
      drawKey (g);
      Font font = new Font("Helvetica", Font.PLAIN, 7);
      FontMetrics fm = g.getFontMetrics(font);
      String str = new String(""+level);
      g.setFont(font);
      g.drawString(str, x+D.radius, y-D.radius);
    }
  }

  public void rebox() {
    leftw = (left==null) ? D.xspan + D.radius : left.leftw + left.rightw;
    rightw = (right==null) ? D.xspan + D.radius : right.leftw + right.rightw;
  }

  public void reboxTree() {
    if (left != null) left.reboxTree();
    if (right != null) right.reboxTree();
    rebox();
  }

  private void repos() {
    if (isRoot()) goToRoot();
    if (left != null) {
      if (((AA)D).mode23)
        left.goTo (this.tox-left.rightw,
                   this.toy+(((AANode)left).level==level ? D.yspan : 2*D.radius + D.yspan));
      else left.goTo (this.tox-left.rightw, this.toy + 2*D.radius + D.yspan);
      ((AANode)left).repos();
    }
    if (right != null) {
      if (((AA)D).mode23)
        right.goTo (this.tox+right.leftw,
                    this.toy+(((AANode)right).level==level ? D.yspan : 2*D.radius + D.yspan));
      else right.goTo (this.tox+right.leftw, this.toy + 2*D.radius + D.yspan);
      ((AANode)right).repos();
    }
  }

  public void _reposition() {
    reboxTree();
    repos();
  }
}
