import java.awt.*;

public class BNode extends Node {
  int leftw, rightw;
  BNode parent=null;
  int numKeys = 1, numChildren=0;
  int[] key;
  BNode[] c;
  
  // statistics
  int nkeys = 1, nnodes = 1, height = 1;

  public BNode (DataStructure D, int key, int x, int y) {
    this.key = new int[((BTree)D).order+5];
    c = new BNode[((BTree)D).order+5];
    this.key[0] = key; numKeys = 1;
    this.D = D; this.x = tox = x; this.y = toy = y; steps = 0;
    setColor (Color.black, NORMAL);
  }
  public BNode (DataStructure D, int key) { this (D, key, -10, -10); }

  public BNode (BNode v) { this (v.D, v.key[0], v.x, v.y); }
  public BNode (BNode u, BNode v, BNode w) {
    this (u.D, Node.NOKEY, v.x, v.y);
    int n1=u.numKeys, n2=w.numKeys;
    numKeys = n1 + 1 + n2;
    for (int i=0; i<n1; ++i) key[i] = u.key[i];
    key[n1] = v.key[0];
    for (int i=0; i<n2; ++i) key[n1+1+i] = w.key[i];
    n1 = u.numChildren; n2 = w.numChildren;
    numChildren = n1 + n2;
    for (int i=0; i<n1; ++i) c[i] = u.c[i];
    for (int i=0; i<n2; ++i) c[n1+i] = w.c[i];
    for (int i=0; i<numChildren; ++i) c[i].parent = this;
  }

  public boolean isRoot() { return parent==null; }
  public boolean isLeaf() { return numChildren==0; }

/*  public boolean isLeft() { return parent.left==this; }
  public void linkleft(BSTNode v) { left = v; v.parent = this; }
  public void linkright(BSTNode v) { right = v; v.parent = this; }
  public void isolate() { left = right = parent = null; } */

  public String toString() {
    String s = "[" + key[0];
    for (int i=1; i<numKeys; ++i) s += "|" + key[i];
    return s + "]";
  }

  public void calcTree() {
    nkeys = numKeys; nnodes = 1;
    for (int i = 0; i < numChildren; ++i) {
      c[i].calcTree();
      nkeys += c[i].nkeys;
      nnodes += c[i].nnodes;
    }
    height = 1 + (isLeaf() ? 0 : c[0].height);
  }

  public void addLeaf (int x) {
    key[numKeys++] = x;
    for (int i=numKeys-1; i>0; --i)
      if (key[i] < key[i-1]) {
        int tmp=key[i]; key[i]=key[i-1]; key[i-1]=tmp;
      }
  }

  public int order() {
    for (int i=0; i<parent.numChildren; ++i)
      if (parent.c[i] == this) return i;
    return -5;
  }

  public void add (int k, BNode v) {
    for (int i=numKeys; i>k; --i) {
      key[i] = key[i-1];
      c[i+1] = c[i];
    }
    ++numKeys; ++numChildren;
    key[k] = v.key[0];
    c[k] = v.c[0]; c[k].parent = this;
    c[k+1] = v.c[1]; c[k+1].parent = this;
  }

  public boolean isIn (int x) {
    for (int i=0; i<numKeys; ++i) 
      if (key[i] == x) return true;
    return false;
  }

  public BNode way (int x) {
    if (x < key[0]) return c[0];
    for (int i=1; i<numKeys; ++i)
      if (x < key[i]) return c[i];
    return c[numKeys];
  }

  public int search (int x) {
    if (x < key[0]) return 0;
    for (int i=1; i<numKeys; ++i)
      if (x < key[i]) return i;
    return numKeys;
  }

  public BNode split() {
    int r = numKeys * D.radius;
    int k=numKeys, ku=numKeys/2, kw=numKeys-ku-1;
    BNode u = new BNode (D, key[0], x-r+ku*D.radius, y),
          v = new BNode (D, key[numKeys/2], x-r+(ku+3)*D.radius, y),
          w = new BNode (D, key[numKeys-1], x+r-kw*D.radius, y);
    for (int i=1; i<numKeys/2; ++i) u.addLeaf (key[i]);
    for (int i=numKeys/2+1; i<numKeys-1; ++i) w.addLeaf (key[i]);
    if (isLeaf()) u.numChildren = w.numChildren = 0;
    else {
      u.numChildren = (numChildren+1)/2;
      w.numChildren = numChildren/2;
      for (int i=0; i < u.numChildren; ++i) { u.c[i] = c[i]; u.c[i].parent = u; }
      for (int i=0; i < w.numChildren; ++i) { w.c[i] = c[u.numChildren+i]; w.c[i].parent = w; }
    }
    u.parent = w.parent = v;
    v.numChildren = 2; v.parent = parent;
    v.c[0] = u; v.c[1] = w;
    return v;
  }

  public BNode del (int k) {
    int i=-1;
    while (key[++i] != k); int p=i;
    for (--numKeys; i<numKeys; i++) key[i] = key[i+1];
    return new BNode (D, k, x-(numKeys+1-2*p)*D.radius, y);
  }

  public BNode delMin() {
    int r = key[0]; --numKeys;
    for (int i=0; i<numKeys; ++i) key[i] = key[i+1];
    return new BNode (D, r, x-(numKeys-1)*D.radius, y);
  }

  public BNode delMinCh() {
    BNode r = c[0]; --numChildren;
    for (int i=0; i<numChildren; ++i) c[i] = c[i+1];
    return r;
  }

  public BNode delMax() {
    return new BNode (D, key[--numKeys], x+(numKeys-1)*D.radius, y);
  }

  public BNode delMaxCh() {
    return c[--numChildren];
  }

  public void insMin (int k) {
    for (int i=numKeys++; i>0; --i) key[i] = key[i-1];
    key[0] = k;
  }

  public void insMinCh (BNode v) {
    for (int i=numChildren++; i>0; --i) c[i] = c[i-1];
    c[0] = v;
  }

  public void insMax(int k) {
    key[numKeys++] = k;
  }

  public void insMaxCh (BNode v) {
    c[numChildren++] = v;
  }

  public void replace (int x, int y) {
    int i=-1;
    while (key[++i] != x);
    key[i] = y;
  }

  public void drawBg (Graphics g) {
    int r = Math.max (numKeys, 1) * D.radius;
    int d = 2 * r;
    g.setColor (bgcolor);
    g.fillOval (x-r, y-D.radius, d, 2*D.radius);
    g.setColor (fgcolor);
    g.drawOval (x-r, y-D.radius, d, 2*D.radius);
//    g.drawLine (x-leftw, y+2, x+rightw, y-2);
  }

  public void drawKey (Graphics g) {
    if (key[0] != Node.NOKEY && numKeys>0) {
      String str = ""+key[0];
      if (key[0] == INF) str = "\u221e";
      if (key[0] == -INF) str = "-\u221e";
      for (int i=1; i<numKeys; ++i) str = str + "  " + key[i];
      Font font = new Font("Helvetica", Font.PLAIN, D.fontsize);
      FontMetrics fm = g.getFontMetrics(font);
      g.setFont (font);
      g.drawString (str, x-fm.stringWidth(str)/2, y-fm.getHeight()/2+fm.getAscent());
    }
  }

  public void drawTree (Graphics g) {
    for (int i=0; i<numChildren; ++i) {
      g.setColor (Color.black);
      g.drawLine (x, y, c[i].x, c[i].y);
      c[i].drawTree (g);
    }
    draw (g);
  }

  public void moveTree() {
    for (int i=0; i<numChildren; ++i) c[i].moveTree();
    move();
  }

  public void rebox() {
    if (numChildren == 0) {
      leftw = rightw = numKeys * D.radius + D.xspan;
    } else {
      if (numChildren%2==0) leftw = rightw = 0;
      else { leftw = c[numChildren/2].leftw; rightw = c[numChildren/2].rightw; }
      for (int i=0; i<numChildren/2; ++i) leftw += c[i].leftw + c[i].rightw;
      for (int i=(numChildren+1)/2; i<numChildren; ++i) rightw += c[i].leftw + c[i].rightw;
    }
  }
  
  public void reboxTree() {
    for (int i=0; i<numChildren; ++i) c[i].reboxTree();
    rebox();
  }

  private void repos() {
    if (isRoot()) goToRoot();
    int x = this.tox, x2 = this.tox, y = this.toy + 2*D.radius + D.yspan;
    if (numChildren == 0) return;
    if (numChildren%2 == 0) {
      int k = numChildren/2-1;
      c[k].goTo (x -= c[k].rightw, y); c[k].repos();
      for (int i = k-1; i>=0; --i) {
        c[i].goTo (x -= c[i+1].leftw + c[i].rightw, y); c[i].repos();
      }
      c[++k].goTo (x2 += c[k].leftw, y); c[k].repos();
      for (int i = k+1; i<numChildren; ++i) {
        c[i].goTo (x2 += c[i-1].rightw + c[i].leftw, y); c[i].repos();
      }
    } else {
      int k = numChildren/2;
      c[k].goTo (x, y); c[k].repos();
      for (int i=1; i<=k; ++i) {
        c[k-i].goTo (x -= c[k-i].rightw + c[k-i+1].leftw, y); c[k-i].repos();
        c[k+i].goTo (x2 += c[k+i].leftw + c[k+i-1].rightw, y); c[k+i].repos();
      }
    }
  }

  public void _reposition() {
    reboxTree();
    repos();
  }

  public void goTo (BNode v) {
    int x=key[0], p=v.numKeys;
    for (int i=0; i<p; ++i) if (x <= v.key[i]) p=i;
    int r = v.numKeys * D.radius;
    goTo (v.tox-r+2*D.radius*p, v.toy);
  }
  /*public void goAbove (BNode v) { 
    int x=key[0], p=v.numKeys;
    for (int i=0; i<p; ++i) if (x <= v.key[i]) p=i;
    int r = v.numKeys * D.radius;
    goTo (v.tox-r+2*D.radius*p, v.toy - 2*D.radius - D.yspan); 
  }*/
}
