import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.*;

public class BTree extends Dictionary implements ChangeListener {
  int order = 5;
  BNode root = null, v = null;
  JSpinner OS = new JSpinner (new SpinnerNumberModel (5, 3, 20, 1)); 

  public BTree (main M) { super (M); }

  public void insert (int x) { start (new BInsert (this, x)); }
  public void find (int x) { start (new BFind (this, x)); }
  public void delete (int x) { start (new BDelete (this, x)); }
  public void clear () { root = null; setStats(); }
  public void clean () { v = null; }

  public String stats() {
    if (root == null) return "#Nodes: 0;   #Keys: 0 = 0% full;   Height: 0";
    else {
      root.calcTree();
      return "#Nodes: " + root.nnodes + ";   "
           + "#Keys: "+root.nkeys+" = "+(100*root.nkeys)/(root.nnodes*(order-1))+"% full;   "
           + "Height: " + root.height;
    }
  }

  public void draw (Graphics g) {
    if (root != null) { root.moveTree(); root.drawTree(g); }
    if (v != null) { v.move(); v.draw(g); }
  }

  public void resize () {
    if (M.small) {
      radius = 5;
      xspan = 2;
      yspan = 2;
      fontsize = 5;
    } else {
      radius = 10;
      xspan = 5;
      yspan = 5;
      fontsize = 11;
    }
    swidth = M.S.size.width;
    sheight = M.S.size.height;
    rootx = swidth/2;
    rooty = 5*radius + yspan;
    if (root != null) reposition();
  }

  public void reposition () { if (root != null) root._reposition (); }

  public void otherButtons (JPanel P) {
    OS.addChangeListener (this);
    P.add (OS);
  }

  public void stateChanged (ChangeEvent evt) {
    if (evt.getSource() == OS) {
      order = (Integer)OS.getValue();
      clear();
      reposition();
    }
  }
}
