import java.awt.event.*;
import javax.swing.*;
import java.util.*;

abstract public class Dictionary extends DataStructure {
  public Dictionary (main M) { super (M); }

  public int getNumButtons() { return 3; }

  abstract public void insert (int x);
  abstract public void find (int x);
  abstract public void delete (int x);

  public JButton getButton (int i) {
    JButton b=null;
    switch (i) {
      case 0: b = new JButton(M.msg.getString ("insert"));
              b.setMnemonic(KeyEvent.VK_I);
              break;
      case 1: b = new JButton(M.msg.getString ("find"));
              b.setMnemonic(KeyEvent.VK_F);
              break;
      case 2: b = new JButton(M.msg.getString ("delete"));
              b.setMnemonic(KeyEvent.VK_D);
              break;
    }
    return b;
  }

  public void action (int i, Vector<Integer> args) {
    switch (i) {
      case 0: if (args.size() == 0) {
                Random g = new Random (System.currentTimeMillis());
                insert (g.nextInt (100));
              } else for (int x : args) insert (x);
              break; 
      case 1: if (args.size() > 0) find (args.firstElement());
              break;
      case 2: for (int x : args) delete (x);
              break;
    }
    M.B.disableNext();
  }
}
