import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.*;

public class GBTree extends BST implements ChangeListener {
  double alpha = 1.01;
  int del = 0;
  JSpinner AS = new JSpinner (new SpinnerNumberModel (1.3, 1.01, 5, 0.1));

  public GBTree (main M) { super (M); }

  public void insert (int x) { start (new GBInsert (this, x)); }
  public void find (int x) { start (new GBFind (this, x)); }
  public void delete (int x) { start (new GBDelete (this, x)); }
  public void clear() { del = 0; root = null; setStats(); }
  public void clean() { v = null; }

  public void draw (Graphics g) {
    if (root != null) { root.moveTree(); root.drawTree(g); }
    if (v != null) { v.move(); v.draw(g); }
  }

  public String stats() {
    if (root == null) return "#Nodes: 0;   #Deleted: 0;   Height: 0 =  1.00\u00b7opt;   Ave. depth: 0";
    else {
      root.calcTree();
      return "#Nodes: " + root.size + ";   #Deleted: " + del
           + ";   Heigh: " + root.height + " = "
           + format (root.height/(double)(Math.floor(lg(root.size-del))+1), 2, 5)
           + "\u00b7opt;   Ave. depth: " + format (root.sumh/(double)root.size, 2, -5);
    }
  }

  public void otherButtons (JPanel P) {
    AS.addChangeListener (this);
    P.add (AS);
  }

  public void stateChanged (ChangeEvent evt) {
    if (evt.getSource() == AS) alpha = (Double)AS.getValue();
  }
}
