import java.awt.event.*;
import javax.swing.*;
import java.util.*;

abstract public class PriorityQueue extends DataStructure {
  public PriorityQueue (main M) { super (M); }

  public int getNumButtons() { return 2; }

  abstract public void insert (int x);
  abstract public void delete();

  public JButton getButton (int i) {
    JButton b=null;
    switch (i) {
      case 0: b = new JButton(M.msg.getString ("insert"));
              b.setMnemonic(KeyEvent.VK_I);
              break;
      case 1: b = new JButton(M.msg.getString ("deletemax"));
              b.setMnemonic(KeyEvent.VK_D);
              break;
    }
    return b;
  }

  public void action (int i, Vector<Integer> args) {
    switch (i) {
      case 0: if (args.size() == 0) {
                Random g = new Random (System.currentTimeMillis());
                insert (g.nextInt (100));
              } else for (int x : args) insert (x);
              break;
      case 1: delete(); break;
    }
    M.B.disableNext();
  }
}
