import java.awt.*;

public class SkipList extends Dictionary {
  SkipNode root, sent, v = null;
  int height = 1, n=0, e=0;

  public SkipList (main M) { 
    super (M);
    root = new SkipNode (this, -Node.INF); 
    root.linkright (sent = new SkipNode (this, Node.INF));
    reposition();
  }

  public void insert (int x) { start (new SkipInsert (this, x)); }
  public void find (int x) { start (new SkipFind (this, x)); }
  public void delete (int x) { start (new SkipDelete (this, x)); }

  public void clear () {
    height=1; n=e=0;
    root = new SkipNode (this, -Node.INF);
    root.linkright (sent = new SkipNode (this, Node.INF));
    reposition();
  }
  public void clean() { v = null; }

  public String stats() {
    if (root == null) return "Size: 0;   Height: 0;   #Excess nodes: 0"; 
    else { 
     return "Size: " + n + ";   Heigh: " + height + ";   #Excess nodes: "+e;
    }
  }

  public void draw (Graphics g) {
    if (root != null) { root.moveSkipList(); root.drawSkipList(g); }
    if (v != null) { v.move(); v.draw(g); }
  }

  public void resize () {
    if (M.small) {
      radius = 5;
      xspan = yspan = 5;
      fontsize = 5;
    } else {
      radius = 10;
      xspan = yspan = 10;
      fontsize = 11;
    }
    swidth = M.S.size.width;
    sheight = M.S.size.height;
    rootx = rooty = 5*radius + yspan;
    reposition();
  }

  public void reposition () { root._reposition (); }
}
