import java.awt.*;

public class SplayInsert extends Algorithm {
  Splay T;
  BSTNode s, v;
  int K;

  public SplayInsert (Splay T, int x) {
    super (T.M);
    this.T = T;
    T.v = s = new SplayNode (T, K=x);
    s.bgColor (Node.FIND);
    T.vv = v = new SplayNode (T, x);
    v.bgColor (Node.INSERT);
    setHeader ("splay");
  }

  public void run() {
    if (T.root == null) {
      T.root = v;
      v.goToRoot();
      setText ("newroot");
      mysuspend();
    } else {
      v.goAboveRoot();
      BSTNode w = T.root;
      s.goTo (w);
      setText ("splaystart");
      mysuspend();
      while (true) {
        if (w.key == K) break;
        else if (w.key < K) { // right
          if (w.right == null) break;
          w = w.right;
          setText ("bstfindright", K, w.key);
        } else { // left
          if (w.left == null) break;
          w = w.left;
          setText ("bstfindleft", K, w.key);
        }
        s.goTo (w);
        mysuspend();
      }
      w.bgColor (Node.FIND);
      T.v = null;
      setText ("splayfound");
      mysuspend();

      // splay
      while (!w.isRoot()) {
        if (w.parent.isRoot()) {
          T.rotate (w);
          setText ("splayroot");
        } else {
          if (w.isLeft() == w.parent.isLeft()) {
            if (w.isLeft()) setText ("splayzigzigleft");
                       else setText ("splayzigzigright");
            T.rotate (w.parent); mysuspend();
            T.rotate (w);
          } else {
            if (!w.isLeft()) setText ("splayzigzagleft");
                        else setText ("splayzigzagright");
            T.rotate (w); mysuspend();
            T.rotate (w);
          }
        }
        mysuspend();
      }

      T.root = w;
      setHeader ("insertion");
      w.bgColor (Node.NORMAL);
      if (w.key == K) {
        setText ("alreadythere");
        v.goDown();
        v.bgColor (Node.NOTFOUND);
        return;
      } else if (w.key < K) {
        setText ("splayinsertleft");
        mysuspend();
        v.linkleft (w);
        v.linkright (w.right);
        w.right = null;
      } else {
        setText ("splayinsertright");
        mysuspend();
        v.linkright (w);
        v.linkleft (w.left);
        w.left = null;
      }
      T.root = v;
      T.reposition();
      mysuspend();
    }
    setText ("done");
    v.bgColor (Node.NORMAL);
    T.vv = null;
  }
}
