import java.awt.*;
import java.util.*;

public class BST extends Dictionary {
  BSTNode root = null, v = null;

  public BST (main M) { super (M); }

  public void insert (int x) { start (new BSTInsert (this, x)); }
  public void find (int x) { start (new BSTFind (this, x)); }
  public void delete (int x) { start (new BSTDelete (this, x)); }
  public void clear() { root = null; setStats(); }
  public void clean() { v = null; }

  static final String ZEROES = "000000000000";
  static final String BLANKS = "            ";

  static String format( double val, int n, int w) { //  rounding
    double incr = 0.5;
    for( int j=n; j>0; j--) incr /= 10; 
    val += incr;
    String s = Double.toString(val);
    int n1 = s.indexOf('.');
    int n2 = s.length() - n1 - 1;
    if (n>n2) s = s+ZEROES.substring(0, n-n2);
    else if (n2>n) s = s.substring(0,n1+n+1);
    if( w>0 & w>s.length() ) s = BLANKS.substring(0,w-s.length()) + s;
    else if ( w<0 & (-w)>s.length() ) {
      w=-w;
      s = s + BLANKS.substring(0,w-s.length());
    }
    return s;
  }

  public String stats() { 
    if (root == null) return "Size: 0;   Height: 0 =  1.00\u00b7opt;   Ave. depth: 0"; 
    else { 
      root.calcTree();
     return "Size: " + root.size + ";   Heigh: " + root.height + " = "
        + format (root.height/(double)(Math.floor(lg(root.size))+1), 2, 5)
        + "\u00b7opt;   Ave. depth: " + format (root.sumh/(double)root.size, 2, -5);
    }
  }

  public void draw (Graphics g) {
    if (root != null) { root.moveTree(); root.drawTree(g); }
    if (v != null) { v.move(); v.draw(g); }
  }

  public void resize () {
    if (M.small) {
      radius = 5;
      xspan = 5;
      yspan = 2;
      fontsize = 5;
    } else {
      radius = 10;
      xspan = 10;
      yspan = 5;
      fontsize = 11;
    }
    swidth = M.S.size.width;
    sheight = M.S.size.height;
    rootx = swidth/2;
    rooty = 5*radius + yspan;
    if (root != null) reposition();
  }

  protected void leftrot (BSTNode v) {
    BSTNode u=v.parent;
    if (u.isRoot()) { root=v; v.parent=null; }
    else { 
      if (u.isLeft()) u.parent.linkleft(v); 
      else u.parent.linkright(v); 
    }
    if (v.left==null) u.right=null; else u.linkright(v.left);
    v.linkleft(u);
  }
  
  protected void rightrot (BSTNode v) {
    BSTNode u=v.parent;
    if (u.isRoot()) { root=v; v.parent=null; }
    else { 
      if (u.isLeft()) u.parent.linkleft(v); 
      else u.parent.linkright(v); 
    }
    if (v.right==null) u.left=null; else u.linkleft(v.right);
    v.linkright(u);
  }

  public void rotate (BSTNode v) {
    if (v.isLeft()) rightrot(v); else leftrot(v);
    reposition();
    if (v.left != null) v.left.calc();
    if (v.right != null) v.right.calc();
    v.calc();
  }

  public void reposition () { if (root != null) root._reposition (); }
}
