import java.awt.*;

public class SplayFind extends Algorithm {
  Splay T;
  BSTNode s, v;
  int K;

  public SplayFind (Splay T, int x) {
    super (T.M); 
    this.T = T; 
    T.v = s = new SplayNode (T, K=x); 
    s.bgColor (Node.FIND);
    T.vv = v = new SplayNode (T, x);
    v.bgColor (Node.FIND);
    setHeader ("splay");
  }

  public void run() {
    if (T.root == null) {
      v.goToRoot();
      setText ("bstfindempty");
      mysuspend();
      v.goDown();
      v.bgColor (Node.NOTFOUND);
      setHeader ("search");
      setText ("bstfindnotfound");
    } else {
      v.goAboveRoot();
      BSTNode w = T.root;
      s.goTo (w);
      setText ("splaystart");
      mysuspend();
      while (true) {
        if (w.key == K) break;
        else if (w.key < K) { // right
          if (w.right == null) break;
          w = w.right;
          setText ("bstfindright", K, w.key);
        } else { // left
          if (w.left == null) break;
          w = w.left;
          setText ("bstfindleft", K, w.key);
        }
        s.goTo (w);
        mysuspend();
      }
      w.bgColor (Node.FIND);
      T.v = null;
      setText ("splayfound");
      mysuspend();

      // splay
      while (!w.isRoot()) {
        if (w.parent.isRoot()) {
          T.rotate (w);
          setText ("splayroot");
        } else {
          if (w.isLeft() == w.parent.isLeft()) {
            if (w.isLeft()) setText ("splayzigzigleft");
                       else setText ("splayzigzigright");
            T.rotate (w.parent); mysuspend();
            T.rotate (w);
          } else {
            if (!w.isLeft()) setText ("splayzigzagleft");
                        else setText ("splayzigzagright");
            T.rotate (w); mysuspend();
            T.rotate (w);
          }
        }
        mysuspend();
      }

      setText ("splayinroot");
      T.root = w;
      mysuspend();

      setHeader ("search");
      w.bgColor (Node.NORMAL);
      v.goToRoot();
      if (w.key == v.key) { 
        setText ("found");
        v.bgColor (Node.FOUND);
      } else {
        setText ("notfound");
        v.bgColor (Node.NOTFOUND);
        v.goDown();
      }
      mysuspend();
    }
  }
}
