#include "CAnimObject.h"
#include "CMandelbrot.h"
#include "avi.h"
#include <assert.h>

CAnimObject::CAnimObject()
: m_finishedFrameCount(0),
  m_avi(NULL)
{

}

CAnimObject::~CAnimObject(){
	for(int i = 0; i < m_numFrames; i++)
		delete m_frames[i];
	delete [] m_frames;
}

void CAnimObject::CreateAVI(std::string const& filename, int fps, HWND parrent)
{
	BITMAPINFOHEADER infoHeader;
	
	int width = m_frames[0]->GetSizeX();
	int height = m_frames[0]->GetSizeY();

	infoHeader.biSize = sizeof(BITMAPINFOHEADER);
    infoHeader.biWidth = width;
    infoHeader.biHeight = height;
    infoHeader.biPlanes = 1;
    infoHeader.biBitCount = 24;
    infoHeader.biCompression = BI_RGB;
    infoHeader.biSizeImage = width*height;
	infoHeader.biClrUsed = 0;
	infoHeader.biClrImportant = 0;

	if(m_avi != NULL)
		delete m_avi;
	
	m_avi = new Avi(filename, 1000/(float)fps, NULL);
	
	AVICOMPRESSOPTIONS opts; 
    ZeroMemory(&opts,sizeof(opts));
	opts.fccHandler   =   808810089;  
	opts.dwFlags   =   AVICOMPRESSF_VALID;  
	opts.dwQuality   =   8500;   
	opts.fccType   =   streamtypeVIDEO;  
	opts.lpParms   =   (LPVOID   *)GlobalAlloc(NULL,   4);  
	opts.cbParms   =   48;   
	//opts.fccHandler=mmioFOURCC('d','i','v','x');
	
	m_avi->compression(&infoHeader, &opts, false, 0);
	//m_avi->compression(&infoHeader, NULL, true, 0);

	unsigned char *tempImage = new unsigned char[width*height*3];
	unsigned char *fractalImage;
	for(int n = 0; n < m_numFrames-1; n++)
	{
		fractalImage = m_frames[n]->GetImage();
		for(int i = 0, j = 0; i < m_frames[n]->GetSizeX()*m_frames[n]->GetSizeY()*3; i+=3)
		{
			assert(j < width*height*3);
			// swap red and blue color because avi file have bgr color system
			tempImage[j] = fractalImage[i+2];
			tempImage[j+1] = fractalImage[i+1];
			tempImage[j+2] = fractalImage[i];
			j+=3;
		}
		m_avi->add_frame(tempImage, &infoHeader);
	}

	delete m_avi;
	m_avi = NULL;
	delete tempImage;
}

// void CAnimObject::AbortComputing()
// {
// 	for(int i = 0; i < m_actualFrameList.size(); i++)
// 	{
// 		m_actualFrameList.at(i)->Abort();
// 	}
// }

// void CAnimObject::FrameFinished()
// {
// 	m_finishedFrameCount++;
// }

void CAnimObject::SetHandle(HWND hwnd)
{
	for(int i = 0; i < m_numFrames; i++)
		m_frames[i]->SetHWND(hwnd);
}