#include "CControlAnim.h"
#include "CMandelbrot.h"
#include "CJulia.h"
#include "stdio.h"

LRESULT CALLBACK CControlAnim::WndProcWrapper(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	CControlAnim *pThis = (CControlAnim*)GetProp(hwnd,"ClassPointer");
	if(pThis) 
		return pThis->CustWndProc(hwnd,msg,wParam,lParam);
	return DefWindowProc(hwnd,msg,wParam,lParam);
}

LRESULT CControlAnim::CustWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	PAINTSTRUCT ps; 
	HDC hdc; 

	switch(msg)
	{
	case WM_PAINT:
		if(wParam == 0)
			hdc = BeginPaint(hwnd, &ps);
		else
			hdc = (HDC)wParam;

		OnPaint(hdc);

		if(wParam == 0)
			EndPaint(hwnd, &ps);
	break;
	default:
        break;
    }

    return DefWindowProc(hwnd, msg, wParam, lParam);
}

CControlAnim::CControlAnim(HWND hwndParent, int quality) 
: CCustomControl(hwndParent),
  m_quality(quality)
{
	m_className = _T("ControlAnim");

	switch(m_quality)
	{
	case 0:
		m_width = 320;
		m_height = 256;
	break;
	case 1:
		m_width = 640;
		m_height = 512;
	break;
	case 2:
		m_width = 800;
		m_height = 640;
	break;
	}
  
	InitCustomControl();
	CreateCustomControl();
}

CControlAnim::~CControlAnim()
{
	DeleteObject(m_hBitmap);
}

void CControlAnim::InitCustomControl()
{
    WNDCLASSEX wc;
    
    wc.cbSize         = sizeof(wc);
    wc.lpszClassName  = m_className;
    wc.hInstance      = GetModuleHandle(0);
    wc.lpfnWndProc    = WndProcWrapper;
    wc.hCursor        = LoadCursor (NULL, IDC_ARROW);
    wc.hIcon          = 0;
    wc.lpszMenuName   = 0;
    wc.hbrBackground  = (HBRUSH)GetSysColorBrush(COLOR_BTNFACE);
    wc.style          = 0;
    wc.cbClsExtra     = 0;
    wc.cbWndExtra     = 0;
    wc.hIconSm        = 0;

    RegisterClassEx(&wc);
}


void CControlAnim::CreateCustomControl()
{
	m_hwndCtrl = CreateWindowEx(
                 WS_EX_CLIENTEDGE, 
                 m_className,
                 _T("control Anim"),
                 WS_VISIBLE | WS_CHILD,
                 5, 5, m_width + 4, m_height + 4,
                 m_hwndParent,
                 NULL, GetModuleHandle(0), NULL
               );

	SetProp(m_hwndCtrl,"ClassPointer",(HANDLE)this);
}

void CControlAnim::SetCurrentFractalObject(CFractal *fractal)
{
	m_fractalObject = fractal;

	DeleteObject(m_hBitmap);

	m_bitmapInfo.biSize = sizeof(BITMAPINFOHEADER);
	m_bitmapInfo.biWidth = m_width;
	m_bitmapInfo.biHeight = m_height;
	m_bitmapInfo.biPlanes = 1;
	m_bitmapInfo.biBitCount = 24;
	m_bitmapInfo.biCompression = BI_RGB;
	m_bitmapInfo.biSizeImage = 0;
	m_bitmapInfo.biXPelsPerMeter = 0;
	m_bitmapInfo.biYPelsPerMeter = 0;
	m_bitmapInfo.biClrUsed = 0;
	m_bitmapInfo.biClrImportant = 0;

	HDC hdc = GetWindowDC(NULL);

	m_hBitmap = CreateDIBSection(hdc, (LPBITMAPINFO)&m_bitmapInfo,DIB_RGB_COLORS,(LPVOID *)&m_image,NULL,0);

	fractal->CopyToLocation(m_image);
	InvalidateRect(m_hwndCtrl, NULL, false);
	UpdateWindow(m_hwndCtrl);
}