#ifndef CCONTROLJULIA_H
#define CCONTROLJULIA_H

#include "CCustomControl.h"

#define PREVIEW_QUALITY_LOW		0
#define PREVIEW_QUALITY_MEDIUM	1
#define PREVIEW_QUALITY_HIGH	2
#define PREVIEW_QUALITY_ANIM	3

class CFractal;
class CJulia;

class CControlJulia : public CCustomControl
{
private:
	int m_quality;
	int m_iterationCount;

	long double m_seedX;
	long double m_seedY;

	CJulia *m_fractalObject;
	unsigned char *m_image;

	void CreateCustomControl();
	void InitCustomControl();
			
	LRESULT CALLBACK CustWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK JuliaWndProcWrapper(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

public:
	CControlJulia(HWND hwndParent, int quality, long double seedX = -0.4, long double seedY = 0.6);
	virtual ~CControlJulia();

	CJulia *GetFractalObject() { return m_fractalObject; };
	void SetQuality(int quality);
	void SetSeed(long double x, long double y) { m_seedX = x; m_seedY = y; };
};

#endif // CCONTROLJULIA_H
