#ifndef CCONTROLMANDNURBS_H
#define CCONTROLMANDNURBS_H

#include "CCustomControl.h"

class CFractal;
class CMandelbrot;
class CNURBS;
class CVertex;

class CControlMandNURBS : CCustomControl
{
private:
	CFractal *m_fractalObject;
	CFractal *m_juliaObject;
	int m_mouseX, m_mouseY;
	double m_pointX, m_pointY;

	HWND m_hwndJulia;

	unsigned char *m_image;

	CNURBS *m_NURBS;
	bool m_dragging;
	CVertex *m_draggedVertex;
	CVertex *m_toDeleteVertex;
	double m_positionX;
	double m_positionY;
	int m_actualFrame;

	void CreateCustomControl();
	void InitCustomControl();
	
	LRESULT CALLBACK CustWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK MandWndProcWrapper(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

	void OnLButtonDown(int x, int y);
	void OnLButtonUp(int x, int y);
	void OnRButtonDown(int x, int y);
	void OnRButtonUp(int x, int y);
	void OnMouseMove(int x, int y);

	// draw NURBS, wrong name for function, but... best solution for OOP I could came up with
	void DrawSelection(HDC hdc);

public:
	CControlMandNURBS(HWND hwndParent, HWND hwndJulia, CFractal *julia, CNURBS *nurbs = NULL, CMandelbrot *def = NULL);
	virtual ~CControlMandNURBS();

	CFractal *GetFractalObject() { return m_fractalObject; };
	void SetPointPossition(float x, float y);
	double GetPointX() { return m_pointX; };
	double GetPointY() { return m_pointY; };
	long double GetFrameSeedX();
	long double GetFrameSeedY();
	void SetStepFrames(int i);
	void SetFrame(int i);
	int GetRange();
	CNURBS *GetNURBSObject() { return m_NURBS; };
};

#endif // CCONTROLMANDNURBS_H
