#ifndef CCONTROLPALETTE_H
#define CCONTROLPALETTE_H

#include "CCustomColorControl.h"

class CControlPalette : public CCustomColorControl
{
private:
	bool m_dragging;

	void CreateCustomControl();
	void InitCustomControl();

	LRESULT CALLBACK CustWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK CustWndProcWrapper(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

	void GenerateBitmap();
	void DrawSelection(HDC hdc);
public:
	CControlPalette(HWND hwndParent);
	virtual ~CControlPalette();

	void OnLButtonDown(WPARAM wParam, LPARAM lParam);
	void OnLButtonUp(WPARAM wParam, LPARAM lParam);
	void OnMouseMove(WPARAM wParam, LPARAM lParam);

	void SetV(float v);
	void SetRGB(unsigned char r, unsigned char g, unsigned char b);
	void SetHSV(short int h, unsigned char s, unsigned char v);
};

#endif // CCONTROLPALETTE_H
