#ifndef CCONTROLPALETTESLIDER_H
#define CCONTROLPALETTESLIDER_H

#include "CCustomColorControl.h"

class CControlPaletteSlider : public CCustomColorControl
{
private:
	bool m_dragging;

	void CreateCustomControl();
	void InitCustomControl();

	LRESULT CALLBACK CustWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK CustWndProcWrapper(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

 	void GenerateBitmap();
	void DrawSelection(HDC hdc);
public:
	CControlPaletteSlider(HWND hwndParent);
	virtual ~CControlPaletteSlider();

	void OnLButtonDown(WPARAM wParam, LPARAM lParam);
	void OnLButtonUp(WPARAM wParam, LPARAM lParam);
	void OnMouseMove(WPARAM wParam, LPARAM lParam);

	void SetHS(float h, float s);
	void SetRGB(unsigned char r, unsigned char g, unsigned char b);
	void SetHSV(short int h, unsigned char s, unsigned char v);
};

#endif // CCONTROLPALETTESLIDER_H
