#ifndef CCUSTOMCOLORCONTROL_H
#define CCUSTOMCOLORCONTROL_H

#include "CCustomControl.h"

#define WM_SET_HS				WM_APP + 0x170
#define WM_SET_V				WM_APP + 0x171
#define WM_SET_RGB				WM_APP + 0x172
#define WM_SELECT_COLOR_SLOT	WM_APP + 0x173
#define WM_SET_RGB_HSV			WM_APP + 0x174

struct rgb
{
	unsigned char r,g,b;
};

struct hsv
{
	float h,s,v;
};

class CCustomColorControl : public CCustomControl
{
protected:
	unsigned char *m_palette;

	float m_v, m_s, m_h;
	unsigned char m_r, m_g, m_b;

	void HSV2RGB(float h, float s, float v, rgb *r);
	void RGB2HSV(unsigned char r, unsigned char g, unsigned char b, hsv *c);

public:
	CCustomColorControl(HWND hwnd);
};

#endif //CCUSTOMCOLORCONTROL_H