#include "StdAfx.h"
#include "CExpAnimObject.h"
#include "CFractal.h"
#include "CMandelbrot.h"
#include "CJulia.h"
#include "CThreadManager.h"

CExpAnimObject::CExpAnimObject(char fractalType, int numFrames, int FPS, long double startExp, long double endExp, HWND hwnd, int quality, CFractal *model)
: m_fractalType(fractalType)
{
	m_quality = quality;
	m_hwnd = hwnd;
	m_numFrames = numFrames;
	m_FPS = FPS;
	m_actualFrame = 0;
	m_quality = quality;
	m_startExp = startExp;
	m_endExp = endExp;
	m_prevNumFrames = m_numFrames;
	m_frames = new CFractal*[m_numFrames];
	int i;
	switch(m_fractalType | (m_quality << 3)){		// combine type and quality into single number to use only one switch
		case 0:
			for(i = 0; i < m_numFrames; i++)
				m_frames[i] = new CMandelbrot(320, 256, m_hwnd, (CMandelbrot*)model);
		break;
		case 1: 
			for(i = 0; i < m_numFrames; i++)
				m_frames[i] = new CJulia(320, 256, m_hwnd, (CJulia*)model);
		break;
		case 8:
			for(i = 0; i < m_numFrames; i++)
				m_frames[i] = new CMandelbrot(640, 512, m_hwnd, (CMandelbrot*)model);
		break;
		case 9: 
			for(i = 0; i < m_numFrames; i++)
				m_frames[i] = new CJulia(640, 512, m_hwnd, (CJulia*)model);
		break;
		case 16:
			for(i = 0; i < m_numFrames; i++)
				m_frames[i] = new CMandelbrot(800, 640, m_hwnd, (CMandelbrot*)model);
		break;
		case 17: 
			for(i = 0; i < m_numFrames; i++)
				m_frames[i] = new CJulia(800, 640, m_hwnd, (CJulia*)model);
		break;
	}

	m_animObjectType = EXP_ANIM_OBJECT;
}

void CExpAnimObject::Compute()
{
	threadManager->ClearTasks();
	for(int i = 0; i < m_numFrames; i++)
	{
		if(m_actualFrame == 0)
			m_frames[m_actualFrame]->m_exp = m_startExp;
		else
			m_frames[m_actualFrame]->m_exp = m_startExp + (m_endExp-m_startExp)*(float)(m_actualFrame)/(m_numFrames-1);
		threadManager->AddTask(m_frames[m_actualFrame++], 1);
	}
	threadManager->RunTasks();
}


void CExpAnimObject::Clear(int quality, int numframes, long double startexp, long double endexp, CFractal *model)
{
	for(int i = 0; i < m_prevNumFrames; i++)
		delete m_frames[i];
	delete [] m_frames;

	m_finishedFrameCount = 0;
	m_quality = quality;
	m_numFrames = numframes;
	m_startExp = startexp;
	m_endExp = endexp;
	m_frames = new CFractal*[m_numFrames];
	int i;
	switch(m_fractalType | (m_quality << 3)){		// combine type and quality into single number to use only one switch
		case 0:
			for(i = 0; i < m_numFrames; i++)
				m_frames[i] = new CMandelbrot(320, 256, m_hwnd, (CMandelbrot*)model);
		break;
		case 1: 
			for(i = 0; i < m_numFrames; i++)
				m_frames[i] = new CJulia(320, 256, m_hwnd, (CJulia*)model);
		break;
		case 8:
			for(i = 0; i < m_numFrames; i++)
				m_frames[i] = new CMandelbrot(640, 512, m_hwnd, (CMandelbrot*)model);
		break;
		case 9: 
			for(i = 0; i < m_numFrames; i++)
				m_frames[i] = new CJulia(640, 512, m_hwnd, (CJulia*)model);
		break;
		case 16:
			for(i = 0; i < m_numFrames; i++)
				m_frames[i] = new CMandelbrot(800, 640, m_hwnd, (CMandelbrot*)model);
		break;
		case 17: 
			for(i = 0; i < m_numFrames; i++)
				m_frames[i] = new CJulia(800, 640, m_hwnd, (CJulia*)model);
		break;
	}

	m_actualFrame = 0;
	m_prevNumFrames = m_numFrames;
}