#ifndef CEXPANIMOBJECT_H
#define CEXPANIMOBJECT_H

#include "windows.h"
#include "CAnimObject.h"

class CFractal;
class CThreadManager;

extern CThreadManager *threadManager;

class CExpAnimObject: public CAnimObject
{
private:
	long double m_startExp;
	long double m_endExp;
	int m_fractalType;
public:
	CExpAnimObject(char fractalType, int numFrames, int FPS, long double startExp, long double endExp, HWND hwnd, int quality, CFractal *model = NULL);
	~CExpAnimObject();
	void Compute();
	long double GetStartExp() { return m_startExp; };
	long double GetEndExp() { return m_endExp; };
	void SetEndExp(long double e) { m_endExp = e; };
	void SetStartExp(long double e) { m_startExp = e; };
	void Clear(int quality, int numframes, long double startexp, long double endexp, CFractal *model = NULL);
};

#endif //CEXPANIMOBJECT_H