#include "StdAfx.h"
#include "CFractal.h"
#include "CAnimObject.h"
#include "math.h"
#include "process.h"

#define WM_NEXTFRAME WM_APP + 0x160

CFractal *CFractal::m_this;

CFractal::CFractal(HWND hwnd)
: m_sizeX(640),m_sizeY(512),
  m_done(true),
  m_aborted(false),
  m_hwnd(hwnd),
  m_blurStrength(0),
  m_coloringMethod(0),
  m_customPalette(NULL),
  m_actualPaletteIndex(0),
  m_bufferSize(10),
  m_bufferPointer(-1),
  m_bufferedFractalCount(0)
{
	m_fractal = new unsigned char[3*m_sizeX*m_sizeY];
	m_fractalOrig = m_fractal;

	m_fractalBuffer = new unsigned char*[m_bufferSize];
	memset(m_fractalBuffer, 0, m_bufferSize*sizeof(unsigned char*));
	m_positionBuffer = new possition[m_bufferSize];
	memset(m_fractal, 0, 3*m_sizeX*m_sizeY*sizeof(unsigned char));
}

CFractal::CFractal(int width, int height, HWND hwnd)
: m_done(false),
  m_aborted(false),
  m_hwnd(hwnd),
  m_blurStrength(0),
  m_fractal(NULL),
  m_coloringMethod(0),
  m_customPalette(NULL),
  m_actualPaletteIndex(0),
  m_bufferSize(10),
  m_bufferPointer(-1),
  m_bufferedFractalCount(0)
{
	m_fractalBuffer = new unsigned char*[m_bufferSize];
	memset(m_fractalBuffer, 0, m_bufferSize*sizeof(unsigned char*));
	m_positionBuffer = new possition[m_bufferSize];
	SetSize(width, height);
}

CFractal::~CFractal()
{
	delete[] m_fractalOrig;
	for(int i = 0; i < m_bufferSize; i++)
		if(m_fractalBuffer[i])
			delete [] m_fractalBuffer[i];

	delete [] m_fractalBuffer;
	delete [] m_positionBuffer;
}

double CFractal::GetIndexValue(int i)
{
	if(m_actualIndexValue == 0)
		if(i == 0)
			return 0;
		else
			return m_iterationCount;
	else
	{
		double indexValue = m_actualIndexValue;
		double indexIncrement = m_actualIndexIncrement;
		double result = 0;
		for(int j = 0; j < i; j++)
		{
			result += indexValue;
			indexValue += indexIncrement;
		}
		return result;
	}
}

void CFractal::SetPixel(int x, int y, double dist)
{
	if(x > m_sizeX)
		return;

	if(dist < 0){
		m_fractal[3*(y*m_sizeX+x)+2] = m_actualPalette[m_actualPaletteSize - 3];
		m_fractal[3*(y*m_sizeX+x)+1] = m_actualPalette[m_actualPaletteSize - 2];
		m_fractal[3*(y*m_sizeX+x)] = m_actualPalette[m_actualPaletteSize - 1];
	}
	else{
		int index = 0;
		while(dist > GetIndexValue(index+1))
			index++;

		double s = (dist - GetIndexValue(index))/(GetIndexValue(index+1) - GetIndexValue(index));

		index %= (m_actualPaletteSize/3 - 2);

		m_fractal[3*(y*m_sizeX+x)+2] = (unsigned char)(m_actualPalette[3*index] + (m_actualPalette[3*index + 3] - m_actualPalette[3*index])*s);
		m_fractal[3*(y*m_sizeX+x)+1] = (unsigned char)(m_actualPalette[3*index + 1] + (m_actualPalette[3*index + 4] - m_actualPalette[3*index + 1])*s);
		m_fractal[3*(y*m_sizeX+x)] = (unsigned char)(m_actualPalette[3*index + 2] + (m_actualPalette[3*index + 5] - m_actualPalette[3*index + 2])*s);
	}
}

void CFractal::Clear()
{
	memset(m_fractal, 0, 3*m_sizeX*m_sizeY);
}

bool CFractal::ZoomIn(int x1, int y1, int x2, int y2)
{
	// save image into buffer for faster zoomout
	m_bufferPointer++;
	m_bufferedFractalCount++;
	if(m_bufferedFractalCount > 10)
		m_bufferedFractalCount = 10;
	if(m_bufferPointer >= m_bufferSize)
		m_bufferPointer = 0;
	if(!m_fractalBuffer[m_bufferPointer])
		m_fractalBuffer[m_bufferPointer] = new unsigned char[3*m_sizeX*m_sizeY];

	memcpy(m_fractalBuffer[m_bufferPointer], m_fractal, sizeof(unsigned char)*3*m_sizeX*m_sizeY);
	m_positionBuffer[m_bufferPointer].xMax = m_xMax;
	m_positionBuffer[m_bufferPointer].xMin = m_xMin;
	m_positionBuffer[m_bufferPointer].yMax = m_yMax;
	m_positionBuffer[m_bufferPointer].yMin = m_yMin;
	m_positionBuffer[m_bufferPointer].zoomDepth = m_zoomDepth;

	// calculate width and height
	int w = abs(x1 - x2);
	int h = abs(y1 - y2);

	if(w < 3 && h < 4)
		return false;
	// fix ratio
	if(w >= h*1.25f)
		h = (int)(4.0f*(float)w/5.0f);
	else
		w = (int)(1.25f*h);
	// calculate new top-left corner
	if(x1 < x2)
		x1 = x1 + (abs(x1 - x2) - w)/2;
	else
		x1 = x2 + (abs(x1 - x2) - w)/2;
	if(y1 < y2)
		y1 = y1 + (abs(y1 - y2) - h)/2;
	else
		y1 = y2 + (abs(y1 - y2) - h)/2;
	// calculate relative width/height and corner
	float rel_w = (float)w/(float)m_sizeX;
	float rel_h = (float)h/(float)m_sizeY;
	float rel_x = (float)x1/(float)m_sizeX;
	float rel_y = (float)y1/(float)m_sizeY;

	long double prevWidth = m_xMax - m_xMin;
	long double prevHeight = m_yMax - m_yMin;

	m_xMin += prevWidth*rel_x;
	m_xMax = m_xMin + prevWidth*rel_w;
	m_yMax -= prevHeight*rel_y;
	m_yMin = m_yMax - prevHeight*rel_h;
	
	m_zoomDepth /= rel_w;

	return true;
}

bool CFractal::ZoomOut()
{
	// if m_bufferPointer < 0 we already depleted our buffer, so we zoomout to half zoom level
	if(m_bufferedFractalCount == 0)
	{
		m_zoomDepth = m_zoomDepth*2;
		long double tmp = m_xMax - m_xMin;
		m_xMax += tmp/4;
		m_xMin -= tmp/4;
		tmp = m_yMax - m_yMin;
		m_yMax += tmp/4;
		m_yMin -= tmp/4;

		return true;
	}
	else
	{
		m_xMax = m_positionBuffer[m_bufferPointer].xMax;
		m_xMin = m_positionBuffer[m_bufferPointer].xMin;
		m_yMax = m_positionBuffer[m_bufferPointer].yMax;
		m_yMin = m_positionBuffer[m_bufferPointer].yMin;
		m_zoomDepth = m_positionBuffer[m_bufferPointer].zoomDepth;

		memcpy(m_fractal, m_fractalBuffer[m_bufferPointer], sizeof(unsigned char)*3*m_sizeX*m_sizeY);

		delete [] m_fractalBuffer[m_bufferPointer];

		m_fractalBuffer[m_bufferPointer] = NULL;

		m_bufferPointer--;
		if(m_bufferPointer < 0 && m_fractalBuffer[m_bufferSize - 1] != NULL)
			m_bufferPointer = m_bufferSize - 1;

		m_bufferedFractalCount--;
		return false;
	}
}

void Power(complex *c, long double e)
{
	if(e == (int)e)
	{							// is exponent decimal number?
		long double r,i;
		long double r2,i2;
		r = c->r;
		i = c->i;
		
		if(e <= 2)
		{
			c->r = c->r*r - c->i*i;				
			c->i = 2*i*r;
		}
		else
		{
			for(int j = 1; j < e; ++j)
			{
				r2 = c->r;						// save values of c to ensure correct computation of imaginary part
				i2 = c->i;
				c->r = r2*r - i2*i;
				c->i = r2*i + i2*r;
			}
		}
	}
	else
	{
		long double rad, theta;
		rad = sqrt(c->r*c->r + c->i*c->i);
		theta = atan2(c->i,c->r);
		rad = pow(rad, long double(e));
		theta = e*theta;
		c->r = rad*cos(theta);
		c->i = rad*sin(theta);
	}
}

void CFractal::SetFractal(long double x, long double y, int iter, long double zoom, long double exp)
{
	m_zoomDepth = zoom;
	m_iterationCount = iter;
	m_exp = exp;

	//double imageRatio = (3.0/2.5)*((float)m_sizeY/(float)m_sizeX);
	double sizeX = 3.0/zoom;
	double sizeY = 2.5/zoom;

	m_xMin = x - sizeX/2;
	m_xMax = x + sizeX/2;
	m_yMin = y - sizeY/2;
	m_yMax = y + sizeY/2;
}

void CFractal::SetBlurStrength(int blurStrength)
{
	m_blurStrength = blurStrength;
	Compute();
	if(blurStrength != 0)
		BlurImage();
}

void CFractal::BlurImage()
{
	if(m_blurStrength == 0)
		return;

	int matrix[9];
	float normalizator;

	if(m_blurStrength == 2)
	{
		matrix[0] = 1;
		matrix[1] = 2;
		matrix[2] = 1;
		matrix[3] = 2;
		matrix[4] = 8;
		matrix[5] = 2;
		matrix[6] = 1;
		matrix[7] = 2;
		matrix[8] = 1;
		normalizator = 20.0f;
	}
	else 
	{
		matrix[0] = 0;
		matrix[1] = 1;
		matrix[2] = 0;
		matrix[3] = 1;
		matrix[4] = 8;
		matrix[5] = 1;
		matrix[6] = 0;
		matrix[7] = 1;
		matrix[8] = 0;
		normalizator = 12.0f;
	}
	
	unsigned char *tempImage = new unsigned char[3*m_sizeX*m_sizeY];
	
	for(int i = 1; i < m_sizeX - 1; i++)
		for(int j = 1; j < m_sizeY - 1; j++)
		{
			// red color
			tempImage[3*(j*m_sizeX + i)] = m_fractal[3*((j-1)*m_sizeX + i-1)]*matrix[0]/normalizator + 
										m_fractal[3*((j-1)*m_sizeX + i)]*matrix[1]/normalizator + 
										m_fractal[3*((j-1)*m_sizeX + i+1)]*matrix[2]/normalizator + 
										m_fractal[3*((j)*m_sizeX + i-1)]*matrix[3]/normalizator + 
										m_fractal[3*((j)*m_sizeX + i)]*matrix[4]/normalizator + 
										m_fractal[3*((j)*m_sizeX + i+1)]*matrix[5]/normalizator + 
										m_fractal[3*((j+1)*m_sizeX + i-1)]*matrix[6]/normalizator + 
										m_fractal[3*((j+1)*m_sizeX + i)]*matrix[7]/normalizator + 
										m_fractal[3*((j+1)*m_sizeX + i+1)]*matrix[8]/normalizator;
			// green color
			tempImage[3*(j*m_sizeX + i) + 1] = m_fractal[3*((j-1)*m_sizeX + i-1) + 1]*matrix[0]/normalizator + 
										m_fractal[3*((j-1)*m_sizeX + i) + 1]*matrix[1]/normalizator + 
										m_fractal[3*((j-1)*m_sizeX + i+1) + 1]*matrix[2]/normalizator + 
										m_fractal[3*((j)*m_sizeX + i-1) + 1]*matrix[3]/normalizator + 
										m_fractal[3*((j)*m_sizeX + i) + 1]*matrix[4]/normalizator + 
										m_fractal[3*((j)*m_sizeX + i+1) + 1]*matrix[5]/normalizator + 
										m_fractal[3*((j+1)*m_sizeX + i-1) + 1]*matrix[6]/normalizator + 
										m_fractal[3*((j+1)*m_sizeX + i) + 1]*matrix[7]/normalizator + 
										m_fractal[3*((j+1)*m_sizeX + i+1) + 1]*matrix[8]/normalizator;
			// blue color
			tempImage[3*(j*m_sizeX + i) + 2] = m_fractal[3*((j-1)*m_sizeX + i-1) + 2]*matrix[0]/normalizator + 
										m_fractal[3*((j-1)*m_sizeX + i) + 2]*matrix[1]/normalizator + 
										m_fractal[3*((j-1)*m_sizeX + i+1) + 2]*matrix[2]/normalizator + 
										m_fractal[3*((j)*m_sizeX + i-1) + 2]*matrix[3]/normalizator + 
										m_fractal[3*((j)*m_sizeX + i) + 2]*matrix[4]/normalizator + 
										m_fractal[3*((j)*m_sizeX + i+1) + 2]*matrix[5]/normalizator + 
										m_fractal[3*((j+1)*m_sizeX + i-1) + 2]*matrix[6]/normalizator + 
										m_fractal[3*((j+1)*m_sizeX + i) + 2]*matrix[7]/normalizator + 
										m_fractal[3*((j+1)*m_sizeX + i+1) + 2]*matrix[8]/normalizator;
		}
	
	for(int i = 1; i < m_sizeX-1; i++)
		for(int j = 1; j < m_sizeY-1; j++)
		{
			m_fractal[3*(j*m_sizeX + i)] = tempImage[3*(j*m_sizeX + i)];
			m_fractal[3*(j*m_sizeX + i) + 1] = tempImage[3*(j*m_sizeX + i) + 1];
			m_fractal[3*(j*m_sizeX + i) + 2] = tempImage[3*(j*m_sizeX + i) + 2];
		}

	delete [] tempImage;
}

void CFractal::SetSize(int x, int y)
{
	m_sizeY = y;
	m_sizeX = x;

	if(m_fractal)
		delete [] m_fractalOrig;
	m_fractal = new unsigned char[3*m_sizeX*m_sizeY];
	m_fractalOrig = m_fractal;
	memset(m_fractal, 0, 3*m_sizeX*m_sizeY*sizeof(unsigned char));
}

void CFractal::SetCustomPalette(unsigned char *pal, int size)
{
	if(m_customPalette != NULL)
		delete m_customPalette;

	m_customPaletteSize = size;
	m_customPalette = new unsigned char[size];
	memcpy(m_customPalette, pal, sizeof(unsigned char)*size);
}

void CFractal::SetActualPalette(int i)
{
	m_actualPaletteIndex = i;
	if(i == PALETTE_CUSTOM)
	{
		m_actualPalette = m_customPalette;
		m_actualPaletteSize = m_customPaletteSize;
		m_actualIndexIncrement = m_customIndexIncrement;
		m_actualIndexValue = m_customIndexValue;
	}
	else
	{
		if(i > m_paletteCount - 1)
			i = m_paletteCount - 1;
		m_actualPalette = m_palette[i];
		m_actualPaletteSize = m_paletteSize[i];
		m_actualIndexIncrement = m_indexIncrement[i];
		m_actualIndexValue = m_indexValue[i];
	}

}

void CFractal::CopyToLocation(unsigned char *loc)
{
	if(m_fractal != NULL)
	{
		memcpy(loc, m_fractalOrig, m_sizeX*m_sizeY*3*sizeof(unsigned char));
	}

	m_fractal = loc;
}
