#ifndef CJULIA_H
#define CJULIA_H

#include "windows.h"
#include "CFractal.h"

class CJulia: public CFractal
{
private:
	complex m_z;

	void CreateDefPalette();
public:
	CJulia(HWND hwnd = NULL, CJulia *model = NULL);
	CJulia(int x, int y, HWND hwnd, CJulia *model = NULL);

	void Compute();
	void Compute(int y, int n);
	void Reset();
	void SetSeed(complex z) { m_z.r = z.r; m_z.i = z.i; };
	void SetSeed(long double r, long double i) { m_z.r = r; m_z.i = i; };
	complex GetSeed() { return m_z; };
	void InitPosition();
	void SetBlurStrength(int blurStrength);
};

#endif //CJULIA_H