#include "CJuliaAnimObject.h"
#include "CMandelbrot.h"
#include "CJulia.h"
#include "CAnimationPath.h"
#include "NURBS.h"
#include "CThreadManager.h"

CJuliaAnimObject::CJuliaAnimObject(CNURBS *path, int FPS, int iterationCount, int quality, HWND hwnd)
: m_path(path),
  m_actualStep(0)
{
	m_hwnd = hwnd;
	m_quality = quality;
	m_FPS = FPS;
	m_animObjectType = JULIA_ANIM_OBJECT;
	m_actualFrame = 0;
	m_numFrames = m_path->GetFramesCount();
	m_prevNumFrames = m_numFrames;
	m_frames = new CFractal*[m_numFrames];
	m_iterationCount = iterationCount;
	for(int i = 0; i < m_numFrames; i++)
	{
		switch(m_quality)
		{
			case 0:
				m_frames[i] = new CJulia(320, 256, m_hwnd);
			break;
			case 1:
				m_frames[i] = new CJulia(640, 512, m_hwnd);
			break;
			case 2:
				m_frames[i] = new CJulia(800, 640, m_hwnd);
			break;
		}
		
		m_frames[i]->SetIterationCount(iterationCount);
	}
}

void CJuliaAnimObject::Compute()
{
	threadManager->ClearTasks();
	for(int i = 0; i < m_numFrames; i++)
	{
		((CJulia*)m_frames[m_actualFrame])->SetSeed(m_path->GetFrame(m_actualFrame).r, m_path->GetFrame(m_actualFrame).i);
		threadManager->AddTask(m_frames[m_actualFrame++], 1);
	}
	threadManager->RunTasks();
}

void CJuliaAnimObject::Clear(int quality, int iterations, CFractal *model)
{
	for(int i = 0; i < m_prevNumFrames; i++)
		delete m_frames[i];
	delete [] m_frames;

	m_finishedFrameCount = 0;
	m_quality = quality;
	m_iterationCount = iterations;
	m_numFrames = m_path->GetFramesCount();
	m_frames = new CFractal*[m_numFrames];
	for(int i = 0; i < m_numFrames; i++)
	{
		switch(m_quality)
		{
			case 0:
				m_frames[i] = new CJulia(320, 256, m_hwnd);
			break;
			case 1:
				m_frames[i] = new CJulia(640, 512, m_hwnd);
			break;
			case 2:
				m_frames[i] = new CJulia(800, 640, m_hwnd);
			break;
		}
		m_frames[i]->SetIterationCount(m_iterationCount);
	}
	m_prevNumFrames = m_numFrames;
}