#ifndef CJULIAANIMOBJECT_H
#define CJULIAANIMOBJECT_H

#include "CAnimObject.h"
#include "NURBS.h"

class CAnimationPath;
class CFractal;
class CThreadManager;

extern CThreadManager *threadManager;

class CJuliaAnimObject: public CAnimObject
{
private:
	int m_actualStep;
	int m_partialStep;
	int m_iterationCount;
	CNURBS *m_path;
public:
	CJuliaAnimObject(CNURBS *path, int FPS, int iterationCount, int quality, HWND hwnd);
	~CJuliaAnimObject();
	int GetFrameStepCount() { return m_path->GetStepFrames(); };
	int GetVertexCount();
	int GetIterationCount() { return m_iterationCount; };
	void Compute();
	void SetHandle(HWND hwnd);
	void Clear(int quality, int iterations, CFractal *model = NULL);
};

#endif //CJULIAANIMOBJECT_H