#include "CMoveAnimObject.h"
#include "CMandelbrot.h"
#include "CJulia.h"
#include "CAnimationPath.h"
#include "CThreadManager.h"

CMoveAnimObject::CMoveAnimObject(char fractalType, CAnimationPath *path, int FPS, int stepFrameCount, int stepCount, HWND hwnd, int quality, CFractal *model)
: m_fractalType(fractalType)
{
	m_quality = quality;
	m_hwnd = hwnd;
	m_path = path;
	m_FPS = FPS;
	m_quality = quality;
	m_stepFramesCount = stepFrameCount;
	m_stepCount = stepCount;
	m_numFrames = (m_stepCount-1)*m_stepFramesCount;	// +1 to include last frame
	m_prevNumFrames = m_numFrames;
	m_frames = new CFractal*[m_numFrames];
	int i;
	switch(m_fractalType | m_quality << 3){		// combine type and quality into single number to use only one switch
		case 0:
			for(i = 0; i < m_numFrames; i++)
				m_frames[i] = new CMandelbrot(320, 256, m_hwnd, (CMandelbrot*)model);
		break;
		case 1: 
			for(i = 0; i < m_numFrames; i++)
				m_frames[i] = new CJulia(320, 256, m_hwnd, (CJulia*)model);
		break;
		case 8:
			for(i = 0; i < m_numFrames; i++)
				m_frames[i] = new CMandelbrot(640, 512, m_hwnd, (CMandelbrot*)model);
		break;
		case 9: 
			for(i = 0; i < m_numFrames; i++)
				m_frames[i] = new CJulia(640, 512, m_hwnd, (CJulia*)model);
		break;
		case 16:
			for(i = 0; i < m_numFrames; i++)
				m_frames[i] = new CMandelbrot(800, 640, m_hwnd, (CMandelbrot*)model);
		break;
		case 17: 
			for(i = 0; i < m_numFrames; i++)
				m_frames[i] = new CJulia(800, 640, m_hwnd, (CJulia*)model);
		break;
	}
	m_actualFrame = 0;
	m_actualStep = 0;
	m_partialStep = 0;

	m_animObjectType = MOVE_ANIM_OBJECT;
	m_path->RecalcPath();
}

void CMoveAnimObject::Compute()
{
	threadManager->ClearTasks();
	for(int i = 0; i < m_numFrames; i++)
	{
		int stepFrameCount;
		// last step interpolate between [0..1], other between [0..1) so we have fluent movement ending at the precise place
		if(m_actualStep == m_stepCount - 2)
			stepFrameCount = m_stepFramesCount - 1;
		else
			stepFrameCount = m_stepFramesCount;

		if(m_path->Get(m_actualStep).m_exp == m_path->Get(m_actualStep+1).m_exp)
			m_frames[m_actualFrame]->m_exp = m_path->Get(m_actualStep).m_exp;
		else
			m_frames[m_actualFrame]->m_exp = m_path->Get(m_actualStep).m_exp + (m_path->Get(m_actualStep + 1).m_exp - m_path->Get(m_actualStep).m_exp)*(float)m_partialStep/(stepFrameCount);

		fractalData temp = m_path->GetPartial(stepFrameCount*m_actualStep + m_partialStep, stepFrameCount);

		m_frames[m_actualFrame]->m_iterationCount = temp.m_iterationCount;
		m_frames[m_actualFrame]->m_xMax = temp.m_xMax;
		m_frames[m_actualFrame]->m_xMin = temp.m_xMin;
		m_frames[m_actualFrame]->m_yMax = temp.m_yMax;
		m_frames[m_actualFrame]->m_yMin = temp.m_yMin;

		threadManager->AddTask(m_frames[m_actualFrame], 1);
		m_actualFrame++;
		m_partialStep++;

		if(m_partialStep == m_stepFramesCount)
		{
			m_partialStep = 0;
			m_actualStep++;
		}
	}
	threadManager->RunTasks();
}

void CMoveAnimObject::Clear(int quality, int stepframes, CFractal *model)
{
	for(int i = 0; i < m_prevNumFrames; i++)
		delete m_frames[i];
	delete [] m_frames;

	m_finishedFrameCount = 0;
	m_quality = quality;
	m_stepFramesCount = stepframes;
	
	m_stepCount = m_path->GetStepCount();
	m_numFrames = (m_stepCount-1)*m_stepFramesCount;

	m_frames = new CFractal*[m_numFrames];
	int i = 0;
	switch(m_fractalType | m_quality << 3){		// combine type and quality into single number to use only one switch
		case 0:
			for(i = 0; i < m_numFrames; i++)
				m_frames[i] = new CMandelbrot(320, 256, m_hwnd, (CMandelbrot*)model);
		break;
		case 1: 
			for(i = 0; i < m_numFrames; i++)
				m_frames[i] = new CJulia(320, 256, m_hwnd, (CJulia*)model);
		break;
		case 8:
			for(i = 0; i < m_numFrames; i++)
				m_frames[i] = new CMandelbrot(640, 512, m_hwnd, (CMandelbrot*)model);
		break;
		case 9: 
			for(i = 0; i < m_numFrames; i++)
				m_frames[i] = new CJulia(640, 512, m_hwnd, (CJulia*)model);
		break;
		case 16:
			for(i = 0; i < m_numFrames; i++)
				m_frames[i] = new CMandelbrot(800, 640, m_hwnd, (CMandelbrot*)model);
		break;
		case 17: 
			for(i = 0; i < m_numFrames; i++)
				m_frames[i] = new CJulia(800, 640, m_hwnd, (CJulia*)model);
		break;
	}

	m_actualFrame = 0;
	m_actualStep = 0;
	m_partialStep = 0;

	m_prevNumFrames = m_numFrames;
}