#include "COpenGLControlAnim.h"
#include "CMandelbrot.h"
#include "CJulia.h"
#include "stdio.h"

#include <gl/gl.h>
#include <gl/glu.h>

#pragma comment (lib,"opengl32.lib")
#pragma comment (lib,"glu32.lib")
#pragma comment (lib,"glaux.lib")

//#define WM_UPDATEPOSITION	WM_APP + 0x162
//#define WM_UPDATERANGE		WM_APP + 0x164

LRESULT CALLBACK COpenGLControlAnim::WndProcWrapper(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	COpenGLControlAnim *pThis = (COpenGLControlAnim*)GetProp(hwnd,"ClassPointer");
	if(pThis) 
		return pThis->CustWndProc(hwnd,msg,wParam,lParam);
	return DefWindowProc(hwnd,msg,wParam,lParam);
}

LRESULT COpenGLControlAnim::CustWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    switch(msg)
    {
	case WM_PAINT:
		OnPaint();
	break;
	//case WM_LBUTTONDOWN:
	//	OnLButtonDown(LOWORD(lParam), HIWORD(lParam));
	//break;
	//case WM_LBUTTONUP:
	//	OnLButtonUp(LOWORD(lParam), HIWORD(lParam));
	//break;
	//case WM_RBUTTONDOWN:
	//	OnRButtonDown(LOWORD(lParam), HIWORD(lParam));
	//break;
	//case WM_RBUTTONUP:
	//	OnRButtonUp(LOWORD(lParam), HIWORD(lParam));
	//break;
	//case WM_MOUSEMOVE:
	//	//if((wParam & MK_LBUTTON) != 0)						// is L left mouse button pressed?
	//	OnMouseMove(LOWORD(lParam), HIWORD(lParam));
	break;
	case WM_DESTROY:
	 	wglMakeCurrent(NULL,NULL);	//neaktvny render contex
	    wglDeleteContext(m_hRC);		//zmae rendering contex	
		::ReleaseDC(m_hwndCtrl,m_hDC);		//ukon vykreslovanie	
	break;
	default:
        break;
    }

    return DefWindowProc(hwnd, msg, wParam, lParam);
}

COpenGLControlAnim::COpenGLControlAnim(HWND hwndParent, int quality) 
: m_hwndParent(hwndParent),
  m_className(_T("OpenGLControlAnim")),
  m_quality(quality)
{
	switch(m_quality)
	{
	case 0:
		m_width = 320;
		m_height = 256;
	break;
	case 1:
		m_width = 640;
		m_height = 512;
	break;
	case 2:
		m_width = 800;
		m_height = 640;
	break;
	}
  
	InitCustomControl();
	CreateCustomControl();
	OnCreate();
}

COpenGLControlAnim::~COpenGLControlAnim()
{
	//delete m_fractalObject;
}

void COpenGLControlAnim::InitCustomControl()
{
    WNDCLASSEX wc;
    
    wc.cbSize         = sizeof(wc);
    wc.lpszClassName  = m_className;
    wc.hInstance      = GetModuleHandle(0);
    wc.lpfnWndProc    = WndProcWrapper;
    wc.hCursor        = LoadCursor (NULL, IDC_ARROW);
    wc.hIcon          = 0;
    wc.lpszMenuName   = 0;
    wc.hbrBackground  = (HBRUSH)GetSysColorBrush(COLOR_BTNFACE);
    wc.style          = CS_OWNDC;
    wc.cbClsExtra     = 0;
    wc.cbWndExtra     = 0;
    wc.hIconSm        = 0;


    RegisterClassEx(&wc);
}


void COpenGLControlAnim::CreateCustomControl()
{
	m_hwndCtrl = CreateWindowEx(
                 WS_EX_CLIENTEDGE, 
                 m_className,
                 _T("OpenGL control Anim"),
                 WS_VISIBLE | WS_CHILD,
                 5, 5, m_width + 4, m_height + 4,
                 m_hwndParent,
                 NULL, GetModuleHandle(0), NULL
               );

	SetProp(m_hwndCtrl,"ClassPointer",(HANDLE)this);
}

int COpenGLControlAnim::MySetPixelFormat(HDC hdc)
{
	    PIXELFORMATDESCRIPTOR *ppfd; 
		int pixelformat; 
 
	    PIXELFORMATDESCRIPTOR pfd = { 
		sizeof(PIXELFORMATDESCRIPTOR),	
        1,									//slo verzie
        PFD_DRAW_TO_WINDOW |				//Pixel Format mus podporova okno...
        PFD_SUPPORT_OPENGL |				//...aj OpenGL
        PFD_DOUBLEBUFFER,					//mus podporova double buffering
        PFD_TYPE_RGBA,						//vyaduje RGBA Format
        32,									//nastav farebn hbku
        0,0,0,0,0,0,						//farebn hbka ignorovan
        8,									//iadny alpha buffer
        0,									//Shift Bit ignorovan
        8,									//iadny Accumulation buffer
        0,0,0,0,							//Accumulation bity ignorovan
        64,									//32 bitov Z-Buffer
        8,									//iadny stencil buffer
        8,									//iadny auxiliary buffer
        PFD_MAIN_PLANE,						//hlavn vykreslovacia vrstva
        0,									//rezervovan
        0,0,0								//Layer Masks ignorovan
    }; 
   
    ppfd = &pfd;
 
    if ( (pixelformat = ChoosePixelFormat(hdc, ppfd)) == 0 ) 
    { 
        ::MessageBox(NULL, "ChoosePixelFormat failed", "Error", MB_OK); 
        return FALSE; 
    } 
 
    if (SetPixelFormat(hdc, pixelformat, ppfd) == FALSE) 
    { 
        ::MessageBox(NULL, "SetPixelFormat failed", "Error", MB_OK); 
        return FALSE; 
    } 
 
    return TRUE; 
}

int COpenGLControlAnim::OnCreate() 
{
    //zsk device context
	m_hDC = GetDC(m_hwndCtrl);
    //ak neiel nastavi pixel formt ukonenie + hlka
	if(!MySetPixelFormat(m_hDC))
    {
		::MessageBox(::GetFocus(),"MySetPixelFormat Failed!","Error",MB_OK);
		return -1;
    }

	//vytvorme a nastavme render contex
    m_hRC = wglCreateContext(m_hDC);
	
	wglMakeCurrent(m_hDC,m_hRC);
	
	//m_fractalObject = new CMandelbrot();
	//m_fractalObject->SetSize(m_width, m_height);
	//m_fractalObject->SetIterationCount(128);
	
	//m_fractalObject->Compute();

	InitGL();
	
    return 0;
}

int COpenGLControlAnim::InitGL(void)									
{
	glEnable(GL_TEXTURE_2D);
	glDisable(GL_DEPTH_TEST);
	
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

	glMatrixMode(GL_PROJECTION);						// Modeling transformation
	glLoadIdentity();									// Reset The View
	glOrtho(-1, 1, -1, 1, -1, 1);	
	
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	wglMakeCurrent(m_hDC,m_hRC);
	//glGenTextures(1, &m_texture);
	m_texture = 0;
	//glBindTexture(GL_TEXTURE_2D, m_texture);
	//glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, m_fractalObject->GetSizeXc(), m_fractalObject->GetSizeY(), 0, GL_RGB, GL_UNSIGNED_BYTE, m_fractalObject->GetImage());

	//glPointSize(4);
	return TRUE;										
}

void COpenGLControlAnim::OnPaint() 
{
	wglMakeCurrent(m_hDC,m_hRC);
		
	Draw();
	SwapBuffers(m_hDC);
}


void COpenGLControlAnim::Draw()
{
	glBindTexture(GL_TEXTURE_2D, m_texture);

	glBegin(GL_QUADS);
		glTexCoord2f(0.0f, (float)m_fractalObject->GetSizeY()/(float)m_fractalObject->GetSizeYc()); glVertex2f(-1, 1);
		glTexCoord2f(0.0f, 0.0f); glVertex2f(-1, -1);
		glTexCoord2f((float)m_fractalObject->GetSizeX()/(float)m_fractalObject->GetSizeXc(), 0.0f); glVertex2f(1, -1);
		glTexCoord2f((float)m_fractalObject->GetSizeX()/(float)m_fractalObject->GetSizeXc(), (float)m_fractalObject->GetSizeY()/(float)m_fractalObject->GetSizeYc()); glVertex2f(1, 1);
	glEnd();

	glColor3f(1.0f, 1.0f, 1.0f);
}

void COpenGLControlAnim::SetCurrentFractalObject(CFractal *fractal)
{
	m_fractalObject = fractal;
	glBindTexture(GL_TEXTURE_2D, m_texture);
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, m_fractalObject->GetSizeXc(), m_fractalObject->GetSizeYc(), 0, GL_RGB, GL_UNSIGNED_BYTE, m_fractalObject->GetImage());

	OnPaint();
}