#ifndef COPENGLCONTROLANIM_H
#define COPENGLCONTROLANIM_H

#include "windows.h"
#include <tchar.h>

class CFractal;

class COpenGLControlAnim
{
private:
	unsigned int m_texture;
	CFractal *m_fractalObject;
	int m_width, m_height;
	int m_quality;

	HWND m_hwndCtrl;
	HWND m_hwndParent;
	
	HDC	m_hDC;		// GDI Device Context
	HGLRC m_hRC;		// Rendering Context
	TCHAR *m_className;// = _T("OpenGLControl");

	int InitGL();	//inicializcia OpenGL
	void Draw();

	void CreateCustomControl();

	int MySetPixelFormat(HDC hdc);
	int OnCreate();
	void InitCustomControl();
	
	LRESULT CALLBACK CustWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK WndProcWrapper(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

	void OnPaint();
	//void OnLButtonDown(int x, int y);
	//void OnLButtonUp(int x, int y);
	//void OnRButtonDown(int x, int y);
	//void OnRButtonUp(int x, int y);
	//void OnMouseMove(int x, int y);

public:
	COpenGLControlAnim(HWND hwndParent, int quality);
	virtual ~COpenGLControlAnim();

	void SetCurrentFractalObject(CFractal *fractal);
	//CFractal *GetFractalObject() { return m_fractalObject; };
	HWND GetHandle() { return m_hwndCtrl; };
	//void SetPointPossition(float x, float y);
	//float GetPointX() { return m_pointX; };
	//float GetPointY() { return m_pointY; };
	//void SetStepFrames(int i);
	//void SetFrame(int i);
	//int GetRange();
	//CNURBS *GetNURBSObject() { return m_NURBS; };
};

#endif // COPENGLCONTROLANIM_H
