#include "COpenGLControlColor.h"
#include "CMandelbrot.h"
#include "CJulia.h"
#include "CAnimObject.h"
#include "CAnimationPath.h"
#include "stdio.h"

#include <gl/gl.h>
#include <gl/glu.h>

#pragma comment (lib,"opengl32.lib")
#pragma comment (lib,"glu32.lib")
#pragma comment (lib,"glaux.lib")

LRESULT CALLBACK COpenGLControlColor::CustWndProcWrapper(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	COpenGLControlColor *pThis = (COpenGLControlColor*)GetProp(hwnd,"ClassPointer");
	if(pThis) 
		return pThis->CustWndProc(hwnd,msg,wParam,lParam);
	return DefWindowProc(hwnd,msg,wParam,lParam);
}

LRESULT COpenGLControlColor::CustWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    switch(msg)
    {
	case WM_PAINT:
		wglMakeCurrent(m_hDC,m_hRC);
		OnPaint();
		//wglMakeCurrent(NULL,NULL);	//neaktvny render contex
	break;
	//case WM_RBUTTONDOWN:
	//	OnRButtonDown(wParam, lParam);
	//break;
	case WM_LBUTTONDOWN:
		OnLButtonDown(wParam, lParam);
	break;
	//case WM_LBUTTONUP:
	//	OnLButtonUp(wParam, lParam);
	//break;
	//case WM_MOUSEMOVE:
	//	OnMouseMove(wParam, lParam);
	//break;
	case WM_DESTROY:
	 	wglMakeCurrent(NULL,NULL);	//neaktvny render contex
	    wglDeleteContext(m_hRC);		//zmae rendering contex	
		::ReleaseDC(m_hwndCtrl,m_hDC);		//ukon vykreslovanie	
	//	delete m_fractalObject;
	break;
	default:
        break;
    }

    return DefWindowProc(hwnd, msg, wParam, lParam);
}

COpenGLControlColor::COpenGLControlColor(HWND hwndParent, int index)
: m_className(_T("OpenGLControlColor")),
  //m_animationStep(0),
  //m_path(NULL),
  m_hwndParent(hwndParent),
  //m_fractalType(FRACTAL_TYPE_MAND),
  //m_drag_x_e(0),m_drag_x_s(0),m_drag_y_e(0),m_drag_y_s(0),
  //m_dragging(false)
  m_r(255), m_g(255), m_b(255)
{
	InitCustomControl();
	CreateCustomControl(index);
	OnCreate();
}

COpenGLControlColor::~COpenGLControlColor()
{

}

void COpenGLControlColor::InitCustomControl()
{
    WNDCLASSEX wc;
    
    wc.cbSize         = sizeof(wc);
    wc.lpszClassName  = m_className;
    wc.hInstance      = GetModuleHandle(0);
    wc.lpfnWndProc    = CustWndProcWrapper;
    wc.hCursor        = LoadCursor (NULL, IDC_ARROW);
    wc.hIcon          = 0;
    wc.lpszMenuName   = 0;
    wc.hbrBackground  = (HBRUSH)GetSysColorBrush(COLOR_BTNFACE);
    wc.style          = CS_OWNDC;
    wc.cbClsExtra     = 0;
    wc.cbWndExtra     = 0;
    wc.hIconSm        = 0;


    RegisterClassEx(&wc);
}


void COpenGLControlColor::CreateCustomControl(int index)
{
	int x,y;
	if(index == 0)
	{
		m_r = 0.0f;
		m_g = 0.0f;
		m_b = 0.0f;
		x = 10;
		y = 105;
	}
	else
	if(index < 6)
	{
		x = (index+1)*10 + index*32;
		y = 105;
	}
	else
	{
		x = (index-5)*10 + (index - 6)*32;
		y = 147;
	}

	m_hwndCtrl = CreateWindowEx(
                 WS_EX_STATICEDGE, // give it a standard border
                 m_className,
                 _T("OpenGL control color"),
                 WS_VISIBLE | WS_CHILD,
                 x, y, 32, 32,
                 m_hwndParent,
                 NULL, GetModuleHandle(0), NULL
               );

	SetProp(m_hwndCtrl,"ClassPointer",(HANDLE)this);
}

int COpenGLControlColor::MySetPixelFormat(HDC hdc)
{
	    PIXELFORMATDESCRIPTOR *ppfd; 
		int pixelformat; 
 
	    PIXELFORMATDESCRIPTOR pfd = { 
		sizeof(PIXELFORMATDESCRIPTOR),	
        1,									//slo verzie
        PFD_DRAW_TO_WINDOW |				//Pixel Format mus podporova okno...
        PFD_SUPPORT_OPENGL |				//...aj OpenGL
        PFD_DOUBLEBUFFER,					//mus podporova double buffering
        PFD_TYPE_RGBA,						//vyaduje RGBA Format
        32,									//nastav farebn hbku
        0,0,0,0,0,0,						//farebn hbka ignorovan
        8,									//iadny alpha buffer
        0,									//Shift Bit ignorovan
        8,									//iadny Accumulation buffer
        0,0,0,0,							//Accumulation bity ignorovan
        64,									//32 bitov Z-Buffer
        8,									//iadny stencil buffer
        8,									//iadny auxiliary buffer
        PFD_MAIN_PLANE,						//hlavn vykreslovacia vrstva
        0,									//rezervovan
        0,0,0								//Layer Masks ignorovan
    }; 
   
    ppfd = &pfd;
 
    if ( (pixelformat = ChoosePixelFormat(hdc, ppfd)) == 0 ) 
    { 
        ::MessageBox(NULL, "ChoosePixelFormat failed", "Error", MB_OK); 
        return FALSE; 
    } 
 
    if (SetPixelFormat(hdc, pixelformat, ppfd) == FALSE) 
    { 
        ::MessageBox(NULL, "SetPixelFormat failed", "Error", MB_OK); 
        return FALSE; 
    } 
 
    return TRUE; 
}

int COpenGLControlColor::OnCreate() 
{
	m_hDC = GetDC(m_hwndCtrl);
    if(!MySetPixelFormat(m_hDC))
    {
		::MessageBox(::GetFocus(),"MySetPixelFormat Failed!","Error",MB_OK);
		return -1;
    }

	m_hRC = wglCreateContext(m_hDC);
    
	wglMakeCurrent(m_hDC,m_hRC);

	//m_fractalObject = new CMandelbrot();
	
	//if(def != NULL)
	//	m_fractalObject->SetTexture(def->GetImage(), def->GetSizeXc()*def->GetSizeYc()*sizeof(unsigned char)*3);
	//else
	//	m_fractalObject->Compute();

	InitGL();	//inicializcia OpenGL

	OnPaint();
	//PostMessage(m_hwndCtrl, WM_PAINT, NULL, NULL);

    return 0;
}

int COpenGLControlColor::InitGL(void)									
{
	glEnable(GL_TEXTURE_2D);
	glClearColor(1.0f, 1.0f, 1.0f, 0.0f);				// ierne pozadie
	glClearDepth(1.0f);									// Nastav Depth Buffer na 1
	
	//glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
    //glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
	//glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	//glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	
	glMatrixMode(GL_PROJECTION);						// Modeling transformation
	glLoadIdentity();									// Reset The View
	glOrtho(-1, 1, -1, 1, -1, 1);	

	//glGenTextures(1, &m_texture);
	//m_texture = 0;
	//glBindTexture(GL_TEXTURE_2D, m_texture);
	//glTexImage2D(GL_TEXTURE_2D, 0, 3, m_fractalObject->GetSizeXc(), m_fractalObject->GetSizeYc(), 0, GL_RGB, GL_UNSIGNED_BYTE, m_fractalObject->GetImage());
	
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	return TRUE;										
}

void COpenGLControlColor::OnPaint() 
{
	glClearColor(m_r, m_g, m_b, 0.0f);
	glClear(GL_COLOR_BUFFER_BIT);	// Vyist obrazovku a Depth Buffer

	//Draw();	//kreslenie fraktlu

	SwapBuffers(m_hDC);	//prehod buffery
}


void COpenGLControlColor::Draw()	//vykreslenie fraktlu
{
	//long double animationChangeXmax = 0;
	//long double animationChangeXmin = 0;
	//long double animationChangeYmax = 0;
	//long double animationChangeYmin = 0;

	//glBindTexture(GL_TEXTURE_2D, m_texture);

	// vytvor textru z fraktlu v pamti
	//if(m_animationStep == 0){
	//	glTexImage2D(GL_TEXTURE_2D, 0, 3, m_fractalObject->GetSizeXc(), m_fractalObject->GetSizeYc(), 0, GL_RGB, GL_UNSIGNED_BYTE, m_fractalObject->GetImage());
	//}
	//else{	
	//	animationChangeXmax = 0.625*(xMaxPrev - m_fractalObject->m_xMax)*5*m_animationStep /(32*m_fractalObject->m_zoomDepth);
	//	animationChangeXmin = 0.625*(xMinPrev - m_fractalObject->m_xMin)*5*m_animationStep /(32*m_fractalObject->m_zoomDepth);
	//	animationChangeYmax = 0.75*(yMaxPrev - m_fractalObject->m_yMax)*m_animationStep /(4*m_fractalObject->m_zoomDepth);
	//	animationChangeYmin = 0.75*(yMinPrev - m_fractalObject->m_yMin)*m_animationStep /(4*m_fractalObject->m_zoomDepth);
	//}
	
	// vykresl textru
	/*glBegin(GL_QUADS);
		glTexCoord2f(0.0f, (float)m_fractalObject->GetSizeY()/(float)m_fractalObject->GetSizeYc()); glVertex2f(-1, 1);
		glTexCoord2f(0.0f, 0.0f); glVertex2f(-1, -1);
		glTexCoord2f((float)m_fractalObject->GetSizeX()/(float)m_fractalObject->GetSizeXc(), 0.0f); glVertex2f(1, -1);
		glTexCoord2f((float)m_fractalObject->GetSizeX()/(float)m_fractalObject->GetSizeXc(), (float)m_fractalObject->GetSizeY()/(float)m_fractalObject->GetSizeYc()); glVertex2f(1, 1);
	glEnd();

	if(m_dragging)
	{
		glBegin(GL_LINE_LOOP);
			glVertex2f(2*(float)m_drag_x_s/(float)m_fractalObject->GetSizeX() - 1, - 2*(float)m_drag_y_s/(float)m_fractalObject->GetSizeY() + 1);
			glVertex2f(2*(float)m_drag_x_e/(float)m_fractalObject->GetSizeX() - 1, - 2*(float)m_drag_y_s/(float)m_fractalObject->GetSizeY() + 1);
			glVertex2f(2*(float)m_drag_x_e/(float)m_fractalObject->GetSizeX() - 1, - 2*(float)m_drag_y_e/(float)m_fractalObject->GetSizeY() + 1);
			glVertex2f(2*(float)m_drag_x_s/(float)m_fractalObject->GetSizeX() - 1, - 2*(float)m_drag_y_e/(float)m_fractalObject->GetSizeY() + 1);
		glEnd();
	}*/
}

//void COpenGLControl::OnMouseMove(WPARAM wParam, LPARAM lParam)
//{
//	if(m_dragging)
//	{
//		m_drag_x_e = LOWORD(lParam);
//		m_drag_y_e = HIWORD(lParam);
//		OnPaint();
//	}
//}

void COpenGLControlColor::OnLButtonDown(WPARAM wParam, LPARAM lParam) 
{
	//PostMessage(m_hwndCtrl, WM_PAINT, NULL, NULL);
}

//void COpenGLControl::OnLButtonUp(WPARAM wParam, LPARAM lParam) 
//{
//	m_dragging = false;
//	if(m_fractalObject->ZoomIn(m_drag_x_s, m_drag_y_s, m_drag_x_e, m_drag_y_e))
//	{
//		m_fractalObject->Compute();
//	
//		if(m_path && m_path->m_active)
//			m_path->Add(m_fractalObject->m_zoomDepth, m_fractalObject->m_xMin, m_fractalObject->m_xMax, m_fractalObject->m_yMin, m_fractalObject->m_yMax, m_fractalObject->m_exp, m_fractalObject->m_iterationCount);
//	//	PostMessage(m_hwndCtrl, WM_PAINT, NULL, NULL);
//	}
//	OnPaint();
//}
//
//void COpenGLControl::OnRButtonDown(WPARAM wParam, LPARAM lParam) 
//{
////	xMaxPrev = m_fractalObject->m_xMax;
////	xMinPrev = m_fractalObject->m_xMin;
////	yMaxPrev = m_fractalObject->m_yMax;
////	yMinPrev = m_fractalObject->m_yMin;
//	m_fractalObject->ZoomOut(LOWORD(lParam), HIWORD(lParam));
//
//	//for(int i = 0; i < m_fractalObject->GetSizeX(); i++){
//	m_fractalObject->Compute();
////		if(i % 8 == 0){
////			m_animationStep = 4*((float)i / m_fractalObject->GetSizeX());
////			OnPaint();
////		}
////	}
////	m_animationStep = 0;
//	
////	xMaxPrev = 0;
////	xMinPrev = 0;
////	yMaxPrev = 0;
////	yMinPrev = 0;
//
//	if(m_path && m_path->m_active)
//		m_path->Add(m_fractalObject->m_zoomDepth, m_fractalObject->m_xMin, m_fractalObject->m_xMax, m_fractalObject->m_yMin, m_fractalObject->m_yMax, m_fractalObject->m_exp, m_fractalObject->m_iterationCount);
//
//	PostMessage(m_hwndCtrl, WM_PAINT, NULL, NULL);			
//}
//
//void COpenGLControl::OnKeyPress(WPARAM wParam){
//	switch((int)wParam){
//		case VK_SUBTRACT:
//			DecreaseIterationCount();
//		break;
//		case VK_ADD:
//			IncreaseIterationCount();
//		break;
//	}
//}
//
//void COpenGLControl::IncreaseIterationCount(){
//	m_fractalObject->SetIterationCount(m_fractalObject->GetIterationCount()*1.5);
//	for(int i = 0; i < m_fractalObject->GetSizeX(); i++){
//		m_fractalObject->Compute(i);
//		if(i % 8 == 0)
//			OnPaint();
//	}
//	OnPaint();
//}
//
//void COpenGLControl::DecreaseIterationCount(){
//	m_fractalObject->SetIterationCount(m_fractalObject->GetIterationCount()/1.5);
//	for(int i = 0; i < m_fractalObject->GetSizeX(); i++){
//		m_fractalObject->Compute(i);
//		if(i % 8 == 0)
//			OnPaint();
//	}
//	OnPaint();
//}
//
//// Set Mandelbrot Set as current displayed fractal
//void COpenGLControl::SetCurrentMandelbrot(){
//	//int color;
//	//if(m_fractalObject != NULL)
//	//	color = m_fractalObject->GetColoring();
//
//	delete m_fractalObject;
//	m_fractalObject = new CMandelbrot();
//	//m_fractalObject->SetColoring(color);
//	m_fractalObject->Compute();
//	m_fractalType = FRACTAL_TYPE_MAND;
//	PostMessage(m_hwndCtrl, WM_PAINT, NULL, NULL);			
//}
//
//// Set Julia Set as current displayed fractal
//void COpenGLControl::SetCurrentJulia(){
//	//int color;
//	//if(m_fractalObject != NULL)
//	//	color = m_fractalObject->GetColoring();
//	
//	delete m_fractalObject;
//	m_fractalObject = new CJulia();
//	//m_fractalObject->SetColoring(color);
//	m_fractalObject->Compute();
//	m_fractalType = FRACTAL_TYPE_JULIA;
//	PostMessage(m_hwndCtrl, WM_PAINT, NULL, NULL);
//}
//
//void COpenGLControl::SetCurrentJulia(float x, float y){
//	//int color;
//	//if(m_fractalObject != NULL)
//	//	color = m_fractalObject->GetColoring();
//	
//	delete m_fractalObject;
//	m_fractalObject = new CJulia();
//	((CJulia*)m_fractalObject)->SetSeed(x,y);
//	//m_fractalObject->SetColoring(color);
//	m_fractalObject->Compute();
//	m_fractalType = FRACTAL_TYPE_JULIA;
//	PostMessage(m_hwndCtrl, WM_PAINT, NULL, NULL);
//}
//
//void COpenGLControl::SaveToBmp(const char *fileName, unsigned char *texture, int width, int height){
//	//int i, j=0;
//	HANDLE file;
//	BITMAPFILEHEADER fileHeader; 
//	BITMAPINFOHEADER infoHeader;
//	RGBTRIPLE rgb;
//	DWORD writeSize;
//	
//	file = CreateFile(fileName, GENERIC_WRITE, FILE_SHARE_WRITE, (LPSECURITY_ATTRIBUTES)NULL, CREATE_ALWAYS, 0, (HANDLE)NULL);
//	
//	if(file == NULL){
//		MessageBox(NULL,"Unable to load specified file","AFractal error",MB_OK|MB_ICONSTOP);
//		return;
//	}
//	fileHeader.bfType = 19778;
//	fileHeader.bfSize = 54 + 3*width*height;
//	fileHeader.bfReserved1 = 0;
//	fileHeader.bfReserved2 = 0;
//	fileHeader.bfOffBits = 54;
//
//	infoHeader.biSize = sizeof(BITMAPINFOHEADER);
//    infoHeader.biWidth = width;
//    infoHeader.biHeight = height;
//    // Default number of planes
//    infoHeader.biPlanes = 1;
//    // Bit count
//    infoHeader.biBitCount = 24;
//    // Store as un Compressed
//    infoHeader.biCompression = BI_RGB;
//    // Calculate the image size in bytes
//    infoHeader.biSizeImage = width*height;
//
//    // Use as many colors according to bits per pixel
//    infoHeader.biClrUsed = 0;
//    // Use all colors
//    infoHeader.biClrImportant = 0;
//
//	WriteFile(file, &fileHeader, sizeof(fileHeader), &writeSize, NULL);
//	WriteFile(file, &infoHeader, sizeof(infoHeader), &writeSize, NULL);
//
//	int i = 0;
//	int tmp = width-1;				// if width is x^2 then we need to make one iteration less, other sizes won't be affected
//	while(tmp != 0){
//		tmp = tmp >> 1;
//		i++;
//	}
//	int width2 = 1 << i;
//
//	i = 0;
//	tmp = height-1;				// if width is x^2 then we need to make one iteration less, other sizes won't be affected
//	while(tmp != 0){
//		tmp = tmp >> 1;
//		i++;
//	}
//	int height2 = 1 << i;
//
//	int j = 0;
//	for(i = 0; i< width*height; i++){
//		rgb.rgbtRed = texture[j+0];  // Red component
//		rgb.rgbtGreen = texture[j+1]; // Green component
//		rgb.rgbtBlue = texture[j+2]; // Blue component
//		if((i+1)%width == 0)
//			j+= 3*(width2 - width + 1);
//		else
//			j += 3; 
//		WriteFile(file, &rgb, sizeof(rgb), &writeSize, NULL);
//	}
//		
//	CloseHandle(file);
//}
//
//void COpenGLControl::DrawAnimation(CAnimObject *animationObject){
//	CFractal *actual;
//	animationObject->Reset();
//	for(int i = 0; i < animationObject->GetNumFrames(); i++){
//		Sleep(1000/animationObject->GetFPS());
//		
//		actual = animationObject->GetActualFrame();
//		glBindTexture(GL_TEXTURE_2D, m_texture);
//	
//		//glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
//	    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
//
//		// vytvor textru z fraktlu v pamti
//		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
//		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
//		glTexImage2D(GL_TEXTURE_2D, 0, 3, actual->GetSizeXc(), actual->GetSizeYc(), 0, GL_RGB, GL_UNSIGNED_BYTE, actual->GetImage());
//	
//		// vykresl textru
//		glBegin(GL_QUADS);
//			glTexCoord2f(0.0f, 1.0f); glVertex2f(-1, 1);
//			glTexCoord2f(0.0f, 0.0f); glVertex2f(-1, -1);
//			glTexCoord2f(0.625f, 0.0f); glVertex2f(1, -1);
//			glTexCoord2f(0.625f, 1.0f); glVertex2f(1, 1);
//		glEnd();
//
//		SwapBuffers(m_hDC);
//
//	}
//	
//	m_fractalObject->SetTexture(actual->GetImage(), actual->GetSizeY()*actual->GetSizeXc()*3);
//	m_fractalObject->m_exp = actual->m_exp;
//	m_fractalObject->m_iterationCount = actual->m_iterationCount;
//	m_fractalObject->m_zoomDepth = actual->m_zoomDepth;
//	m_fractalObject->m_xMax = actual->m_xMax;
//	m_fractalObject->m_xMin = actual->m_xMin;
//	m_fractalObject->m_yMax = actual->m_yMax;
//	m_fractalObject->m_yMin = actual->m_yMin;
//
//	animationObject->Reset();
//}
//
//void COpenGLControl::SetData(CMandelbrot *data)
//{
//	m_fractalObject->SetTexture(data->GetImage(), data->GetSizeXc()*data->GetSizeYc()*sizeof(unsigned char)*3);
//}