#include "COpenGLControlJulia.h"
//#include "CMandelbrot.h"
#include "CJulia.h"
//#include "CAnimObject.h"
#include "stdio.h"

#include <gl/gl.h>
#include <gl/glu.h>

#pragma comment (lib,"opengl32.lib")
#pragma comment (lib,"glu32.lib")
#pragma comment (lib,"glaux.lib")

LRESULT CALLBACK COpenGLControlJulia::JuliaWndProcWrapper(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	COpenGLControlJulia *pThis = (COpenGLControlJulia*)GetProp(hwnd,"ClassPointer");
	if(pThis) 
		return pThis->CustWndProc(hwnd,msg,wParam,lParam);
	return DefWindowProc(hwnd,msg,wParam,lParam);
}

LRESULT COpenGLControlJulia::CustWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    switch(msg)
    {
	case WM_PAINT:
		wglMakeCurrent(m_hDC,m_hRC);
		OnPaint();
	break;
	case WM_DESTROY:
		wglMakeCurrent(NULL,NULL);	//neaktvny render contex
	    wglDeleteContext(m_hRC);		//zmae rendering contex	
		::ReleaseDC(m_hwndCtrl,m_hDC);		//ukon vykreslovanie	
	break;
	default:
        break;
    }

    return DefWindowProc(hwnd, msg, wParam, lParam);
}

COpenGLControlJulia::COpenGLControlJulia(HWND hwndParent, int quality, long double seedX, long double seedY)
: m_hwndParent(hwndParent),
  m_className(_T("OpenGLControlJulia")),
  m_quality(quality),
  m_seedX(seedX), m_seedY(seedY)
{
	switch(m_quality)
	{
	case PREVIEW_QUALITY_ANIM:
	case PREVIEW_QUALITY_LOW:
		m_width = 160;
		m_height = 128;
		m_iterationCount = 128;
	break;
	case PREVIEW_QUALITY_MEDIUM:
		m_width = 320;
		m_height = 256;
		m_iterationCount = 64;
	break;
	case PREVIEW_QUALITY_HIGH:
		m_width = 320;
		m_height = 256;
		m_iterationCount = 128;
	break;
	}
	InitCustomControl();
	CreateCustomControl();
	OnCreate();
}

COpenGLControlJulia::~COpenGLControlJulia()
{
	delete m_fractalObject;
}

void COpenGLControlJulia::InitCustomControl()
{
    WNDCLASSEX wc;
    
    wc.cbSize         = sizeof(wc);
    wc.lpszClassName  = m_className;
    wc.hInstance      = GetModuleHandle(0);
    wc.lpfnWndProc    = JuliaWndProcWrapper;
    wc.hCursor        = LoadCursor (NULL, IDC_ARROW);
    wc.hIcon          = 0;
    wc.lpszMenuName   = 0;
    wc.hbrBackground  = (HBRUSH)GetSysColorBrush(COLOR_BTNFACE);
    wc.style          = CS_OWNDC;
    wc.cbClsExtra     = 0;
    wc.cbWndExtra     = 0;
    wc.hIconSm        = 0;

    RegisterClassEx(&wc);
}


void COpenGLControlJulia::CreateCustomControl()
{
	int x,y;
	switch(m_quality)
	{
	case PREVIEW_QUALITY_LOW:
		x = 330 + m_width/4;
		y = 5 + m_height/4;
	break;
	case PREVIEW_QUALITY_MEDIUM:
	case PREVIEW_QUALITY_HIGH:
		x = 330;
		y = 5;
	break;
	case PREVIEW_QUALITY_ANIM:
		x = 650;
		y = 389;
	break;
	}
	m_hwndCtrl = CreateWindowEx(
                 WS_EX_CLIENTEDGE, // give it a standard border
                 m_className,
                 _T("OpenGL control Julia"),
                 WS_VISIBLE | WS_CHILD,
                 x, y, m_width + 4, m_height + 4,
                 m_hwndParent,
                 NULL, GetModuleHandle(0), NULL
               );

	SetProp(m_hwndCtrl,"ClassPointer",(HANDLE)this);
}

int COpenGLControlJulia::MySetPixelFormat(HDC hdc)
{
	PIXELFORMATDESCRIPTOR *ppfd; 
	int pixelformat; 
 
	PIXELFORMATDESCRIPTOR pfd = { 
		sizeof(PIXELFORMATDESCRIPTOR),	
        1,									//slo verzie
        PFD_DRAW_TO_WINDOW |				//Pixel Format mus podporova okno...
        PFD_SUPPORT_OPENGL |				//...aj OpenGL
        PFD_DOUBLEBUFFER,					//mus podporova double buffering
        PFD_TYPE_RGBA,						//vyaduje RGBA Format
        32,									//nastav farebn hbku
        0,0,0,0,0,0,						//farebn hbka ignorovan
        8,									//iadny alpha buffer
        0,									//Shift Bit ignorovan
        8,									//iadny Accumulation buffer
        0,0,0,0,							//Accumulation bity ignorovan
        64,									//32 bitov Z-Buffer
        8,									//iadny stencil buffer
        8,									//iadny auxiliary buffer
        PFD_MAIN_PLANE,						//hlavn vykreslovacia vrstva
        0,									//rezervovan
        0,0,0								//Layer Masks ignorovan
    }; 
   
    ppfd = &pfd;
 
    if ( (pixelformat = ChoosePixelFormat(hdc, ppfd)) == 0 ) 
    { 
        ::MessageBox(NULL, "ChoosePixelFormat failed", "Error", MB_OK); 
        return FALSE; 
    } 
 
    if (SetPixelFormat(hdc, pixelformat, ppfd) == FALSE) 
    { 
        ::MessageBox(NULL, "SetPixelFormat failed", "Error", MB_OK); 
        return FALSE; 
    } 
 
    return TRUE; 
}

int COpenGLControlJulia::OnCreate() 
{
	//zsk device context
	m_hDC = GetDC(m_hwndCtrl);

    //ak neiel nastavi pixel formt ukonenie + hlka
	if(!MySetPixelFormat(m_hDC))
    {
	::MessageBox(::GetFocus(),"MySetPixelFormat Failed!","Error",MB_OK);
	return -1;
    }

	//vytvorme a nastavme render contex
    m_hRC = wglCreateContext(m_hDC);
	
	wglMakeCurrent(m_hDC,m_hRC);
	
	m_fractalObject = new CJulia();
	m_fractalObject->SetSize(m_width, m_height);
	m_fractalObject->SetIterationCount(m_iterationCount);
	m_fractalObject->SetSeed(m_seedX, m_seedY);
	m_fractalObject->Compute();

	InitGL();	//inicializcia OpenGL
	
    return 0;
}

//OpenGL setup
int COpenGLControlJulia::InitGL(void)									
{
	glEnable(GL_TEXTURE_2D);
	glDisable(GL_DEPTH_TEST);
	
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

	glMatrixMode(GL_PROJECTION);						// Modeling transformation
	glLoadIdentity();									// Reset The View
	glOrtho(-1, 1, -1, 1, -1, 1);	
	
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	wglMakeCurrent(m_hDC,m_hRC);
	//glGenTextures(1, &m_texture);
	m_texture = 0;
	glBindTexture(GL_TEXTURE_2D, m_texture);
	glTexImage2D(GL_TEXTURE_2D, 0, 3, m_fractalObject->GetSizeXc(), m_fractalObject->GetSizeYc(), 0, GL_RGB, GL_UNSIGNED_BYTE, m_fractalObject->GetImage());
	return TRUE;										
}

void COpenGLControlJulia::OnPaint() 
{
	Draw();	//kreslenie fraktlu

	SwapBuffers(m_hDC);	//prehod buffery
}


void COpenGLControlJulia::Draw()	//vykreslenie fraktlu
{
	glBindTexture(GL_TEXTURE_2D, m_texture);
	glTexImage2D(GL_TEXTURE_2D, 0, 3, m_fractalObject->GetSizeXc(), m_fractalObject->GetSizeYc(), 0, GL_RGB, GL_UNSIGNED_BYTE, m_fractalObject->GetImage());
	glBegin(GL_QUADS);
		glTexCoord2f(0.0f, (float)m_fractalObject->GetSizeY()/(float)m_fractalObject->GetSizeYc()); glVertex2f(-1, 1);
		glTexCoord2f(0.0f, 0.0f); glVertex2f(-1, -1);
		glTexCoord2f((float)m_fractalObject->GetSizeX()/(float)m_fractalObject->GetSizeXc(), 0.0f); glVertex2f(1, -1);
		glTexCoord2f((float)m_fractalObject->GetSizeX()/(float)m_fractalObject->GetSizeXc(), (float)m_fractalObject->GetSizeY()/(float)m_fractalObject->GetSizeYc()); glVertex2f(1, 1);
	glEnd();
}

void COpenGLControlJulia::SetQuality(int quality)
{
	m_quality = quality;
	int x,y;
	switch(m_quality)
	{
	case PREVIEW_QUALITY_LOW:
		x = 330 + m_width/4;
		y = 5 + m_height/4;
		m_width = 160;
		m_height = 128;
		m_iterationCount = 64;
	break;
	case PREVIEW_QUALITY_MEDIUM:
		m_width = 320;
		m_height = 256;
		x = 330;
		y = 5;
		m_iterationCount = 64;
	break;
	case PREVIEW_QUALITY_HIGH:
		m_width = 320;
		m_height = 256;
		x = 330;
		y = 5;
		m_iterationCount = 128;
	break;
	}
	m_fractalObject->SetSize(m_width, m_height);
	m_fractalObject->SetIterationCount(m_iterationCount);
	m_fractalObject->SetSeed(m_seedX, m_seedY);
	m_fractalObject->Compute();
	SetWindowPos(m_hwndCtrl,0,x,y,m_width,m_height,SWP_NOZORDER);
	
	wglMakeCurrent(NULL,NULL);	//neaktvny render contex
	wglDeleteContext(m_hRC);		//zmae rendering contex	
	
	m_hRC = wglCreateContext(m_hDC);
	wglMakeCurrent(m_hDC,m_hRC);

	InitGL();
	
	PostMessage(m_hwndCtrl, WM_PAINT, NULL, NULL);
}