#include "StdAfx.h"
#include "CThreadManager.h"
#include "CFractal.h"

threadParam *CThreadManager::m_params;
HANDLE *CThreadManager::m_threads;
bool *CThreadManager::m_threadIdle;
int CThreadManager::m_taskIndex;
int CThreadManager::m_taskCount;

std::vector<threadParam> CThreadManager::m_tasks;

CThreadManager::CThreadManager()
{
	m_threadCount = GetCoreCount();
	m_threads = new HANDLE[m_threadCount];
	m_params = new threadParam[m_threadCount];
	m_threadIdle = new bool[m_threadCount];

	for(unsigned int i = 0; i < m_threadCount; i++)
	{
		m_threads[i] = CreateThread(NULL, 0, &CThreadManager::ThreadProc, (LPVOID)i, CREATE_SUSPENDED, NULL);
		SetThreadPriority(m_threads[i], THREAD_PRIORITY_LOWEST);
		m_threadIdle[i] = true;
	}
}

DWORD WINAPI CThreadManager::ThreadProc(LPVOID param)
{
	bool cont = true;
	int threadID = (int)param;
	HANDLE threadHandle = m_threads[threadID];
	CFractal *f;
	int concurentThreads;
	while(cont)
	{
		f = m_params[threadID].fractalHandle;
		concurentThreads = m_params[threadID].concurentThreads;
		if(concurentThreads > 1)
			f->Compute(threadID, concurentThreads);
		else
			f->Compute(0,1);
		if(TaskDone(threadID))
			SuspendThread(threadHandle);
	}
	return 0;
}

void CThreadManager::AddTask(CFractal *f, int concurentThreads)
{
	threadParam t;
#ifdef MULTITHREADING_ENABLED
	if(concurentThreads == ALL_THREADS)
		t.concurentThreads = m_threadCount;
	else
		t.concurentThreads = concurentThreads;
#else
	t.concurentThreads = 1;
#endif
	t.fractalHandle = f;
	m_tasks.push_back(t);
	m_taskCount++;
}

void CThreadManager::ClearTasks()
{
	m_tasks.clear();
	m_taskCount = 0;
	m_taskIndex = 0;
}

void CThreadManager::RunTasks()
{
	int j = 0;
	for(unsigned int i = 0; i < m_threadCount; i++)
	{
		if(i < m_tasks.size() && m_tasks.at(i).concurentThreads == 1)
		{
			m_params[i].concurentThreads = m_tasks.at(i).concurentThreads;
			m_params[i].fractalHandle = m_tasks.at(i).fractalHandle;

			m_threadIdle[i] = false;
			ResumeThread(m_threads[i]);
			m_taskIndex++;
			j++;
		}
		else
		{
			if(i < m_threadCount && j < m_tasks.size())
			{
				m_params[i].concurentThreads = m_tasks.at(j).concurentThreads;
				m_params[i].fractalHandle = m_tasks.at(j).fractalHandle;

				m_threadIdle[i] = false;
				ResumeThread(m_threads[i]);
				m_taskIndex++;
			}
		}
	}
}

bool CThreadManager::TaskDone(int threadID)
{
	m_threadIdle[threadID] = true;
	
	if(m_taskIndex < m_taskCount)
	{
		m_params[threadID].concurentThreads = m_tasks.at(m_taskIndex).concurentThreads;
		m_params[threadID].fractalHandle = m_tasks.at(m_taskIndex).fractalHandle;

		m_threadIdle[threadID] = true;

		m_taskIndex++;
		return false;
	}
	return true;
}

void CThreadManager::Abort()
{
	m_tasks.clear();
	m_taskCount = 0;
	for(unsigned int i = 0; i < m_threadCount; i++)
	{
		if(!m_threadIdle[i])
		{
			m_params[i].fractalHandle->Abort();
		}
	}
}

int CThreadManager::GetCoreCount(){
	// Number of Logical Cores per Physical Processor
	int coreCount = 1;
	// Initialize to 1 to support older processors.
	_asm {
		mov		eax, 1
			cpuid
			// Test for HTT bit
			test	edx, 0x10000000
			jz		Unp
			// Multi-core or Hyperthreading supported...
			// Read the "# of Logical Processors per Physical Processor" field:
			mov		eax, ebx
			and		eax, 0x00FF0000 // Mask the "logical core counter" byte
			shr		eax, 16 // Shift byte to be least-significant
			mov		coreCount, eax
			// Uniprocessor (i.e. Pentium III or any AMD CPU excluding their new dual-core A64)
		Unp:
		// coreCount will contain 1.
	}
	return coreCount;
}