﻿<?php
session_name('mojasession');
session_start();

if ($_SERVER["HTTPS"] != "on") {
    presmeruj_na_stranku("https://" . $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI']);    
}

if (!check_user()) 
    zmaz_session();
if (!check_admin())
    unset($_SESSION['admin']);
if (!check_superadmin())
    unset($_SESSION['superadmin']);

define("AUTOR", "Marián Kovanič");   
define("WEB", "filmovyportal.info");     
define("ZLE_USERNAME", "Zle zadané alebo nezadané prihlasovacie meno.");
define("USERNAME_EXISTUJE", "Takéto prihlasovacie meno už existuje. Zvoľte si prosím iné.");
define("ZLE_HESLO", "Zle zadané alebo nezadané heslo.");
define("ZLE_2_HESLO", "Zle zadané alebo nezadané potvrdzovacie heslo.");
define("HESLO_NEROVNAKE", "Heslo sa nezhoduje s potvrdzovacím heslom.");
define("HESLO_NEZMENENE", "Nové heslo sa zhoduje s pôvodným heslom. Zadajte iné nové heslo.");
define("NESUHLASIL_PODMIENKY", "Pre úspešnú registráciu je potrebné súhlasiť s podmienkami používania portálu.");
define("ZLE_MENO", "Zle zadané meno.");
define("ZLE_PRIEZVISKO", "Zle zadané priezvisko.");
define("ZLE_POHLAVIE", "Nezadali ste pohlavie.");
define("ZLE_MAIL", "Zle zadaný alebo nezadaný E-Mail.");
define("MAIL_UZ_EXISTUJE", "Takýto e-mail už existuje.");
define("ZLE_KRAJ", "Zle zadaný alebo nezadaný kraj.");
define("ZLE_ZAMESTNANIE", "Zle zadané zamestnanie.");
define("ZLE_TELEFON", "Zle zadaný telefón.");
define("ZLE_DATUM_NARODENIA", "Zle zadaný dátum narodenia.");
define("ZLE_OBL_FILM", "Zle zadaný obľúbený film.");
define("ZLE_OBL_HEREC", "Zle zadaný obľúbený herec.");
define("ZLE_OBL_ZANER", "Zle zadaný obľúbený filmový žáner.");
define("ZLE_ZALUBY", "Zle zadané záľuby.");
define("ZLE_POV_HESLO", "Zle zadané alebo nezadané pôvodné heslo.");
define("MIN_HESLO", 6);
define("MAX_HESLO", 20);
define("MIN_TEXT", 2);
define("MAX_TEXT", 50);
define("MAX_BIGTEXT", 225);
define("MAX_HUGETEXT", 5000);
define("INPUT_TEXT", 20);
define("MIN_MAIL", 5);
define("MAX_ZANROV", 8);
define("MAX_NATACANI", 5);
define("MAX_REZISEROV", 5);
define("MAX_HERCOV", 30);
define("MIN_ROK", 1900);
define("MAX_ROK", 2300);
define("MAX_SKUPIN", 20);
define("MAX_POUZIVATELOV_V_SKUPINE", 300);
define("NENI_PRISTUP", "<p>Nemáte prístup na túto stránku.</p>");
define("ZLE_ORIGINAL_NAME", "Zle zadaný alebo nezadaný originálny názov filmu.");
define("ORIGINAL_NAME_UZ_EXISTUJE_U_VAS", "Názov filmu s vami zadaným rokom vydania už existuje vo vašej databáze, nie je možné ho znova pridať.");
define("ZLE_CS_NAME", "Zle zadaný alebo nezadaný český / slovenský názov filmu.");
define("ZLE_ZANER", "Zle zadaný aspoň jeden alebo nezadaný žiadny žáner.");
define("ZLE_NATACANIE", "Zle zadané aspoň jedno alebo nezadané žiadne miesto natáčania.");
define("ZLE_REZISER", "Zle zadaný aspoň jeden alebo nezadaný žiadny režisér.");
define("ZLE_HEREC", "Zle zadaný aspoň jeden alebo nezadaný žiadny herec.");
define("ZLE_OBSAH", "Zle zadaný alebo nezadaný obsah filmu.");
define("ZLE_MEDIUM", "Zle zadané médium filmu.");
define("ZLE_ROZLISENIE", "Zle zadané rozlíšenie filmu.");
define("ZLE_ZVUK", "Zle zadaný jazyk filmu.");
define("ZLE_TITULKY", "Zle zadaný jazyk tituliek filmu.");
define("ZLE_UMIESTNENIE", "Zle zadané alebo nezadané umiestnenie filmu.");
define("ZLE_KOMENTAR", "Zle zadaný komentár filmu.");
define("ZLE_POZNAMKY", "Zle zadané poznámky k filmu.");
define("ZLE_VELKOST", "Zle zadaná veľkosť filmu.");
define("ZLE_UPRAVA_MOZNOSTI", "Zle zadaná aspoň jedna alebo nezadaná žiadna existujúca položka výberových možností.");
define("ZLE_PRIDANIE_MOZNOSTI", "Zle zadaná alebo nezadaná nová položka výberových možností.");
define("ZLE_MENO_SKUPINY", "Zle zadané meno skupiny.");
define("EXISTUJE_MENO_SKUPINY", "Takýto názov skupiny už existuje.");
define("ZLE_KONTAKT", "Zle zadaný kontakt.");
define("ZLE_ROK_VYDANIA", "Zle zadaný alebo nezadaný rok vydania filmu.");

/***************************************
 **            PRACA S DB             ******************************************************************************************************************************************************************
 ***************************************/

function spoj_s_db() {
    if ($link = mysql_connect('localhost', '**USER**', '**HESLO**')) {
        if (mysql_select_db('**DATABAZA**', $link)) {
            mysql_query("SET CHARACTER SET 'utf8'", $link);
            return $link;
        } else {
            // Nepodarilo sa vybrať databázu
            return false;
        }
    } else {
        // Nepodarilo sa spojiť s databázovým serverom
        return false;
    }
}

function daj_udaje_z_db($sql) {
    if ($link = spoj_s_db()) {
        $result = mysql_query($sql, $link); // vykonaj dotaz
        if ($result) {
            // dotaz sa podarilo vykonať
            if (mysql_num_rows($result) == 1)
                return mysql_fetch_assoc($result);
            else
                return false;
        } else {
            // dotaz sa NEpodarilo vykonať!
            return false;
        }
    } else {
        // NEpodarilo sa spojiť s databázovým serverom!
        return false;
    }
}

function sprav_dotaz($sql) {
    if ($link = spoj_s_db()) {
        $result = mysql_query($sql, $link); // vykonaj dotaz
        if ($result) {
            // dotaz sa podarilo vykonať
            return true;
        } else {
            // dotaz sa NEpodarilo vykonať!
            return false;
        }
    } else {
        // NEpodarilo sa spojiť s databázovým serverom!
        return false;
    }
}

/***************************************
 **         SABLONA STRANKY           ******************************************************************************************************************************************************************
 ***************************************/

function Titulok($tit) {
    ?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
    <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
            <title><?php echo $tit; ?></title>
            <link href="styl.css" rel="stylesheet" type="text/css" media="screen" title="Základný štýl" />
            <script type="text/javascript" src="skripty.js"> </script>
            <script type="text/javascript" src="CriosSpinEdit.js"></script>
            <script type="text/javascript" src="jquery-1.7.1.min.js"></script><?php
}

function Koniec_head() {
    ?></head><body><?php
}

function Hlavicka() {
    ?><div id="hlavicka" style="cursor: pointer" onclick="javascript:window.location.href = 'http://filmovyportal.tk'"></div>
            <div id="prihlasovanie"><?php
            if (isset($_POST['login']) && isset($_POST['heslo']) && isset($_POST['prihlasit_sa']) && spravny_pouzivatel()) {
                $row = daj_udaje_z_db("SELECT * FROM users WHERE LOWER(username)='" . strtolower($_POST['login']) . "'");
                vytvor_session($row['id'], $row['username'], $row['admin'], $row['superadmin']);
                presmeruj_na_stranku('index.php');
            } elseif (isset($_POST['odhlasit_sa'])) {
                zmaz_session();
                presmeruj_na_stranku('index.php');
            }
            if (isset($_SESSION['user'])) {
                zac_form(0, '', 0);
        ?><a href="profil.php?id=<?php echo $_SESSION['id']; ?>" title="Prejsť na svoj profil"> :: <?php echo $_SESSION['user']; ?> :: </a>
                    <button name="odhlasit_sa" value="odhlasit_sa" type="submit">Odhlásiť sa</button>&nbsp;             
                    </form></div><?php
        } else {
            zac_form(0, '', 0);
            echo label('login', 'Login: ');
            echo input('text', 'login', 10, MAX_TEXT, '');
        ?>&nbsp;&nbsp;<?php
            echo label('heslo', 'Heslo: ');
            echo input('password', 'heslo', 10, MAX_HESLO, '');
        ?>&nbsp;&nbsp;<button name="prihlasit_sa" value="prihlasit_sa" type="submit">Prihlásiť sa</button>
                &nbsp;<a href="reg.php" title="Registrácia je bezplatná">Registrácia</a>&nbsp;</form></div><?php
    }
}

function Paticka() {
    ?><div id="paticka">Vytvoril <a href="index.php" title="Autor"><?php echo AUTOR; ?></a> &copy; 2010-2012. Autor stránok nezodpovedá za dáta uložené používateľmi. Hosting - <a href="http://andrej.hrasko.eu" title="Hosting">hrasko.eu</a></div></body></html><?php
    }

    function Odkazy($aktivne) {    // 0 - mimo, 1 - home, 2 - filmy, 3 - rebricek, 4 - zoznam reg, 5 - about, 6 - admin                   
    ?><div id="odkazy">
        <a href="index.php" title="Návrat na hlavnú stránku" <?php if ($aktivne == 1) echo 'class="aktivne"'; ?> >Home</a><?php
        if (isset($_SESSION['user'])) {
        ?><a href="db.php" title="Vlastná databáza filmov" <?php if ($aktivne == 2) echo 'class="aktivne"'; ?> >Filmy</a><?php
    }
    if (isset($_SESSION['user'])) {
        ?><a href="rebricek.php" title="Rebríček najlepších a najhorších filmov" <?php if ($aktivne == 3) echo 'class="aktivne"'; ?> >Rebríček</a><?php
    }
    if (isset($_SESSION['user'])) {
        ?><a href="zozreg.php" title="Zoznam zaregistrovaných používateľov" <?php if ($aktivne == 4) echo 'class="aktivne"'; ?> >Používatelia</a><?php
    }
    ?><a href="about.php" title="O tejto stránke" <?php if ($aktivne == 5) echo 'class="aktivne"'; ?> >About</a><?php
    if (isset($_SESSION['admin']) || isset($_SESSION['superadmin'])) {
        ?><a href="admin.php" title="Administrátorské prostredie" <?php if ($aktivne == 6) echo 'class="aktivne"'; ?> >Admin</a><?php
    }
    ?></div><?php
}

function Lave_menu_db($only_view = false) {
    $uid = ($only_view) ? $_GET['id'] : $_SESSION['id'];
    $row = daj_udaje_z_db("SELECT COUNT(minutaz) AS pocet, SUM(minutaz) AS trvanie FROM film_private, film_public WHERE id_user=" . $uid . " AND film_private.id_film=film_public.id");
    $row2 = daj_udaje_z_db("SELECT * FROM users WHERE id=" . $_GET['id']);
    $filmov = $row['pocet'];
    ?><div id="lmenu">
        <h2><?php echo ($only_view) ? $row2['username'] . "'s" : 'Moja'; ?> databáza</h2>
        <p><?php
    if ($filmov == 1)
        echo '1 film';
    else if ($filmov == 2 || $filmov == 3 || $filmov == 4)
        echo $filmov . ' filmy';
    else
        echo $filmov . ' filmov';
    ?></p><p><?php echo vypis_cas($row['trvanie']); ?> 
        </p>
        <h2>Zobraziť ako</h2>                 
        <p><a href="javascript:" title="Zobraz ako tabuľku" id="variant1">Tabuľku</a></p>
        <p><a href="javascript:" title="Zobraz ako miniatúry s názvami filmov" id="variant2">Miniatúry</a></p><?php
        if (!$only_view) {
            ?>
            <h2>Filtrovanie</h2>
            <script type="text/javascript">  
                var spin_vydanie_od = new CriosSpinEdit('s10');
                var spin_vydanie_do = new CriosSpinEdit('s20');  
                var spin_hodnotenie_od = new CriosSpinEdit('s30'); 
                var spin_hodnotenie_do = new CriosSpinEdit('s40'); 
                var spin_vlastne_hodnotenie_od = new CriosSpinEdit('s50');  
                var spin_vlastne_hodnotenie_do = new CriosSpinEdit('s60');  
                spin_vydanie_od.MinValue = 1900;
                spin_vydanie_od.MaxValue = 2299;
                spin_vydanie_od.DefaultValue = <?php echo $_SESSION['db_vydanie_od']; ?>;
                spin_vydanie_do.MinValue = 1901;
                spin_vydanie_do.MaxValue = 2300;
                spin_vydanie_do.DefaultValue = <?php echo $_SESSION['db_vydanie_do']; ?>;
                spin_hodnotenie_od.MinValue = 0;
                spin_hodnotenie_od.MaxValue = 100;
                spin_hodnotenie_od.DefaultValue = <?php echo $_SESSION['db_hodnotenie_od']; ?>;            
                spin_hodnotenie_do.MinValue = 0;
                spin_hodnotenie_do.MaxValue = 100;
                spin_hodnotenie_do.DefaultValue = <?php echo $_SESSION['db_hodnotenie_do']; ?>;
                spin_vlastne_hodnotenie_od.MinValue = 0;
                spin_vlastne_hodnotenie_od.MaxValue = 100;
                spin_vlastne_hodnotenie_od.DefaultValue = <?php echo $_SESSION['db_vlastne_hodnotenie_od']; ?>;
                spin_vlastne_hodnotenie_do.MinValue = 0;
                spin_vlastne_hodnotenie_do.MaxValue = 100;
                spin_vlastne_hodnotenie_do.DefaultValue = <?php echo $_SESSION['db_vlastne_hodnotenie_do']; ?>;
            </script>
            <div id="filtrovanie">
            <p><table><tr><td><?php
            echo label('original_name" class="zvyraznene', 'Orig. názov') . '</td><td>';
            echo input('text', 'original_name', INPUT_TEXT - 4, MAX_TEXT, $_SESSION['db_original_name']);
            ?></td></tr></table></p>
            <p><table><tr><td><?php
            echo label('cs_name" class="zvyraznene', 'SK/CZ náz.') . '</td><td>';
            echo input('text', 'cs_name', INPUT_TEXT - 4, MAX_TEXT, $_SESSION['db_cs_name']);
            ?></td></tr></table></p>
            <p class="zvyraznene">Rok vydania</p><p>
                <table><tr>
                    <td>od </td>
                    <td><script type="text/javascript"> spin_vydanie_od.WriteControl('spin_vydanie_od'); </script></td>
                    <td>do </td>
                    <td><script type="text/javascript"> spin_vydanie_do.WriteControl('spin_vydanie_do'); </script></td>
                </tr></table>
            </p><p class="zvyraznene">Oficiálne hodnotenie</p><p>
                <table><tr>
                    <td>od </td>
                    <td><script type="text/javascript"> spin_hodnotenie_od.WriteControl('spin_hodnotenie_od'); </script></td>
                    <td>do </td>
                    <td><script type="text/javascript"> spin_hodnotenie_do.WriteControl('spin_hodnotenie_do'); </script></td>
                </tr></table>
            </p><p class="zvyraznene">Hodnotenie používateľov</p><p>
                <table><tr>
                    <td>od </td>
                    <td><script type="text/javascript"> spin_vlastne_hodnotenie_od.WriteControl('spin_vlastne_hodnotenie_od'); </script></td>
                    <td>do </td>
                    <td><script type="text/javascript"> spin_vlastne_hodnotenie_do.WriteControl('spin_vlastne_hodnotenie_do'); </script></td>
                </tr></table>
            </p><p><table><tr><td><?php
            echo label('zaner" class="zvyraznene', 'Žáner') . '</td><td>';
            echo select('zanre', 'zaner', $_SESSION['db_zaner'] , '');        
            ?></td></tr></table></p>
            <p><table><tr><td><?php
            echo label('natacanie" class="zvyraznene', 'Miesto nat.') . '</td><td>';
            echo input('text', 'natacanie', INPUT_TEXT - 4, MAX_TEXT, $_SESSION['db_natacanie']);
            ?></td></tr></table></p>
            <p><table><tr><td><?php
            echo label('reziser" class="zvyraznene', 'Režisér') . '</td><td>';
            echo input('text', 'reziser', INPUT_TEXT - 2, MAX_TEXT, $_SESSION['db_reziser']);
            ?></td></tr></table></p>
            <p><table><tr><td><?php
            echo label('herec" class="zvyraznene', 'Herec') . '</td><td>';
            echo input('text', 'herec', INPUT_TEXT - 2, MAX_TEXT, $_SESSION['db_herec']);
            ?></td></tr></table></p>
            </div>
            <h2>Pridať nový film</h2><?php
            if (isset($_POST["goto_pridaj_film"])) {
                if ((isset($_POST['orig_name']) && spravny_text('orig_name', MIN_TEXT, MAX_TEXT))
                        && isset($_POST['rok_vydania']) && ($_POST['rok_vydania'] >= MIN_ROK) && ($_POST['rok_vydania'] <= MAX_ROK)
                        && isset($_POST["pocet_zanrov"]) && isset($_POST["pocet_natacani"]) && isset($_POST["pocet_reziserov"]) && isset($_POST["pocet_hercov"])
                        && is_numeric($_POST["pocet_zanrov"]) && is_numeric($_POST["pocet_natacani"]) && is_numeric($_POST["pocet_reziserov"]) && is_numeric($_POST["pocet_hercov"])
                        && ($_POST["pocet_zanrov"] >= 0) && ($_POST["pocet_natacani"] >= 0) && ($_POST["pocet_reziserov"] >= 0) && ($_POST["pocet_hercov"] >= 0)
                        && ($_POST["pocet_zanrov"] <= MAX_ZANROV) && ($_POST["pocet_natacani"] <= MAX_NATACANI) && ($_POST["pocet_reziserov"] <= MAX_REZISEROV) && ($_POST["pocet_hercov"] <= MAX_HERCOV)
                        && (!(film_uz_existuje_u_vas($_POST['orig_name'], $_POST['rok_vydania'])))) {
                    if (film_uz_existuje_v_db($_POST['orig_name'], $_POST['rok_vydania'])) {
                        $row = daj_udaje_z_db("SELECT * FROM film_public WHERE LOWER(original_name)='" . strtolower($_POST["orig_name"]) . "' AND vydanie=" . $_POST['rok_vydania']);
                        $_SESSION["original_name"] = $row["original_name"];
                        $_SESSION['rok_vydania'] = $row['vydanie'];
                        presmeruj_na_stranku('pridaj_film2.php?id=' . $row["id"]);
                    } else {
                        $_SESSION["original_name"] = $_POST["orig_name"];
                        $_SESSION['rok_vydania'] = $_POST['rok_vydania'];
                        $_SESSION["zan"] = $_POST["pocet_zanrov"];
                        $_SESSION["nat"] = $_POST["pocet_natacani"];
                        $_SESSION["rez"] = $_POST["pocet_reziserov"];
                        $_SESSION["her"] = $_POST["pocet_hercov"];
                        presmeruj_na_stranku('pridaj_film.php');
                    }
                } else
                    vypis_form_pred_film((!(isset($_POST['orig_name']) && spravny_text('orig_name', MIN_TEXT, MAX_TEXT))), (film_uz_existuje_u_vas($_POST['orig_name'], $_POST['rok_vydania'])), 'goto_pridaj_film', 'Prejsť na pridanie filmu');
            } else
                vypis_form_pred_film(0, 0, 'goto_pridaj_film', 'Prejsť na pridanie filmu');
            ?><h2>Autopridanie</h2>
            <p><?php
            echo button('goto_autopridanie', 'Prejdi na pridanie', '', 'onclick="javascript:window.location.href = \'autopridanie_filmu.php\'"');
            ?></p><?php
        }
        ?><p><img src="obrazky/kameraman.png" width="220" height="252" alt="kameraman" /></p>          
    </div><?php
}

function Lave_menu_admin() {
    ?><div id="lmenu">
        <h2>Administrácia používateľov</h2>
        <p><a href="javascript:" title="Administrácia potvrdených registrovaných používateľov" id="v1" class="users">Potvrdený registrovaný používatelia</a></p>
        <p><a href="javascript:" title="Administrácia nepotvrdených registrovaných používateľov" id="v2" class="users">Nepotvrdený registrovaný používatelia</a></p>
        <h2>Administrácia filmov</h2>
        <p><a href="javascript:" title="Administrácia filmov" id="v4" class="film">Filmy</a></p>    
        <p><a href="javascript:" title="Administrácia požiadaviek" id="v5" class="film">Požiadavky</a></p>    
        <?php
    if (isset($_SESSION['superadmin'])) {
        ?><h2>Administrácia výberových možností</h2> 
            <p><a href="javascript:" title="Administrácia výberových možností - Kraje" id="kraje" class="vyber">Kraje</a></p>    
            <p><a href="javascript:" title="Administrácia výberových možností - Média" id="media" class="vyber">Média</a></p>  
            <p><a href="javascript:" title="Administrácia výberových možností - Rozlíšenia" id="rozlisenia" class="vyber">Rozlíšenia</a></p>
            <p><a href="javascript:" title="Administrácia výberových možností - Titulky" id="titulky" class="vyber">Titulky</a></p>
            <p><a href="javascript:" title="Administrácia výberových možností - Veľkosti" id="velkosti" class="vyber">Veľkosti</a></p>
            <p><a href="javascript:" title="Administrácia výberových možností - Zvuky" id="zvuky" class="vyber">Zvuky</a></p> 
            <p><a href="javascript:" title="Administrácia výberových možností - Žánre" id="zanre" class="vyber">Žánre</a></p><?php
    }
    ?> </div> <?php
}

function Lave_menu_rebricek() {
    ?><div id="lmenu">        
        <h2>Filtrovanie</h2>        
        <script type="text/javascript">  
            var spin_vydanie_od = new CriosSpinEdit('s100');
            var spin_vydanie_do = new CriosSpinEdit('s200');  
            var spin_hodnotenie_od = new CriosSpinEdit('s300'); 
            var spin_hodnotenie_do = new CriosSpinEdit('s400'); 
            var spin_vlastne_hodnotenie_od = new CriosSpinEdit('s500');  
            var spin_vlastne_hodnotenie_do = new CriosSpinEdit('s600');  
            spin_vydanie_od.MinValue = 1900;
            spin_vydanie_od.MaxValue = 2299;
            spin_vydanie_od.DefaultValue = <?php echo $_SESSION['reb_vydanie_od']; ?>;
            spin_vydanie_do.MinValue = 1901;
            spin_vydanie_do.MaxValue = 2300;
            spin_vydanie_do.DefaultValue = <?php echo $_SESSION['reb_vydanie_do']; ?>;
            spin_hodnotenie_od.MinValue = 0;
            spin_hodnotenie_od.MaxValue = 100;
            spin_hodnotenie_od.DefaultValue = <?php echo $_SESSION['reb_hodnotenie_od']; ?>;            
            spin_hodnotenie_do.MinValue = 0;
            spin_hodnotenie_do.MaxValue = 100;
            spin_hodnotenie_do.DefaultValue = <?php echo $_SESSION['reb_hodnotenie_do']; ?>;
            spin_vlastne_hodnotenie_od.MinValue = 0;
            spin_vlastne_hodnotenie_od.MaxValue = 100;
            spin_vlastne_hodnotenie_od.DefaultValue = <?php echo $_SESSION['reb_vlastne_hodnotenie_od']; ?>;
            spin_vlastne_hodnotenie_do.MinValue = 0;
            spin_vlastne_hodnotenie_do.MaxValue = 100;
            spin_vlastne_hodnotenie_do.DefaultValue = <?php echo $_SESSION['reb_vlastne_hodnotenie_do']; ?>;
        </script>
        <div id="filtrovanie">
        <p><table><tr><td><?php
        echo label('original_name" class="zvyraznene', 'Orig. názov') . '</td><td>';
        echo input('text', 'original_name', INPUT_TEXT - 4, MAX_TEXT, $_SESSION['db_original_name']);
        ?></td></tr></table></p>
        <p><table><tr><td><?php
        echo label('cs_name" class="zvyraznene', 'SK/CZ náz.') . '</td><td>';
        echo input('text', 'cs_name', INPUT_TEXT - 4, MAX_TEXT, $_SESSION['db_cs_name']);
        ?></td></tr></table></p>
        <p class="zvyraznene">Rok vydania</p><p>
            <table><tr>
                <td>od </td>
                <td><script type="text/javascript"> spin_vydanie_od.WriteControl('spin_vydanie_od'); </script></td>
                <td>do </td>
                <td><script type="text/javascript"> spin_vydanie_do.WriteControl('spin_vydanie_do'); </script></td>
            </tr></table>
        </p><p class="zvyraznene">Oficiálne hodnotenie</p><p>
            <table><tr>
                <td>od </td>
                <td><script type="text/javascript"> spin_hodnotenie_od.WriteControl('spin_hodnotenie_od'); </script></td>
                <td>do </td>
                <td><script type="text/javascript"> spin_hodnotenie_do.WriteControl('spin_hodnotenie_do'); </script></td>
            </tr></table>
        </p><p class="zvyraznene">Hodnotenie používateľov</p><p>
            <table><tr>
                <td>od </td>
                <td><script type="text/javascript"> spin_vlastne_hodnotenie_od.WriteControl('spin_vlastne_hodnotenie_od'); </script></td>
                <td>do </td>
                <td><script type="text/javascript"> spin_vlastne_hodnotenie_do.WriteControl('spin_vlastne_hodnotenie_do'); </script></td>
            </tr></table>
        </p><p><table><tr><td><?php
        echo label('zaner" class="zvyraznene', 'Žáner') . '</td><td>';
        echo select('zanre', 'zaner', $_SESSION['reb_zaner'] , '');        
        ?></td></tr></table></p>
        <p><table><tr><td><?php
        echo label('natacanie" class="zvyraznene', 'Miesto nat.') . '</td><td>';
        echo input('text', 'natacanie', INPUT_TEXT - 4, MAX_TEXT, $_SESSION['reb_natacanie']);
        ?></td></tr></table></p>
        <p><table><tr><td><?php
        echo label('reziser" class="zvyraznene', 'Režisér') . '</td><td>';
        echo input('text', 'reziser', INPUT_TEXT - 2, MAX_TEXT, $_SESSION['reb_reziser']);
        ?></td></tr></table></p>
        <p><table><tr><td><?php
        echo label('herec" class="zvyraznene', 'Herec') . '</td><td>';
        echo input('text', 'herec', INPUT_TEXT - 2, MAX_TEXT, $_SESSION['reb_herec']);
        ?></td></tr></table></p>
        </div>
    </div><?php
}

/***************************************
 **        PRACA SO SESSIONS          ******************************************************************************************************************************************************************
 ***************************************/

function vytvor_session($id, $username, $admin, $superAdmin) {
    $_SESSION['user'] = $username;
    $_SESSION['id'] = $id;
    if ($admin == 1)
        $_SESSION['admin'] = 1;
    if ($superAdmin == 1)
        $_SESSION['superadmin'] = 1;
    $_SESSION['db_variant'] = 1;
    $_SESSION['db_pocet_strana'] = 10;       
    $_SESSION['db_strana'] = 0;
    $_SESSION['db_order_by'] = 'original_name';
    $_SESSION['db_order_how'] = 'ASC';
    $_SESSION['db_zaner'] = '';
    $_SESSION['db_reziser'] = '';
    $_SESSION['db_herec'] = '';
    $_SESSION['db_natacanie'] = '';
    $_SESSION['db_original_name'] = '';
    $_SESSION['db_cs_name'] = '';
    $_SESSION['db_vydanie_od'] = 1900;
    $_SESSION['db_vydanie_do'] = date("Y");
    $_SESSION['db_hodnotenie_od'] = 0;
    $_SESSION['db_hodnotenie_do'] = 100;
    $_SESSION['db_vlastne_hodnotenie_od'] = 0;
    $_SESSION['db_vlastne_hodnotenie_do'] = 100;
    $_SESSION['dbv_variant'] = 1;
    $_SESSION['dbv_pocet_strana'] = 10;       
    $_SESSION['dbv_strana'] = 0;
    $_SESSION['dbv_order_by'] = 'original_name';
    $_SESSION['dbv_order_how'] = 'ASC';
    $_SESSION['zr_pocet_strana'] = 10;
    $_SESSION['zr_strana'] = 0;
    $_SESSION['zr_order_by'] = 'username';
    $_SESSION['zr_order_how'] = 'ASC';
    $_SESSION['adm_variant'] = 1;
    $_SESSION['adm_vyber_moznost'] = '';
    $_SESSION['adm1_pocet_strana'] = 10;
    $_SESSION['adm1_strana'] = 0;
    $_SESSION['adm1_order_by'] = 'timestamp';
    $_SESSION['adm1_order_how'] = 'DESC';
    $_SESSION['adm2_pocet_strana'] = 10;
    $_SESSION['adm2_strana'] = 0;
    $_SESSION['adm2_order_by'] = 'timestamp';
    $_SESSION['adm2_order_how'] = 'DESC';
    $_SESSION['adm4_pocet_strana'] = 10;
    $_SESSION['adm4_strana'] = 0;
    $_SESSION['adm4_order_by'] = 'ts_zmena';
    $_SESSION['adm4_order_how'] = 'DESC';
    $_SESSION['adm5_pocet_strana'] = 10;
    $_SESSION['adm5_strana'] = 0;
    $_SESSION['adm5_order_by'] = 'timestamp';
    $_SESSION['adm5_order_how'] = 'DESC';
    $_SESSION['reb_pocet_strana'] = 10;
    $_SESSION['reb_strana'] = 0;
    $_SESSION['reb_order_by'] = 'hodnotenie';
    $_SESSION['reb_order_how'] = 'DESC';
    $_SESSION['reb_zaner'] = '';
    $_SESSION['reb_reziser'] = '';
    $_SESSION['reb_herec'] = '';
    $_SESSION['reb_natacanie'] = '';
    $_SESSION['reb_original_name'] = '';
    $_SESSION['reb_cs_name'] = '';
    $_SESSION['reb_vydanie_od'] = 1900;
    $_SESSION['reb_vydanie_do'] = date("Y");
    $_SESSION['reb_hodnotenie_od'] = 0;
    $_SESSION['reb_hodnotenie_do'] = 100;
    $_SESSION['reb_vlastne_hodnotenie_od'] = 0;
    $_SESSION['reb_vlastne_hodnotenie_do'] = 100;
    $_SESSION['sk_pocet_strana'] = 10;
    $_SESSION['sk_strana'] = 0;
    $_SESSION['sk_order_by'] = 'username';
    $_SESSION['sk_order_how'] = 'ASC';
    $_SESSION['sk2_pocet_strana'] = 10;
    $_SESSION['sk2_strana'] = 0;
    $_SESSION['sk2_order_by'] = 'original_name';
    $_SESSION['sk2_order_how'] = 'ASC';
    $_SESSION['rozbalene_profily'] = false;
    $_SESSION['rozbalene_filmy'] = false;
}

function zmaz_session() {
    unset($_SESSION['user']);
    unset($_SESSION['id']);
    if (isset($_SESSION['admin']))
        unset($_SESSION['admin']);
    if (isset($_SESSION['superadmin']))
        unset($_SESSION['superadmin']);    
    unset($_SESSION['db_pocet_strana']);
    unset($_SESSION['db_variant']);
    unset($_SESSION['db_strana']);
    unset($_SESSION['db_order_by']);
    unset($_SESSION['db_order_how']);
    unset($_SESSION['db_zaner']);
    unset($_SESSION['db_reziser']);
    unset($_SESSION['db_herec']);
    unset($_SESSION['db_natacanie']);
    unset($_SESSION['db_original_name']);
    unset($_SESSION['db_cs_name']);
    unset($_SESSION['db_vydanie_od']);
    unset($_SESSION['db_vydanie_do']);
    unset($_SESSION['db_hodnotenie_od']);
    unset($_SESSION['db_hodnotenie_do']);
    unset($_SESSION['db_vlastne_hodnotenie_od']);
    unset($_SESSION['db_vlastne_hodnotenie_do']);
    unset($_SESSION['dbv_pocet_strana']);
    unset($_SESSION['dbv_variant']);
    unset($_SESSION['dbv_strana']);
    unset($_SESSION['dbv_order_by']);
    unset($_SESSION['dbv_order_how']);
    unset($_SESSION['zr_pocet_strana']);
    unset($_SESSION['zr_strana']);
    unset($_SESSION['zr_order_by']);
    unset($_SESSION['zr_order_how']);
    unset($_SESSION['adm_variant']);
    unset($_SESSION['adm_vyber_moznost']);
    unset($_SESSION['adm1_pocet_strana']);    
    unset($_SESSION['adm1_strana']);
    unset($_SESSION['adm1_order_by']);
    unset($_SESSION['adm1_order_how']);
    unset($_SESSION['adm2_pocet_strana']);    
    unset($_SESSION['adm2_strana']);
    unset($_SESSION['adm2_order_by']);
    unset($_SESSION['adm2_order_how']);
    unset($_SESSION['adm4_pocet_strana']);    
    unset($_SESSION['adm4_strana']);
    unset($_SESSION['adm4_order_by']);
    unset($_SESSION['adm4_order_how']);
    unset($_SESSION['adm5_pocet_strana']);    
    unset($_SESSION['adm5_strana']);
    unset($_SESSION['adm5_order_by']);
    unset($_SESSION['adm5_order_how']);
    unset($_SESSION['reb_pocet_strana']);
    unset($_SESSION['reb_strana']);
    unset($_SESSION['reb_order_by']);
    unset($_SESSION['reb_order_how']);
    unset($_SESSION['reb_zaner']);
    unset($_SESSION['reb_reziser']);
    unset($_SESSION['reb_herec']);
    unset($_SESSION['reb_natacanie']);
    unset($_SESSION['reb_original_name']);
    unset($_SESSION['reb_cs_name']);
    unset($_SESSION['reb_vydanie_od']);
    unset($_SESSION['reb_vydanie_do']);
    unset($_SESSION['reb_hodnotenie_od']);
    unset($_SESSION['reb_hodnotenie_do']);
    unset($_SESSION['reb_vlastne_hodnotenie_od']);
    unset($_SESSION['reb_vlastne_hodnotenie_do']);
    unset($_SESSION['sk_pocet_strana']);
    unset($_SESSION['sk_strana']);
    unset($_SESSION['sk_order_by']);
    unset($_SESSION['sk_order_how']);
    unset($_SESSION['sk2_pocet_strana']);
    unset($_SESSION['sk2_strana']);
    unset($_SESSION['sk2_order_by']);
    unset($_SESSION['sk2_order_how']);
    unset($_SESSION['rozbalene_profily']);
    unset($_SESSION['rozbalene_filmy']);
}

function unset_pridaj_film() {
    if (isset($_SESSION["original_name"]))
        unset($_SESSION["original_name"]);
    if (isset($_SESSION["rok_vydania"]))
        unset($_SESSION["rok_vydania"]);
    if (isset($_SESSION["zan"]))
        unset($_SESSION["zan"]);
    if (isset($_SESSION["nat"]))
        unset($_SESSION["nat"]);
    if (isset($_SESSION["rez"]))
        unset($_SESSION["rez"]);
    if (isset($_SESSION["her"]))
        unset($_SESSION["her"]);
}

/***************************************
 **        FORMULAROVE PRVKY          ******************************************************************************************************************************************************************
 ***************************************/

function input($type, $id, $size, $maxlength, $value, $js = '') {
    return '<input type="'.$type.'" name="'.$id.'" id="'.$id.'" size="'.$size.'" maxlength="'.$maxlength.'" value="'.$value.'" '.$js.' />';
}

function label($id, $text) {
    return '<label for="'.$id.'">'.$text.'</label>';
}

function bunka_povinnosti_polozky($povinna) {
    if ($povinna)
        return '<td><span class="zvyraznene">*</span></td>';
    else
        return '<td></td>';
}

function button($name, $text, $style, $js, $in_p = true) {
    $zac = ($in_p) ? '<p>' : '';
    $kon = ($in_p) ? '</p>' : '';
    return $zac . '<button name="'.$name.'" value="'.$name.'" type="submit" '.$style.' '.$js.'>'.$text.'</button>' . $kon;
}

function radioButton($name, $id, $js, $checked) {
    return '<input type="radio" name="'.$name.'" id="'.$id.'" value="'.$id.'" '.$js.' '.$checked.' />';
}

function textarea($id, $cols, $rows, $value, $js) {    
    return '<textarea name="' . $id . '" cols="' . $cols . '" rows="' . $rows . '" id="' . $id . '" ' . $js . '>' . $value . '</textarea>';    
} 

function select($tabulka, $name, $post, $js) {
    $res = '<select name="'.$name.'" id="'.$name.'" '.$js.'>';
    if ($link = spoj_s_db()) {
        $sql = "SELECT * FROM " . $tabulka . " ORDER BY nazov ASC"; // definuj dotaz
        $result = mysql_query($sql, $link); // vykonaj dotaz
        if ($result) {            
            while ($row = mysql_fetch_assoc($result)) {
                $selected = ($row['nazov'] == $post) ? 'selected="selected"' : '';
                $res .= '<option value="' . $row['nazov'] . '" ' . $selected . '>' . $row['nazov'] . '</option>';
            }
            mysql_free_result($result);
        }
        mysql_close($link);
    }
    return $res . '</select>';
}

function zac_fieldset($legend) {
    ?><fieldset><legend><?php echo $legend; ?></legend><?php
}

function koniec_fieldset() {
    ?></fieldset><?php
}

function zac_form($co, $name, $files) {
    ?><form action="<?php
    echo ($co) ? $_SERVER['REQUEST_URI'] : $_SERVER['PHP_SELF'];
    ?>" method="post" <?php if ($files) { ?> enctype="multipart/form-data" <?php
    }
    echo ($name == '') ? '' : 'name="' . $name . '"';
    echo '>';
}

function koniec_form() {
    ?></form><?php
}

/***************************************
 **     PRISPOSOBENE FORM PRVKY       ******************************************************************************************************************************************************************
 ***************************************/

function img_check($id) {
    ?><img name="<?php echo $id . '_obr'; ?>" id="<?php echo $id . '_obr'; ?>" alt="<?php echo $id . ' check'; ?>" src="" title="" width="20" height="20" /><?php
}

function img_info($id, $title) {
    ?><img alt="<?php echo $id . ' info'; ?>" src="obrazky/info.png" title="<?php echo $title; ?>" width="20" height="20" /><?php
}

function vypis_zly_riadok($podmienka, $text, $colspan) {
    if ($podmienka) 
        echo '<tr><td colspan="'.$colspan.'" class="cervene">'.$text.'</td></tr>';
}

function vypis_riadok_navrhovane_data($text, $colspan) {    
    echo '<tr><td></td><td></td><td colspan="'.$colspan.'" style="color: grey">'.$text.'</td></tr>';
}

function vypis_zly_riadok_s_ajax($podmienka, $text, $colspan, $id) {
    if ($podmienka)
        echo '<tr><td id="'.$id.'" colspan="'.$colspan.'" class="cervene">'.$text.'</td></tr>'; 
    else 
        echo '<tr><td id="'.$id.'" colspan="'.$colspan.'" class="cervene"></td></tr>';
}

function vypis_riadok_tabulky($id, $label_text, $info_title, $komponent0, $komponent1, $komponent2, $komponent3, $label_prvy = true) {
    ?><tr><?php
    echo ($label_text != '') ? $komponent0 : '<td></td>';    
    if ($label_prvy) {
        ?><td><?php
        echo ($label_text != '') ? label($id, $label_text) : $komponent0;
        ?></td><td><?php
        echo $komponent1;
    }
    else {
        ?><td colspan="2"><?php
        echo $komponent1;
        echo label($id, $label_text);    
        echo $komponent2;
    }
    ?></td><td><?php
    img_check($id);
    ?></td><td><?php
    img_info($id, $info_title);
    echo $komponent3;
    ?></td></tr><?php
}

function vypis_riadok_tabulky_dvojity($id1, $label_text1, $komponent1, $id2, $label_text2, $komponent2) {
    ?><tr><td></td><?php
    ?><td colspan="2"><?php
    echo $komponent1;
    echo '  ' . label($id1, $label_text1);    
    ?></td><td></td><?php
    ?><td colspan="2"><?php
    echo $komponent2;
    echo '  ' . label($id2, $label_text2);    
    ?></td></tr><?php
}

function vypis_riadok_tabulky_stvority($id1, $label_text1, $komponent1, $id2, $label_text2, $komponent2, $id3, $label_text3, $komponent3, $id4, $label_text4, $komponent4) {
    ?><tr><td></td><?php
    ?><td colspan="2"><?php
    echo $komponent1;
    echo '  ' . label($id1, $label_text1);    
    ?></td><td></td><?php
    ?><td colspan="2"><?php
    echo $komponent2;
    echo '  ' . label($id2, $label_text2);    
    ?></td><td></td><?php
    ?><td colspan="2"><?php
    echo $komponent3;
    echo '  ' . label($id3, $label_text3);    
    ?></td><td></td><?php
    ?><td colspan="2"><?php
    echo $komponent4;
    echo '  ' . label($id4, $label_text4);    
    ?></td></tr><?php
}

function vypis_viachodnotovy_riadok_tabulky($nazov, $id, $session, $id_diakritika, $max, $info_title, $form_name, $hodnota_z_db, $select_tabulka = '') {
    if ($hodnota_z_db != '') {
        $hodnota = explode("@", $hodnota_z_db);
    }
    ?><tr><?php
    echo bunka_povinnosti_polozky(true);
    ?><td><?php
    echo $nazov; 
    if ($hodnota_z_db == '') {
        if ($_SESSION[$session] < $max)
            echo '<a href="javascript:document.' . $form_name . '.pridaj_' . $id . '.click();" title="Pridaj 1 ' . $id_diakritika . '"><img width="15" height="15" src="obrazky/plus.png" alt="pridať" /></a>';
        if ($_SESSION[$session] > 1)
            echo '<a href="javascript:document.' . $form_name . '.odober_' . $id . '.click();" title="Odober 1 ' . $id_diakritika . '"><img width="15" height="15" src="obrazky/minus.png" alt="odobrať" /></a>';
    }
    ?></td><?php
    $pom2 = ($_SESSION[$session] == 1) ? (($select_tabulka == '') ? 199 : 0) : 999;
    for ($i = 1; $i <= $_SESSION[$session]; $i++) {
        $pom = (isset($_POST[$id . $i])) ? $_POST[$id . $i] : (($hodnota_z_db != '') ? $hodnota[$i - 1] : '');
        ?><td><?php        
        if ($select_tabulka != '')
            echo select($select_tabulka, $id . $i, $pom, 'onchange="s(this.value, \'' . $id . $i . '_obr\', 9, 0, ' . $pom2 . ')"');
        else
            echo input('text', $id . $i, INPUT_TEXT, MAX_TEXT, $pom, 'onkeyup="s(this.value, \'' . $id . $i . '_obr\', ' . $pom2 . ', ' . MIN_TEXT . ', ' . MAX_TEXT . ')"');
        ?></td><td><?php
        img_check($id . $i);
        ?></td><?php
        if ($i % 3 == 0) {
            ?></tr><tr><td></td><td></td><?php
        }
    }
    ?><td><?php
    img_info($id, $info_title);
    ?></td></tr><?php
}

function vypis_vyber_dvoch_poloziek($radio_name, $prva_moznost, $druha_moznost, $pm_name, $dm_name, $tabulka, $form, $nazov, $jeSpin, $type, $spinWrite, $spinn, $db, $druhe, $hodnota) {        
    $pom2 = ((isset($_POST[$radio_name]) && $_POST[$radio_name] == $druha_moznost) || ($db && $druhe)) ? 'checked="checked"' : '';
    $pom1 = ((isset($_POST[$radio_name]) && $_POST[$radio_name] == $prva_moznost) || $pom2 == '') ? 'checked="checked"' : '';
    $pom = (isset($_POST[$pm_name])) ? $_POST[$pm_name] : (($db && !$druhe) ? $hodnota : '-');
    vypis_riadok_tabulky($pm_name, '', 'výber jednej z možností', 
            $nazov, 
            radioButton($radio_name, $prva_moznost, 'onclick="javascript:zmen_vyber(' . $jeSpin . ',document.forms[\'' . $form . '\'].' . $pm_name . ',' . $spinn . ',document.forms[\'' . $form . '\'].' . $radio_name . '[0],document.forms[\'' . $form . '\'].' . $radio_name . '[1],\'' . $pm_name . '_obr\',\'' . $dm_name . '_obr\')"', $pom1)
            . select($tabulka, $pm_name, $pom, 'onchange="javascript:s(document.forms[\'' . $form . '\'].' . $pm_name . '.value,\'' . $pm_name . '_obr\', 0, 0, 0)"'), 
            '', '');
    $info = ($jeSpin == 'true') ? '1 MB - 100 000 MB' : MIN_TEXT . ' - ' . MAX_TEXT . ' znakov';
    $pom = (isset($_POST[$dm_name])) ? $_POST[$dm_name] : (($db && $druhe) ? $hodnota : '');
    $js = ($jeSpin == 'true') ? '' : 'onkeyup="javascript:s(document.forms[\'' . $form . '\'].' . $dm_name . '.value,\'' . $dm_name . '_obr\',5,' . MIN_TEXT . ',' . MAX_TEXT . ')"';
    vypis_riadok_tabulky($dm_name, '', $info, '', 
            radioButton($radio_name, $druha_moznost, 'onclick="javascript:zmen_vyber(' . $jeSpin . ',document.forms[\'' . $form . '\'].' . $pm_name . ',' . $spinn . ',document.forms[\'' . $form . '\'].' . $radio_name . '[0],document.forms[\'' . $form . '\'].' . $radio_name . '[1],\'' . $pm_name . '_obr\',\'' . $dm_name . '_obr\')"', $pom2)
            . input($type, $dm_name, INPUT_TEXT, MAX_TEXT, $pom, $js) . $spinWrite, 
            '', '');
    ?> <script type="text/javascript">zmen_vyber(<?php echo $jeSpin; ?>,document.forms['<?php echo $form; ?>'].<?php echo $pm_name; ?>,<?php echo $spinn; ?>,document.forms['<?php echo $form; ?>'].<?php echo $radio_name; ?>[0],document.forms['<?php echo $form; ?>'].<?php echo $radio_name; ?>[1],'<?php echo $pm_name; ?>_obr','<?php echo $dm_name; ?>_obr'); </script> <?php
}
   
/***************************************
 **           FORM - USER             ******************************************************************************************************************************************************************
 ***************************************/

function vypis_form_user($username, $username_existuje, $heslo, $heslo_potvrdenie, $hesla_zhodne, $podmienky, $meno, $priezvisko, $pohlavie, $mail, $mail_existuje, $kraj, $zamestnanie, $telefon, $datum_narodenia, $obl_film, $obl_herec, $obl_zaner, $zaluby, $button_name, $button_text, $db) {
    zac_form($db, '', 0);
    if (!$db)
        prihlasovacie_udaje($username, $username_existuje, $heslo, $heslo_potvrdenie, $hesla_zhodne, $podmienky);
    osobne_udaje($meno, $priezvisko, $pohlavie, $mail, $mail_existuje, $kraj, $zamestnanie, $telefon, $datum_narodenia, $obl_film, $obl_herec, $obl_zaner, $zaluby, $db);
    ?><p class="zvyraznene">* - povinné položky</p><?php
    echo button($button_name, $button_text, '', '');
    koniec_form();
    if ($db)
        echo button('go_back', 'Naspäť na profil', '', 'onclick="javascript:window.location.href=\'profil.php?id=' . $_SESSION['id'] . '\'"');
}

function prihlasovacie_udaje($username, $username_existuje, $heslo, $heslo_potvrdenie, $hesla_zhodne, $podmienky) {
    zac_fieldset('Prihlasovacie údaje');
    ?><table><?php
    $pom = (isset($_POST["username"])) ? $_POST["username"] : "";
    vypis_riadok_tabulky('username', 'Username', MIN_TEXT . ' - ' . MAX_TEXT . ' znakov, prihlasovacie meno sa musí skladať iba z malých alebo veľkých písmen bez diakritiky alebo číslic!', 
            bunka_povinnosti_polozky(true), 
            input('text', 'username', INPUT_TEXT, MAX_TEXT, $pom, 'onkeyup="s(this.value, \'username_obr\', 11, ' . MIN_TEXT . ', ' . MAX_TEXT . ')"'), 
            '', '');    
    vypis_zly_riadok($username, ZLE_USERNAME, 5);
    vypis_zly_riadok_s_ajax($username_existuje, USERNAME_EXISTUJE, 5, 'username_existuje');
    vypis_riadok_tabulky('pass', 'Heslo', MIN_HESLO . ' - ' . MAX_HESLO . ' znakov', 
            bunka_povinnosti_polozky(true), 
            input('password', 'pass', MAX_HESLO, MAX_HESLO, '', 'onkeyup="s(this.value, \'pass_obr\', 1, ' . MIN_HESLO . ', ' . MAX_HESLO . ')"'), 
            '', '');    
    vypis_zly_riadok($heslo, ZLE_HESLO, 5);
    vypis_riadok_tabulky('pass2', 'Potvrdenie hesla', MIN_HESLO . ' - ' . MAX_HESLO . ' znakov', 
            bunka_povinnosti_polozky(true), 
            input('password', 'pass2', MAX_HESLO, MAX_HESLO, '', 'onkeyup="s(this.value, \'pass2_obr\', 1, ' . MIN_HESLO . ', ' . MAX_HESLO . ')"'), 
            '', '');    
    vypis_zly_riadok($heslo_potvrdenie, ZLE_2_HESLO, 5);
    vypis_zly_riadok($hesla_zhodne, HESLO_NEROVNAKE, 5);    
    vypis_riadok_tabulky('potvrdenie', 'Súhlasím s podmienkami používania filmového portálu', 'výber tejto možnosti je povinný', 
            bunka_povinnosti_polozky(true), 
            input('checkbox', 'potvrdenie', INPUT_TEXT, MAX_TEXT, '', 'onchange="s(this.checked, \'potvrdenie_obr\', 8, 0, 0)"'),
            '', '', false);        
    vypis_zly_riadok($podmienky, NESUHLASIL_PODMIENKY, 5);
    ?></table><?php
    koniec_fieldset();
}

function osobne_udaje($meno, $priezvisko, $pohlavie, $mail, $mail_existuje, $kraj, $zamestnanie, $telefon, $datum_narodenia, $obl_film, $obl_herec, $obl_zaner, $zaluby, $db) {
    if ($db)
        $row = daj_udaje_z_db("SELECT * FROM users WHERE id=" . $_SESSION['id']);
        zac_fieldset('Osobné údaje');
    ?><table><?php    
    $pom = (isset($_POST["meno"])) ? $_POST["meno"] : (($db) ? $row['meno'] : ''); // TAKTO SPRAVIT AJ OSATNE    
    vypis_riadok_tabulky('meno', 'Meno', MIN_TEXT . ' - ' . MAX_TEXT . ' znakov', 
            bunka_povinnosti_polozky(false), 
            input('text', 'meno', INPUT_TEXT, MAX_TEXT, $pom, 'onkeyup="s(this.value, \'meno_obr\', 5, ' . MIN_TEXT . ', ' . MAX_TEXT . ')"'), 
            '', '');    
    vypis_zly_riadok($meno, ZLE_MENO, 5);    
    $pom = (isset($_POST["priezvisko"])) ? $_POST["priezvisko"] : (($db) ? $row['priezvisko'] : '');    
    vypis_riadok_tabulky('priezvisko', 'Priezvisko', MIN_TEXT . ' - ' . MAX_TEXT . ' znakov', 
            bunka_povinnosti_polozky(false), 
            input('text', 'priezvisko', INPUT_TEXT, MAX_TEXT, $pom, 'onkeyup="s(this.value, \'priezvisko_obr\', 5, ' . MIN_TEXT . ', ' . MAX_TEXT . ')"'), 
            '', '');    
    vypis_zly_riadok($priezvisko, ZLE_PRIEZVISKO, 5);
    if (!$db) {        
        $pom1 = '';
        $pom2 = '';
        if ((isset($_POST['pohlavie'])) && ($_POST['pohlavie'] == 'muz'))
            $pom1 = 'checked="checked"';
        if ((isset($_POST['pohlavie'])) && ($_POST['pohlavie'] == 'zena'))
            $pom2 = 'checked="checked"';             
        vypis_riadok_tabulky('pohlavie', 'Pohlavie', 'výber jednej z možností je povinný', 
            bunka_povinnosti_polozky(true), 
            radioButton('pohlavie', 'muz', 'onclick="javascript:s(this.value, \'pohlavie_obr\', 8, 0, 0)"', $pom1) . label('muz', 'Muž') . 
            radioButton('pohlavie', 'zena', 'onclick="javascript:s(this.value, \'pohlavie_obr\', 8, 0, 0)"', $pom2) . label('zena', 'Žena'), 
            '', '');
        vypis_zly_riadok($pohlavie, ZLE_POHLAVIE, 5);
    }
    if (!$db) {
        $pom = (isset($_POST["mail"])) ? $_POST["mail"] : '';
        vypis_riadok_tabulky('mail', 'E-Mail', MIN_MAIL . ' - ' . MAX_TEXT . ' znakov, musí mať tvar xxx@zzz.yyy, napr. meno@gmail.com, váš e-mail nebude zverejnený! Pre funkčnosť na stránke a potvrdenie registrácie musíte zadať platný mail!', 
            bunka_povinnosti_polozky(true), 
            input('text', 'mail', INPUT_TEXT + 10, MAX_TEXT, $pom, 'onkeyup="s(this.value, \'mail_obr\', 2, ' . MIN_MAIL . ', ' . MAX_TEXT . ')"'), 
            '', '');
        vypis_zly_riadok($mail, ZLE_MAIL, 5);
        vypis_zly_riadok_s_ajax($mail_existuje, MAIL_UZ_EXISTUJE, 5, 'mail_existuje');
    }    
    $pom = (isset($_POST["kraj"])) ? $_POST["kraj"] : (($db) ? $row['kraj'] : '');    
    vypis_riadok_tabulky('kraj', 'Kraj', 'výber jednej z možností je povinný', 
            bunka_povinnosti_polozky(true), 
            select('kraje', 'kraj', $pom, "s(this.value, 'kraj_obr', 1, " . MIN_TEXT . ", " . MAX_TEXT . ")"), 
            '', '');
    vypis_zly_riadok($kraj, ZLE_KRAJ, 5);    
    $pom = (isset($_POST["zamestnanie"])) ? $_POST["zamestnanie"] : (($db) ? $row['zamestnanie'] : '');    
    vypis_riadok_tabulky('zamestnanie', 'Zamestnanie', MIN_TEXT . ' - ' . MAX_TEXT . ' znakov', 
            bunka_povinnosti_polozky(false), 
            input('text', 'zamestnanie', INPUT_TEXT, MAX_TEXT, $pom, 'onkeyup="s(this.value, \'zamestnanie_obr\', 5, ' . MIN_TEXT . ', ' . MAX_TEXT . ')"'), 
            '', '');
    vypis_zly_riadok($zamestnanie, ZLE_ZAMESTNANIE, 5);    
    $pom = (isset($_POST["telefon"])) ? $_POST["telefon"] : (($db) ? $row['telefon'] : '');    
    vypis_riadok_tabulky('telefon', 'Telefónne číslo', 'musí byť v tvare +yyyxxxxxxxxx, napr. +421905111222', 
            bunka_povinnosti_polozky(false), 
            input('text', 'telefon', INPUT_TEXT, MAX_TEXT, $pom, 'onkeyup="s(this.value, \'telefon_obr\', 3, 0, 0)"'), 
            '', '');
    vypis_zly_riadok($telefon, ZLE_TELEFON, 5);    
    $pom = (isset($_POST["datum_narodenia"])) ? $_POST["datum_narodenia"] : (($db) ? $row['datum_narodenia'] : '');    
    vypis_riadok_tabulky('datum_narodenia', 'Dátum narodenia', 'musí byť v tvare deň.mesiac.rok, napr. 1.12.1988, váš dátum narodenia nebude zverejnený, použije sa iba na výpočet vášho veku!', 
            bunka_povinnosti_polozky(false), 
            input('text', 'datum_narodenia', 10, 10, $pom, 'onkeyup="s(this.value, \'datum_narodenia_obr\', 4, 0, 0)"'), 
            '', '');
    vypis_zly_riadok($datum_narodenia, ZLE_DATUM_NARODENIA, 5);
    $pom = (isset($_POST["fav_film"])) ? $_POST["fav_film"] : (($db) ? $row['fav_film'] : '');    
    vypis_riadok_tabulky('fav_film', 'Obľúbený film', MIN_TEXT . ' - ' . MAX_TEXT . ' znakov', 
            bunka_povinnosti_polozky(false), 
            input('text', 'fav_film', INPUT_TEXT, MAX_TEXT, $pom, 'onkeyup="s(this.value, \'fav_film_obr\', 5, ' . MIN_TEXT . ', ' . MAX_TEXT . ')"'), 
            '', '');
    vypis_zly_riadok($obl_film, ZLE_OBL_FILM, 5);
    $pom = (isset($_POST["fav_actor"])) ? $_POST["fav_actor"] : (($db) ? $row['fav_actor'] : '');    
    vypis_riadok_tabulky('fav_actor', 'Obľúbený herec', MIN_TEXT . ' - ' . MAX_TEXT . ' znakov', 
            bunka_povinnosti_polozky(false), 
            input('text', 'fav_actor', INPUT_TEXT, MAX_TEXT, $pom, 'onkeyup="s(this.value, \'fav_actor_obr\', 5, ' . MIN_TEXT . ', ' . MAX_TEXT . ')"'), 
            '', '');
    vypis_zly_riadok($obl_herec, ZLE_OBL_HEREC, 5);
    $pom = (isset($_POST["fav_zaner"])) ? $_POST["fav_zaner"] : (($db) ? $row['fav_zaner'] : '');    
    vypis_riadok_tabulky('fav_zaner', 'Obľúbený žáner', MIN_TEXT . ' - ' . MAX_TEXT . ' znakov', 
            bunka_povinnosti_polozky(false), 
            input('text', 'fav_zaner', INPUT_TEXT, MAX_TEXT, $pom, 'onkeyup="s(this.value, \'fav_zaner_obr\', 5, ' . MIN_TEXT . ', ' . MAX_TEXT . ')"'), 
            '', '');
    vypis_zly_riadok($obl_zaner, ZLE_OBL_ZANER, 5);
    $pom = (isset($_POST['zaluby'])) ? $_POST['zaluby'] : (($db) ? $row['zaluby'] : '');    
    vypis_riadok_tabulky('zaluby', 'Záľuby', MIN_TEXT . ' - ' . MAX_BIGTEXT . ' znakov', 
            bunka_povinnosti_polozky(false), 
            input('text', 'zaluby', INPUT_TEXT, MAX_BIGTEXT, $pom, 'onkeyup="s(this.value, \'meno_obr\', 5, ' . MIN_TEXT . ', ' . MAX_BIGTEXT . ')"'), 
            '', '');
    vypis_zly_riadok($zaluby, ZLE_ZALUBY, 5);
    ?></table><?php
    koniec_fieldset();
}

function vypis_form_uprav_heslo($povodne_heslo, $nove_heslo, $nove_heslo_potvrdenie, $rozne_hesla, $nezmenene_heslo) {
    zac_form(1, '', 0);
    zac_fieldset('Zmena hesla');
    ?><table><?php
    vypis_riadok_tabulky('heslo', 'Pôvodné heslo', MIN_HESLO . ' - ' . MAX_HESLO . ' znakov', 
            bunka_povinnosti_polozky(true), 
            input('password', 'heslo', MAX_HESLO, MAX_HESLO, '', 'onkeyup="s(this.value, \'heslo_obr\', 1, ' . MIN_HESLO . ', ' . MAX_HESLO . ')"'), 
            '', '');    
    vypis_zly_riadok($povodne_heslo, ZLE_POV_HESLO, 5);
    vypis_riadok_tabulky('pass', 'Nové heslo', MIN_HESLO . ' - ' . MAX_HESLO . ' znakov', 
            bunka_povinnosti_polozky(true), 
            input('password', 'pass', MAX_HESLO, MAX_HESLO, '', 'onkeyup="s(this.value, \'pass_obr\', 1, ' . MIN_HESLO . ', ' . MAX_HESLO . ')"'), 
            '', '');    
    vypis_zly_riadok($nove_heslo, ZLE_HESLO, 5);
    vypis_riadok_tabulky('pass2', 'Potvrdenie nového hesla', MIN_HESLO . ' - ' . MAX_HESLO . ' znakov', 
            bunka_povinnosti_polozky(true), 
            input('password', 'pass2', MAX_HESLO, MAX_HESLO, '', 'onkeyup="s(this.value, \'pass2_obr\', 1, ' . MIN_HESLO . ', ' . MAX_HESLO . ')"'), 
            '', '');
    vypis_zly_riadok($nove_heslo_potvrdenie, ZLE_2_HESLO, 5);
    vypis_zly_riadok($rozne_hesla, HESLO_NEROVNAKE, 5);
    vypis_zly_riadok($nezmenene_heslo, HESLO_NEZMENENE, 5);
    ?></table><?php
    koniec_fieldset();
    ?><p class="zvyraznene">* - povinné položky</p><?php
    echo button('uprav_heslo', 'Zmeň heslo', '', '');
    koniec_form();
    echo button('go_back', 'Naspäť na profil', '', 'onclick="javascript:window.location.href=\'profil.php?id=' . $_SESSION['id'] . '\'"');
}

function vypis_form_uprav_mail($mail, $mail_existuje) {
    zac_form(1, '', 0);
    zac_fieldset('Zmena E-Mail-u');
    ?><table><?php
    $row = daj_udaje_z_db("SELECT * FROM users WHERE id=" . $_SESSION['id']);
    $pom = (isset($_POST["mail"])) ? $_POST["mail"] : $row['mail'];
    vypis_riadok_tabulky('mail', 'E-Mail', MIN_MAIL . ' - ' . MAX_TEXT . ' znakov, musí mať tvar xxx@zzz.yyy, napr. meno@gmail.com, váš e-mail nebude zverejnený! Pre funkčnosť na stránke a potvrdenie registrácie musíte zadať platný mail!', 
            bunka_povinnosti_polozky(true), 
            input('text', 'mail', INPUT_TEXT + 10, MAX_TEXT, $pom, 'onkeyup="s(this.value, \'mail_obr\', 2, ' . MIN_MAIL . ', ' . MAX_TEXT . ')"'), 
            '', '');
    vypis_zly_riadok($mail, ZLE_MAIL, 5);
    vypis_zly_riadok_s_ajax($mail_existuje, MAIL_UZ_EXISTUJE, 5, 'mail_existuje');
    ?></table><?php
    koniec_fieldset();
    ?><p class="zvyraznene">* - povinné položky</p><?php
    echo button('uprav_mail', 'Zmeň mail', '', '');
    koniec_form();
    echo button('go_back', 'Naspäť na profil', '', 'onclick="javascript:window.location.href=\'profil.php?id=' . $_SESSION['id'] . '\'"');
}

/***************************************
 **    FORM - PREDPRIDANIE FILMU      ******************************************************************************************************************************************************************
 ***************************************/

function vypis_form_pred_film($original_name, $original_name_existuje, $button_name, $button_text) {
    $pom0 = (isset($_POST["rok_vydania"])) ? $_POST["rok_vydania"] : date("Y");
    $pom1 = (isset($_POST["pocet_zanrov"])) ? $_POST["pocet_zanrov"] : 1;
    $pom2 = (isset($_POST["pocet_natacani"])) ? $_POST["pocet_natacani"] : 1;
    $pom3 = (isset($_POST["pocet_reziserov"])) ? $_POST["pocet_reziserov"] : 1;
    $pom4 = (isset($_POST["pocet_hercov"])) ? $_POST["pocet_hercov"] : 1;
    ?><script type="text/javascript">
            var spin_rok = new CriosSpinEdit('s0');
            var spin_rez = new CriosSpinEdit('s1');
            var spin_her = new CriosSpinEdit('s2');
            var spin_zan = new CriosSpinEdit('s3');
            var spin_nat = new CriosSpinEdit('s4');    		
            spin_rok.MinValue = <?php echo MIN_ROK; ?>;
            spin_rok.MaxValue = <?php echo MAX_ROK; ?>;
            spin_rok.DefaultValue = <?php echo $pom0; ?>;
            spin_rez.MinValue = 1;
            spin_rez.MaxValue = <?php echo MAX_REZISEROV; ?>;
            spin_rez.DefaultValue = <?php echo $pom3; ?>;  
            spin_her.MinValue = 1;
            spin_her.MaxValue = <?php echo MAX_HERCOV; ?>;
            spin_her.DefaultValue = <?php echo $pom4; ?>;	
            spin_zan.MinValue = 1;
            spin_zan.MaxValue = <?php echo MAX_ZANROV; ?>;
            spin_zan.DefaultValue = <?php echo $pom1; ?>;	
            spin_nat.MinValue = 1;
            spin_nat.MaxValue = <?php echo MAX_NATACANI; ?>;
            spin_nat.DefaultValue = <?php echo $pom2; ?>;
    </script><?php
    zac_form(1, 'form_pred_film', 0);
    ?><table><?php
    $pom = (isset($_POST["orig_name"])) ? $_POST["orig_name"] : '';
    vypis_riadok_tabulky('orig_name', '* Originálny názov', MIN_TEXT . ' - ' . MAX_TEXT . ' znakov', '', '', 
            '</td><td></td><td></td></tr><tr><td colspan="2">' . input('text', 'orig_name', INPUT_TEXT, MAX_TEXT, $pom, 'onkeyup="s(this.value,\'orig_name_obr\',1,' . MIN_TEXT . ',' . MAX_TEXT . ')"'),  
            '', false);
    vypis_zly_riadok($original_name, ZLE_ORIGINAL_NAME, 4);
    vypis_zly_riadok_s_ajax($original_name_existuje, ORIGINAL_NAME_UZ_EXISTUJE_U_VAS, 4, 'orig_name_existuje');
    vypis_riadok_tabulky('rok_vydania', 'Rok vydania', MIN_ROK . ' - ' . MAX_ROK, '', 
            '<script type="text/javascript"> spin_rok.WriteControl(\'spin_rok\'); </script>', '',  
            input('hidden', 'rok_vydania', 0, MAX_TEXT, $pom0));
    vypis_riadok_tabulky('pocet_zanrov', 'Žánrov', '1 - ' . MAX_ZANROV . ' žánrov', '', 
            '<script type="text/javascript"> spin_zan.WriteControl(\'spin_zan\'); </script>', '',  
            input('hidden', 'pocet_zanrov', 0, MAX_TEXT, $pom1));
    vypis_riadok_tabulky('pocet_natacani', 'Miest natáčaní', '1 - ' . MAX_NATACANI . ' miest natáčaní', '', 
            '<script type="text/javascript"> spin_nat.WriteControl(\'spin_nat\'); </script>', '',  
            input('hidden', 'pocet_natacani', 0, MAX_TEXT, $pom2));
    vypis_riadok_tabulky('pocet_reziserov', 'Režisérov', '1 - ' . MAX_REZISEROV . ' režisérov', '', 
            '<script type="text/javascript"> spin_rez.WriteControl(\'spin_rez\'); </script>', '', 
            input('hidden', 'pocet_reziserov', 0, MAX_TEXT, $pom3));
    vypis_riadok_tabulky('pocet_hercov', 'Hercov', '1 - ' . MAX_HERCOV . ' hercov', '', 
            '<script type="text/javascript"> spin_her.WriteControl(\'spin_her\'); </script>', '', 
            input('hidden', 'pocet_hercov', 0, MAX_TEXT, $pom4));
    ?></table><?php
    echo button($button_name, $button_text, '', 'onclick="javascript:predaj_hodnotu_zo_spinu(spin_rok,form_pred_film.rok_vydania);predaj_hodnotu_zo_spinu(spin_zan,form_pred_film.pocet_zanrov);predaj_hodnotu_zo_spinu(spin_nat,form_pred_film.pocet_natacani);predaj_hodnotu_zo_spinu(spin_rez,form_pred_film.pocet_reziserov);predaj_hodnotu_zo_spinu(spin_her,form_pred_film.pocet_hercov)"');
    ?><p><img src="obrazky/exclammark.png" alt="upozornenie" height="16" width="16" title="upozornenie" />&nbsp;&nbsp;Všetky položky sú povinné</p>
    <p><img src="obrazky/exclammark.png" alt="upozornenie" height="16" width="16" title="upozornenie" />&nbsp;&nbsp;Nastavenia sú len informatívne a je možné ich neskôr zmeniť (okrem originálneho názvu a roku vydania)</p></form><?php
}

function vypis_form_autofilm() {    
    zac_fieldset('Hľadanie fimu');
    ?><table><tr><?php
    echo '<td>' . label('ap_nazov', '* Originálny názov') . '</td>';
    echo '<td>' . input('text', 'ap_nazov', INPUT_TEXT, MAX_TEXT, '', '') . '</td><td></td>';
    echo '<td>' . label('ap_rok', 'Rok vydania') . '</td>';
    echo '<td>' . input('text', 'ap_rok', INPUT_TEXT, MAX_TEXT, '', '') . '</td><td></td>';
    echo '<td>' . button('nastav_autopridanie', 'Získaj data', '', 'onclick="daj_imdb_udaje()"') . '</td>';
    ?></tr></table><?php    
    koniec_fieldset();
}

/***************************************
 **           FORM - FILM             ******************************************************************************************************************************************************************
 ***************************************/

function vypis_form_film($cs_name, $zanre, $natacania, $reziseri, $herci, $obsah, $medium, $rozlisenie, $zvuk, $titulky, $velkost, $umiestnenie, $komentar, $poznamky, $form_name, $button_name, $button_text, $js, $db, $id_film, $auto, $noedit = false) {
    zac_form(1, $form_name, 0);
    if ($noedit)
        vseobecne_informacie_noedit();
    else
        vseobecne_informacie($cs_name, $zanre, $natacania, $reziseri, $herci, $obsah, $form_name, false, 0, $auto);    
    sukromne_informacie($medium, $rozlisenie, $zvuk, $titulky, $velkost, $umiestnenie, $komentar, $poznamky, $form_name, $db, $id_film);
    ?><p class="zvyraznene">* - povinné položky</p><?php
    echo button($button_name, $button_text, '', 'onclick="javascript:' . $js . '"');
    if (!$db && !$auto) {
        if ($_SESSION['zan'] < MAX_ZANROV)
            echo button('pridaj_zaner', '', 'style="display: none"', 'onclick="javascript:' . $js . '"');
        if ($_SESSION['zan'] > 1)
            echo button('odober_zaner', '', 'style="display: none"', 'onclick="javascript:' . $js . '"');
        if ($_SESSION['nat'] < MAX_NATACANI)
            echo button('pridaj_natacanie', '', 'style="display: none"', 'onclick="javascript:' . $js . '"');
        if ($_SESSION['nat'] > 1)
            echo button('odober_natacanie', '', 'style="display: none"', 'onclick="javascript:' . $js . '"');
        if ($_SESSION['rez'] < MAX_REZISEROV)
            echo button('pridaj_reziser', '', 'style="display: none"', 'onclick="javascript:' . $js . '"');
        if ($_SESSION['rez'] > 1)
            echo button('odober_reziser', '', 'style="display: none"', 'onclick="javascript:' . $js . '"');
        if ($_SESSION['her'] < MAX_HERCOV)
            echo button('pridaj_herec', '', 'style="display: none"', 'onclick="javascript:' . $js . '"');
        if ($_SESSION['her'] > 1)
            echo button('odober_herec', '', 'style="display: none"', 'onclick="javascript:' . $js . '"');
    }
    koniec_form();
    echo button('go_back', 'Naspäť na zoznam filmov', '', 'onclick="javascript:window.location.href=\'db.php\'"');
}

function vypis_form_uprava_filmu($cs_name, $zanre, $natacania, $reziseri, $herci, $obsah, $form_name, $button_name, $button_text, $js, $admin, $id_film, $spracovanie_poziadavky = false) {
    zac_form(1, $form_name, 0);
    vseobecne_informacie($cs_name, $zanre, $natacania, $reziseri, $herci, $obsah, $form_name, true, $id_film, 0, $spracovanie_poziadavky);    
    ?><p class="zvyraznene">* - povinné položky</p><?php
    echo button($button_name, $button_text, '', 'onclick="javascript:' . $js . '"');
    koniec_form();
    $row = daj_udaje_z_db("SELECT id FROM film_public WHERE id=" . $id_film);
    echo ($admin) ? button('go_back', 'Naspäť na film', '', 'onclick="javascript:window.location.href=\'film_info.php?id=' . $row['id'] . '\'"') 
            : button('go_back', 'Naspäť na film', '', 'onclick="javascript:window.location.href=\'film.php?id=' . $row['id'] . '\'"');
}

function vseobecne_informacie($cs_name, $zanre, $natacania, $reziseri, $herci, $obsah, $form_name, $db, $id_film, $auto, $spracovanie_poziadavky = false) {
    if ($db)
        $row = daj_udaje_z_db('SELECT * FROM film_public WHERE id=' . $id_film);
    if ($spracovanie_poziadavky)
        $row_poz = daj_udaje_z_db("SELECT * FROM zmena_filmu WHERE id = " . $_GET['id']);
    zac_fieldset('Všeobecné informácie');
    if (!$auto) {
        ?><script type="text/javascript">  
                var spin_minutaz = new CriosSpinEdit('s2');
                var spin_hodnotenie = new CriosSpinEdit('s3');  
                spin_minutaz.MinValue = 1;
                spin_minutaz.MaxValue = 999;
                spin_hodnotenie.MaxValue = 100;		
        </script><?php
        $name = ($db) ? $row['original_name'] : $_SESSION['original_name'];
        $rok = ($db) ? $row['vydanie'] : $_SESSION['rok_vydania'];
        echo '<h2>' . $name . ' ( ' . $rok . ' )</h2>';
    } else {
        echo '<h2 id="h2_name_rok"></h2>';
    }
    
    ?><table><?php
    $pom = (isset($_POST["cs_name"])) ? $_POST["cs_name"] : (($db) ? $row['cs_name'] : '');
    vypis_riadok_tabulky('cs_name', 'Český / slovenský názov', MIN_TEXT . ' - ' . MAX_TEXT . ' znakov', 
            bunka_povinnosti_polozky(true), 
            input('text', 'cs_name', INPUT_TEXT, MAX_TEXT, $pom, 'onkeyup="s(this.value, \'cs_name_obr\', 1, ' . MIN_TEXT . ', ' . MAX_TEXT . ')"'), 
            '', '');
    if ($spracovanie_poziadavky) vypis_riadok_navrhovane_data($row_poz['cs_name'], 5);    
    vypis_zly_riadok($cs_name, ZLE_CS_NAME, 5);
    if (!$auto) {
        vypis_viachodnotovy_riadok_tabulky('Žáner ', 'zaner', 'zan', 'žáner', MAX_ZANROV, 'výber jednej z možností', $form_name, $row['zaner'], 'zanre');
        if ($spracovanie_poziadavky) vypis_riadok_navrhovane_data(vypis_viac_veci_z_jedneho ($row_poz['zaner']), 5);
        vypis_zly_riadok($zanre, ZLE_ZANER, 15); 
    } else {
        $_SESSION['nat'] = MAX_ZANROV;
    }
    vypis_viachodnotovy_riadok_tabulky('Miesta natáčania ', 'natacanie', 'nat', 'natáčanie', MAX_NATACANI, MIN_TEXT . ' - ' . MAX_TEXT . ' znakov, znak @ nie je povolený', $form_name, $row['natacanie']);
    if ($spracovanie_poziadavky) vypis_riadok_navrhovane_data(vypis_viac_veci_z_jedneho ($row_poz['natacanie']), 15);
    vypis_zly_riadok($natacania, ZLE_NATACANIE, 5);
    if (!$auto) {
        $pom = (isset($_POST["minutaz"])) ? $_POST["minutaz"] : (($db) ? $row['minutaz'] : '1');
        ?><script type="text/javascript"> spin_minutaz.DefaultValue = <?php echo $pom; ?>; </script><?php 
        vypis_riadok_tabulky('minutaz', 'Minutáž', '1 - 999 minút', 
                bunka_povinnosti_polozky(true), 
                '<script type="text/javascript"> spin_minutaz.WriteControl(\'spin_minutaz\'); </script>', '', 
                input('hidden', 'minutaz', 0, MAX_TEXT, $pom));
        if ($spracovanie_poziadavky) vypis_riadok_navrhovane_data($row_poz['minutaz'], 5);
        vypis_viachodnotovy_riadok_tabulky('Režiséri ', 'reziser', 'rez', 'režiséra', MAX_REZISEROV, MIN_TEXT . ' - ' . MAX_TEXT . ' znakov, znak @ nie je povolený', $form_name, $row['reziser']);
        if ($spracovanie_poziadavky) vypis_riadok_navrhovane_data(vypis_viac_veci_z_jedneho ($row_poz['reziser']), 5);
        vypis_zly_riadok($reziseri, ZLE_REZISER, 15);
        vypis_viachodnotovy_riadok_tabulky('Herci ', 'herec', 'her', 'herca', MAX_HERCOV, MIN_TEXT . ' - ' . MAX_TEXT . ' znakov, znak @ nie je povolený', $form_name, $row['herci']);
        if ($spracovanie_poziadavky) vypis_riadok_navrhovane_data(vypis_viac_veci_z_jedneho ($row_poz['herci']), 5);
        vypis_zly_riadok($herci, ZLE_HEREC, 15);
        $pom = (isset($_POST["obsah"])) ? $_POST["obsah"] : (($db) ? $row['obsah'] : '');
        vypis_riadok_tabulky('obsah', 'Obsah', MIN_TEXT . ' - ' . MAX_HUGETEXT . ' znakov', 
                bunka_povinnosti_polozky(true), 
                textarea('obsah', 17, 8, $pom, 'onkeyup="s(this.value, \'obsah_obr\', 1, ' . MIN_TEXT . ', ' . MAX_HUGETEXT . ')"'),            
                '', '');
        if ($spracovanie_poziadavky) vypis_riadok_navrhovane_data($row_poz['obsah'], 5);
        vypis_zly_riadok($obsah, ZLE_OBSAH, 5);
        $pom = (isset($_POST["hodnotenie"])) ? $_POST["hodnotenie"] : (($db) ? $row['hodnotenie'] : '0');
        ?><script type="text/javascript"> spin_hodnotenie.DefaultValue = <?php echo $pom; ?>; </script><?php 
        vypis_riadok_tabulky('hodnotenie', 'Hodnotenie', '0 - 100%', 
                bunka_povinnosti_polozky(true), 
                '<script type="text/javascript"> spin_hodnotenie.WriteControl(\'spin_hodnotenie\'); </script>', '', 
                input('hidden', 'hodnotenie', 0, MAX_TEXT, $pom));
        if ($spracovanie_poziadavky) vypis_riadok_navrhovane_data($row_poz['hodnotenie'], 5);
    }
    ?></table><?php
    if ($auto) {        
        ?><table>
            <tr>
                <th>Žáner:</th>
                <td id="td_zaner"></td>
            </tr>
            <tr>
                <th>Minutáž:</th>
                <td id="td_minutaz"></td>
            </tr>
            <tr>
                <th>Režiséri:</th>
                <td id="td_reziseri"></td>
            </tr>
            <tr>
                <th>Herci:</th>
                <td id="td_herci"></td>
            </tr>
            <tr>
                <th>Obsah:</th>
                <td id="td_obsah"></td>
            </tr>
            <tr>
                <th>Hodnotenie:</th>
                <td id="td_hodnotenie"></td>
            </tr>
         </table><?php
         echo input('hidden', 'a_original_name', INPUT_TEXT, MAX_HUGETEXT, '');
         echo input('hidden', 'a_zaner', INPUT_TEXT, MAX_HUGETEXT, '');
         echo input('hidden', 'a_rok', INPUT_TEXT, MAX_HUGETEXT, '');
         echo input('hidden', 'a_minutaz', INPUT_TEXT, MAX_HUGETEXT, '');
         echo input('hidden', 'a_reziser', INPUT_TEXT, MAX_HUGETEXT, '');
         echo input('hidden', 'a_herci', INPUT_TEXT, MAX_HUGETEXT, '');
         echo input('hidden', 'a_hodnotenie', INPUT_TEXT, MAX_HUGETEXT, '');
         echo input('hidden', 'a_obsah', INPUT_TEXT, MAX_HUGETEXT, '');
    }
    koniec_fieldset();
}

function vseobecne_informacie_noedit() {
    zac_fieldset('Všeobecné informácie');
    $row = daj_udaje_z_db('SELECT * FROM film_public WHERE id=' . $_GET['id']);
    ?><table>
    <tr>
        <th>Originálny názov:</th>
        <td><?php echo $row['original_name']; ?></td>
    </tr>
    <tr>
        <th>Český / slovenský názov:</th>
        <td><?php echo $row['cs_name']; ?></td>
    </tr>
    <tr>
        <th>Žáner:</th>
        <td><?php echo vypis_viac_veci_z_jedneho($row['zaner']); ?></td>
    </tr>
    <tr>
        <th>Miesta natáčania:</th>
        <td><?php echo vypis_viac_veci_z_jedneho($row['natacanie']); ?></td>
    </tr>
    <tr>
        <th>Rok vydania:</th>
        <td><?php echo $row['vydanie']; ?></td>
    </tr>
    <tr>
        <th>Minutáž:</th>
        <td><?php echo $row['minutaz']; ?></td>
    </tr>
    <tr>
        <th>Režiséri:</th>
        <td><?php echo vypis_viac_veci_z_jedneho($row['reziser']); ?></td>
    </tr>
    <tr>
        <th>Herci:</th>
        <td><?php echo vypis_viac_veci_z_jedneho($row['herci']); ?></td>
    </tr>
    <tr>
        <th>Obsah:</th>
        <td><?php echo $row['obsah']; ?></td>
    </tr>
    <tr>
        <th>Hodnotenie:</th>
        <td><?php echo $row['hodnotenie']; ?></td>
    </tr>
    <tr>
        <th>Obal:</th>
        <td><img src="<?php echo $row['obal']; ?>" alt="obal" height="70" width="80" title="Obal filmu" /></td>
    </tr>
    </table><?php
    koniec_fieldset();
}

function sukromne_informacie($medium, $rozlisenie, $zvuk, $titulky, $velkost, $umiestnenie, $komentar, $poznamky, $form_name, $db, $id_film) {
    ?><script type="text/javascript">
            var spin_velkost = new CriosSpinEdit('s4');
            var spin_pozreti = new CriosSpinEdit('s5');
            var spin_vlastne_hodnotenie = new CriosSpinEdit('s6');
            spin_velkost.DefaultValue = 1;
            spin_velkost.MinValue = 1;    
            spin_velkost.MaxValue = 100000;
            spin_velkost.Size = 8;		
            spin_pozreti.MaxValue = 1000;
            spin_vlastne_hodnotenie.MaxValue = 100;    		    
    </script><?php
    if ($db)
        $row = daj_udaje_z_db('SELECT * FROM film_private WHERE id_film = ' . $id_film . ' AND id_user = ' . $_SESSION['id']);
    if ($db && (!(isset($_POST['velkost_r'])))) {
        if (is_numeric($row['velkost'])) {
            $druhe_velkost = true;
            ?><script type="text/javascript"> spin_velkost.DefaultValue = <?php echo $row['velkost']; ?>; </script><?php
        } else
            $druhe_velkost = false;
    } elseif (isset($_POST['spinn_velkost']) && ($_POST['velkost_r'] == 'v3_spin')) {
        ?><script type="text/javascript"> spin_velkost.DefaultValue = <?php echo $_POST['spinn_velkost']; ?>; </script><?php
    }
    zac_fieldset('Súkromné informácie');
    ?><table><?php
    $druhe = ($db && !je_select('media', $row['medium'])) ? true : false;
    $hodnota = ($db) ? $row['medium'] : '';
    vypis_vyber_dvoch_poloziek('medium_r', 'v_select', 'v_input', 'select_medium', 'input_medium', 'media', $form_name, 'Médium ', 'false', 'text', '', "document.forms['" . $form_name . "'].input_medium", $db, $druhe, $hodnota);
    vypis_zly_riadok($medium, ZLE_MEDIUM, 5);

    $druhe = ($db && !je_select('rozlisenia', $row['rozlisenie'])) ? true : false;
    $hodnota = ($db) ? $row['rozlisenie'] : '';
    vypis_vyber_dvoch_poloziek('rozlisenie_r', 'v2_select', 'v2_input', 'select_rozlisenie', 'input_rozlisenie', 'rozlisenia', $form_name, 'Rozlíšenie: ', 'false', 'text', '', "document.forms['" . $form_name . "'].input_rozlisenie", $db, $druhe, $hodnota);
    vypis_zly_riadok($rozlisenie, ZLE_ROZLISENIE, 5);
    $druhe = ($db && !je_select('zvuky', $row['zvuk'])) ? true : false;
    $hodnota = ($db) ? $row['zvuk'] : '';
    vypis_vyber_dvoch_poloziek('zvuk_r', 'v4_select', 'v4_input', 'select_zvuk', 'input_zvuk', 'zvuky', $form_name, 'Zvuk: ', 'false', 'text', '', "document.forms['" . $form_name . "'].input_zvuk", $db, $druhe, $hodnota);
    vypis_zly_riadok($zvuk, ZLE_ZVUK, 5);
    $druhe = ($db && !je_select('titulky', $row['titulky'])) ? true : false;
    $hodnota = ($db) ? $row['titulky'] : '';
    vypis_vyber_dvoch_poloziek('titulky_r', 'v5_select', 'v5_input', 'select_titulky', 'input_titulky', 'titulky', $form_name, 'Titulky: ', 'false', 'text', '', "document.forms['" . $form_name . "'].input_titulky", $db, $druhe, $hodnota);
    vypis_zly_riadok($titulky, ZLE_TITULKY, 5);
    $pom = (isset($_POST["bonusy"])) ? $_POST["bonusy"] : (($db) ? $row['bonusy'] : 'nie');
    $pom1 = ($pom == 'áno') ? 'selected="selected"' : '';
    $pom2 = ($pom == 'nie') ? 'selected="selected"' : '';
    vypis_riadok_tabulky('bonusy', 'Bonusy', 'výber jednej z možností', 
            bunka_povinnosti_polozky(false),
            '<select name="bonusy">' . '<option value="áno" ' . $pom1 . '>Áno</option>' . '<option value="nie" ' . $pom2 . '>Nie</option>' . '</select>',             
            '', '');
    $hodnota = ($db) ? $row['velkost'] : '';
    vypis_vyber_dvoch_poloziek('velkost_r', 'v3_select', 'v3_spin', 'select_velkost', 'spinn_velkost', 'velkosti', $form_name, 'Veľkosť: ', 'true', 'hidden', '<script type="text/javascript"> spin_velkost.WriteControl(\'spin_velkost\'); </script>', 'spin_velkost', $db, $druhe_velkost, $hodnota);
    vypis_zly_riadok($velkost, ZLE_VELKOST, 5);
    $pom = (isset($_POST["umiestnenie"])) ? $_POST["umiestnenie"] : (($db) ? $row['umiestnenie'] : '');
    vypis_riadok_tabulky('umiestnenie', 'Umiestnenie', MIN_TEXT . ' - ' . MAX_TEXT . ' znakov', 
            bunka_povinnosti_polozky(false), 
            input('text', 'umiestnenie', INPUT_TEXT, MAX_TEXT, $pom, 'onkeyup="s(this.value, \'umiestnenie_obr\', 5, ' . MIN_TEXT . ', ' . MAX_TEXT . ')"'), 
            '', '');
    vypis_zly_riadok($umiestnenie, ZLE_UMIESTNENIE, 5);
    $pom = (isset($_POST["pozreti"])) ? $_POST["pozreti"] : (($db) ? $row['pozreti'] : '0');
    ?><script type="text/javascript"> spin_pozreti.DefaultValue = <?php echo $pom; ?>; </script><?php 
    vypis_riadok_tabulky('pozreti', 'Počet pozretí', '0 - 1 000 pozretí', 
            bunka_povinnosti_polozky(false), 
            '<script type="text/javascript"> spin_pozreti.WriteControl(\'spin_pozreti\'); </script>', '', 
            input('hidden', 'pozreti', 0, MAX_TEXT, $pom));
    $pom = (isset($_POST["vlastne_hodnotenie"])) ? $_POST["vlastne_hodnotenie"] : (($db) ? $row['vlastne_hodnotenie'] : '0');
    ?><script type="text/javascript"> spin_vlastne_hodnotenie.DefaultValue = <?php echo $pom; ?>; </script><?php 
    vypis_riadok_tabulky('vlastne_hodnotenie', 'Vlastné hodnotenie', '0 - 100%', 
            bunka_povinnosti_polozky(false), 
            '<script type="text/javascript"> spin_vlastne_hodnotenie.WriteControl(\'spin_vlastne_hodnotenie\'); </script>', '', 
            input('hidden', 'vlastne_hodnotenie', 0, MAX_TEXT, $pom));
    $pom = (isset($_POST["komentar"])) ? $_POST["komentar"] : (($db) ? $row['komentar'] : '');
    vypis_riadok_tabulky('komentar', 'Komentár', MIN_TEXT . ' - ' . MAX_BIGTEXT . ' znakov', 
            bunka_povinnosti_polozky(false), 
            textarea('komentar', 16, 3, $pom, 'onkeyup="s(this.value, \'komentar_obr\', 5, ' . MIN_TEXT . ', ' . MAX_BIGTEXT . ')"'),            
            '', '');
    vypis_zly_riadok($komentar, ZLE_KOMENTAR, 5);
    $pom = (isset($_POST["poznamky"])) ? $_POST["poznamky"] : (($db) ? $row['poznamky'] : '');
    vypis_riadok_tabulky('poznamky', 'Poznámky', MIN_TEXT . ' - ' . MAX_BIGTEXT . ' znakov', 
            bunka_povinnosti_polozky(false), 
            textarea('komentar', 16, 3, $pom, 'onkeyup="s(this.value, \'poznamky_obr\', 5, ' . MIN_TEXT . ', ' . MAX_BIGTEXT . ')"'),            
            '', '');
    vypis_zly_riadok($poznamky, ZLE_POZNAMKY, 5);
    ?></table><?php
    koniec_fieldset();
}

/***************************************
 **           FORM - SKUPINA          ******************************************************************************************************************************************************************
 ***************************************/

function vypis_form_skupina($name, $name_existuje, $form_name, $button_name, $button_text, $db, $id_skupina) {
    zac_form(1, $form_name, 0);
    if ($db)
        $row = daj_udaje_z_db('SELECT * FROM skupiny WHERE id=' . $id_skupina);
    $nazov_fieldset = ($db) ? "Nastavenie skupiny '" . $row['name'] . "'" : "Vytvorenie skupiny";
    zac_fieldset($nazov_fieldset);
    ?><table><?php
    $pom = (isset($_POST["name"])) ? $_POST["name"] : (($db) ? $row['name'] : '');
    vypis_riadok_tabulky('name', 'Názov skupiny', MIN_TEXT . ' - ' . MAX_TEXT . ' znakov', 
            bunka_povinnosti_polozky(true), 
            input('text', 'name', INPUT_TEXT, MAX_TEXT, $pom, 'onkeyup="s(this.value, \'name_obr\', 1, ' . MIN_TEXT . ', ' . MAX_TEXT . ')"'), 
            '', '');
    vypis_zly_riadok($name, ZLE_MENO_SKUPINY, 5);
    vypis_zly_riadok_s_ajax($name_existuje, EXISTUJE_MENO_SKUPINY, 5, 'name_existuje');
    ?><script type="text/javascript">
        s('<?php echo $pom; ?>', 'name_obr', 1, <?php echo MIN_TEXT; ?>, <?php echo MAX_TEXT; ?>);
    </script><?php
    ?></table><br /><table><?php
    
    $span_sedy_zac = '<span style="color: RGB(200, 200, 200)">';
    $span_sedy_kon = '</span>';
    $pom1 = (isset($_POST['meno'])) ? 'checked="checked"' : (($db && $row['meno'] == true) ? 'checked="checked"' : '');
    $pom = 'Meno';
    $meno = (($db && $row['meno'] == true) || !$db) ? $pom : $span_sedy_zac . $pom . $span_sedy_kon;
    $pom2 = (isset($_POST['vek'])) ? 'checked="checked"' : (($db && $row['vek'] == true) ? 'checked="checked"' : '');
    $pom = 'Vek';
    $vek = (($db && $row['vek'] == true) || !$db) ? $pom : $span_sedy_zac . $pom . $span_sedy_kon;
    $pom3 = (isset($_POST['medium'])) ? 'checked="checked"' : (($db && $row['medium'] == true) ? 'checked="checked"' : '');
    $pom = 'Médium';
    $medium = (($db && $row['medium'] == true) || !$db) ? $pom : $span_sedy_zac . $pom . $span_sedy_kon;
    $pom4 = (isset($_POST['velkost'])) ? 'checked="checked"' : (($db && $row['velkost'] == true) ? 'checked="checked"' : '');
    $pom = 'Veľkosť';
    $velkost = (($db && $row['velkost'] == true) || !$db) ? $pom : $span_sedy_zac . $pom . $span_sedy_kon;
    vypis_riadok_tabulky_stvority('meno', $meno, 
            input('checkbox', 'meno', 0, 0, '', $pom1),
            'vek', $vek, 
            input('checkbox', 'vek', 0, 0, '', $pom2),
            'medium', $medium, 
            input('checkbox', 'medium', 0, 0, '', $pom3),
            'velkost', $velkost,
            input('checkbox', 'velkost', 0, 0, '', $pom4));
    $pom1 = (isset($_POST['priezvisko'])) ? 'checked="checked"' : (($db && $row['priezvisko'] == true) ? 'checked="checked"' : '');
    $pom = 'Priezvisko';
    $priezvisko = (($db && $row['priezvisko'] == true) || !$db) ? $pom : $span_sedy_zac . $pom . $span_sedy_kon;
    $pom2 = (isset($_POST['fav_film'])) ? 'checked="checked"' : (($db && $row['fav_film'] == true) ? 'checked="checked"' : '');
    $pom = 'Obľúbený film';
    $fav_film = (($db && $row['fav_film'] == true) || !$db) ? $pom : $span_sedy_zac . $pom . $span_sedy_kon;
    $pom3 = (isset($_POST['rozlisenie'])) ? 'checked="checked"' : (($db && $row['rozlisenie'] == true) ? 'checked="checked"' : '');
    $pom = 'Rozlíšenie';
    $rozlisenie = (($db && $row['rozlisenie'] == true) || !$db) ? $pom : $span_sedy_zac . $pom . $span_sedy_kon;
    $pom4 = (isset($_POST['umiestnenie'])) ? 'checked="checked"' : (($db && $row['umiestnenie'] == true) ? 'checked="checked"' : '');
    $pom = 'Umiestnenie';
    $umiestnenie = (($db && $row['umiestnenie'] == true) || !$db) ? $pom : $span_sedy_zac . $pom . $span_sedy_kon;
    vypis_riadok_tabulky_stvority('priezvisko', $priezvisko, 
                input('checkbox', 'priezvisko', 0, 0, '', $pom1), 
                'fav_film', $fav_film, 
                input('checkbox', 'fav_film', 0, 0, '', $pom2),
                'rozlisenie', $rozlisenie, 
                input('checkbox', 'rozlisenie', 0, 0, '', $pom3),
                'umiestnenie', $umiestnenie,
                input('checkbox', 'umiestnenie', 0, 0, '', $pom4));
    $pom1 = (isset($_POST['mail'])) ? 'checked="checked"' : (($db && $row['mail'] == true) ? 'checked="checked"' : '');
    $pom = 'E-Mail';
    $mail = (($db && $row['mail'] == true) || !$db) ? $pom : $span_sedy_zac . $pom . $span_sedy_kon;
    $pom2 = (isset($_POST['fav_actor'])) ? 'checked="checked"' : (($db && $row['fav_actor'] == true) ? 'checked="checked"' : '');
    $pom = 'Obľúbený herec';
    $fav_actor = (($db && $row['fav_actor'] == true) || !$db) ? $pom : $span_sedy_zac . $pom . $span_sedy_kon;
    $pom3 = (isset($_POST['zvuk'])) ? 'checked="checked"' : (($db && $row['zvuk'] == true) ? 'checked="checked"' : '');
    $pom = 'Zvuk';
    $zvuk = (($db && $row['zvuk'] == true) || !$db) ? $pom : $span_sedy_zac . $pom . $span_sedy_kon;
    $pom4 = (isset($_POST['vlastne_hodnotenie'])) ? 'checked="checked"' : (($db && $row['vlastne_hodnotenie'] == true) ? 'checked="checked"' : '');
    $pom = 'Vlastné hodnotenie';
    $vlastne_hodnotenie = (($db && $row['vlastne_hodnotenie'] == true) || !$db) ? $pom : $span_sedy_zac . $pom . $span_sedy_kon;
    vypis_riadok_tabulky_stvority('mail', $mail, 
                input('checkbox', 'mail', 0, 0, '', $pom1), 
                'fav_actor', $fav_actor, 
                input('checkbox', 'fav_actor', 0, 0, '', $pom2), 
                'zvuk', $zvuk,
                input('checkbox', 'zvuk', 0, 0, '', $pom3),
                'vlastne_hodnotenie', $vlastne_hodnotenie,
                input('checkbox', 'vlastne_hodnotenie', 0, 0, '', $pom4));
    $pom1 = (isset($_POST['zamestnanie'])) ? 'checked="checked"' : (($db && $row['zamestnanie'] == true) ? 'checked="checked"' : '');
    $pom = 'Zamestnanie';
    $zamestnanie = (($db && $row['zamestnanie'] == true) || !$db) ? $pom : $span_sedy_zac . $pom . $span_sedy_kon;
    $pom2 = (isset($_POST['fav_zaner'])) ? 'checked="checked"' : (($db && $row['fav_zaner'] == true) ? 'checked="checked"' : '');
    $pom = 'Obľúbený žáner';
    $fav_zaner = (($db && $row['fav_zaner'] == true) || !$db) ? $pom : $span_sedy_zac . $pom . $span_sedy_kon;
    $pom3 = (isset($_POST['titulky'])) ? 'checked="checked"' : (($db && $row['titulky'] == true) ? 'checked="checked"' : '');
    $pom = 'Titulky';
    $titulky = (($db && $row['titulky'] == true) || !$db) ? $pom : $span_sedy_zac . $pom . $span_sedy_kon;
    $pom4 = (isset($_POST['komentar'])) ? 'checked="checked"' : (($db && $row['komentar'] == true) ? 'checked="checked"' : '');
    $pom = 'Komentár';
    $komentar = (($db && $row['komentar'] == true) || !$db) ? $pom : $span_sedy_zac . $pom . $span_sedy_kon;
    vypis_riadok_tabulky_stvority('zamestnanie', $zamestnanie, 
                input('checkbox', 'zamestnanie', 0, 0, '', $pom1), 
                'fav_zaner', $fav_zaner, 
                input('checkbox', 'fav_zaner', 0, 0, '', $pom2),
                'titulky', $titulky,
                input('checkbox', 'titulky', 0, 0, '', $pom3),
                'komentar', $komentar,
                input('checkbox', 'komentar', 0, 0, '', $pom4));
    $pom1 = (isset($_POST['telefon'])) ? 'checked="checked"' : (($db && $row['telefon'] == true) ? 'checked="checked"' : '');
    $pom = 'Telefónne číslo';
    $telefon = (($db && $row['telefon'] == true) || !$db) ? $pom : $span_sedy_zac . $pom . $span_sedy_kon;
    $pom2 = (isset($_POST['zaluby'])) ? 'checked="checked"' : (($db && $row['zaluby'] == true) ? 'checked="checked"' : '');
    $pom = 'Záľuby';
    $zaluby = (($db && $row['zaluby'] == true) || !$db) ? $pom : $span_sedy_zac . $pom . $span_sedy_kon;
    $pom3 = (isset($_POST['bonusy'])) ? 'checked="checked"' : (($db && $row['bonusy'] == true) ? 'checked="checked"' : '');
    $pom = 'Bonusy';
    $bonusy = (($db && $row['bonusy'] == true) || !$db) ? $pom : $span_sedy_zac . $pom . $span_sedy_kon;
    $pom4 = (isset($_POST['poznamky'])) ? 'checked="checked"' : (($db && $row['poznamky'] == true) ? 'checked="checked"' : '');
    $pom = 'Poznámky';
    $poznamky = (($db && $row['poznamky'] == true) || !$db) ? $pom : $span_sedy_zac . $pom . $span_sedy_kon;
    vypis_riadok_tabulky_stvority('telefon', $telefon, 
                input('checkbox', 'telefon', 0, 0, '', $pom1), 
                'zaluby', $zaluby, 
                input('checkbox', 'zaluby', 0, 0, '', $pom2), 
                'bonusy', $bonusy,
                input('checkbox', 'bonusy', 0, 0, '', $pom3),
                'poznamky', $poznamky,
                input('checkbox', 'poznamky', 0, 0, '', $pom4));
    
          
    ?></table><?php
    
    ?><p class="zvyraznene">Zaškrtnutím povolíte zdielanie danej položky pre používateľov v skupine.<br />* - povinné položky</p><?php
    echo button($button_name, $button_text, '', '');
    koniec_fieldset();
    koniec_form();    
}

/***************************************
 **           FORM - NAOZAJ           ******************************************************************************************************************************************************************
 ***************************************/

function vypis_form_naozaj_urobit($legenda, $text, $co, $button_name) {
    zac_form(1, '', 0);
    zac_fieldset($legenda . $co);
    echo $text . $co . '?';
    echo button($button_name, 'Áno, chcem', '', '');
    echo button($button_name . '_nie', 'Nie, nechcem', '', '');
    koniec_fieldset();
    koniec_form();
}

/***************************************
 **      FORM - VYBER MOZNOSTI        ******************************************************************************************************************************************************************
 ***************************************/

function vypis_form_vyber_moznosti($upravenie_moznosti, $pridanie_moznosti) {  
    $mozne_hodnoty = array('kraje', 'media', 'rozlisenia', 'titulky', 'velkosti', 'zvuky', 'zanre');
    if (in_array($_SESSION['adm_vyber_moznost'], $mozne_hodnoty)) {
        zac_form(1, 'form_vyber_' . $_SESSION['adm_vyber_moznost'], 0);
        ?><p class="zvyraznene">Administrácia výberových možností</p>
        <table class="tabulka_jednoducha">
            <tr>
                <th></th>
                <th>Názov</th>
                <th></th>
                <th></th>
            </tr><?php
        if ($link = spoj_s_db()) {
            $sql = "SELECT * FROM " . $_SESSION['adm_vyber_moznost'] . " ORDER BY LOWER(nazov) ASC"; // definuj dotaz
            $result = mysql_query($sql, $link); // vykonaj dotaz    	
            $i = 0;
            if ($result) {
                // dotaz sa podarilo vykonať    			
                while ($row = mysql_fetch_assoc($result)) {
                    $i++;
                    $pom = (isset($_POST[$_SESSION['adm_vyber_moznost'] . $row['id']])) ? $_POST[$_SESSION['adm_vyber_moznost'] . $row['id']] : $row['nazov'];
                    $komponent1 = ($pom == '-') ? input('text" readonly="readonly', $_SESSION['adm_vyber_moznost'] . $row['id'], INPUT_TEXT, MAX_TEXT, $pom)
                            : input('text', $_SESSION['adm_vyber_moznost'] . $row['id'], INPUT_TEXT, MAX_TEXT, $pom, 'onkeyup="javascript:s(this.value, \'' . $_SESSION['adm_vyber_moznost'] . $row['id'] . '_obr\', 5, ' . MIN_TEXT . ', ' . MAX_TEXT . ')"');
                    $komponent2 = ($pom == '-') ? '</td><td>' 
                            : '</td><td><img class="delete" id="d' . $row['id'] . '" src="obrazky/delete.png" width="24" height="24" alt="vymazať výberovú možnosť" title="vymazať výberovú možnosť" style="cursor: pointer" />';
                    /*$komponent2 = ($pom == '-') ? '</td><td>' 
                            : '</td><td><img src="obrazky/delete.png" width="24" height="24" alt="vymazať výberovú možnosť" title="vymazať výberovú možnosť" onclick="javascript:document.form_vyber_' . $_SESSION['adm_vyber_moznost'] . '.b_' . $_SESSION['adm_vyber_moznost'] . $row['id'] . '.click()" style="cursor: pointer" />'
                            . button('b_' . $_SESSION['adm_vyber_moznost'] . $row['id'], '', 'style="display: none"', 'id="' . $row['nazov'] . '"');*/
                    vypis_riadok_tabulky($_SESSION['adm_vyber_moznost'] . $row['id'], $i . '. ', MIN_TEXT . ' - ' . MAX_TEXT . ' znakov', '', 
                            $komponent1, '', 
                            $komponent2);
                    if ($pom == '-') {
                        ?><script type="text/javascript"> s('<?php echo $pom; ?>', '<?php echo $_SESSION["adm_vyber_moznost"] . $row['id']; ?>_obr', 0, 0, 0); </script><?php
                    } else {
                        ?><script type="text/javascript"> s('<?php echo $pom; ?>', '<?php echo $_SESSION["adm_vyber_moznost"] . $row['id']; ?>_obr', 5, <?php echo MIN_TEXT; ?>, <?php echo MAX_TEXT; ?>); </script><?php
                    }
                }
                mysql_free_result($result);
            }
            mysql_close($link);
        } else {
            // NEpodarilo sa spojiť s databázovým serverom!
        }
        vypis_zly_riadok($upravenie_moznosti, ZLE_UPRAVA_MOZNOSTI, 5);
        ?></table><?php
        echo button('zmen_vyberove_moznosti', 'Upraviť výberové možnosti', '', '');        
        ?><table class="tabulka_jednoducha"><?php
        $pom = (isset($_POST['nova_moznost'])) ? $_POST['nova_moznost'] : '';
        vypis_riadok_tabulky('nova_moznost', 'Nová možnosť', MIN_TEXT . ' - ' . MAX_TEXT . ' znakov', '',
                input('text', 'nova_moznost', INPUT_TEXT, MAX_TEXT, $pom, 'onkeyup="javascript:s(this.value, \'nova_moznost_obr\', 5, ' . MIN_TEXT . ', ' . MAX_TEXT . ')"'),
                '', '');
        vypis_zly_riadok($pridanie_moznosti, ZLE_PRIDANIE_MOZNOSTI, 5);
        ?></table>
        <script type="text/javascript">
            s('<?php echo $pom; ?>', 'nova_moznost_obr', 5, <?php echo MIN_TEXT; ?>, <?php echo MAX_TEXT; ?>);
        </script><?php
        echo button('pridaj_vyberovu_moznost', 'Pridaj novú výberovú možnosť', '', '');
        koniec_form();
    } else
        echo NENI_PRISTUP;
}

/***************************************
 **      FORM - POSLANIE KONTAKTU     ******************************************************************************************************************************************************************
 ***************************************/

function vypis_form_kontakt($kontakt, $form_name, $button_name, $button_text, $id_film, $id_user) {
    zac_form(1, $form_name, 0);
    $film = daj_udaje_z_db("SELECT * FROM film_public WHERE id=" . $id_film);
    $user = daj_udaje_z_db("SELECT * FROM users WHERE id=" . $id_user);
    zac_fieldset("Poslanie kontaktu na požičanie filmu");    
    ?><p>Napíšte kontakt na vás, aby vás mohol záujemca kontaktovať (E-mail, telefón, ...).</p>
    <p>Záujemca: <strong><?php echo $user['username']; ?></strong></p>
    <p>Požadovaný film: <strong><?php echo $film['original_name']; ?></strong></p><table><?php
    $pom = (isset($_POST["kontakt"])) ? $_POST["kontakt"] : '';
    vypis_riadok_tabulky('kontakt', 'Kontakt', MIN_TEXT . ' - ' . MAX_BIGTEXT . ' znakov', 
            bunka_povinnosti_polozky(true), 
            textarea('kontakt', 16, 3, $pom, 'onkeyup="s(this.value, \'kontakt_obr\', 1, ' . MIN_TEXT . ', ' . MAX_BIGTEXT . ')"'),            
            '', '');
    vypis_zly_riadok($kontakt, ZLE_KONTAKT, 5);
    ?></table><?php
    echo button($button_name, $button_text, '', '');    
    koniec_fieldset();
    koniec_form();
}

/***************************************
 **             KONTROLY              ******************************************************************************************************************************************************************
 ***************************************/

function je_select($kde, $co) {
    return (pocet_zaznamov("SELECT * FROM " . $kde . " WHERE nazov='" . $co . "'") > 0);
}

function spravny_text($text, $min, $max) {
    $_POST[$text] = addslashes(htmlspecialchars(strip_tags(trim($_POST[$text])), ENT_QUOTES));
    return ((strlen($_POST[$text]) >= $min) && (strlen($_POST[$text]) <= $max + 8));
}

function spravny_text_cisty($text, $min, $max) {
    return ((strlen($text) >= $min) && (strlen($text) <= $max));
}

function spravny_text_pismena_cisla($text, $min, $max) {
    return (preg_match("/^[a-zA-Z0-9]{" . $min . "," . $max . "}$/", $text) > 0);
}

function spravny_mail() {
    $mail = $_POST['mail'];
    $_POST['mail'] = addslashes(htmlspecialchars(strip_tags(trim($_POST['mail'])), ENT_QUOTES));
    if (strlen($mail) != strlen($_POST['mail']))
        return false;
    $poz = strpos($_POST['mail'], "@");
    $mailpom = substr($_POST['mail'], $poz + 1);
    if (strpos($mailpom, "@") === false && strpos($_POST['mail'], ' ') === false)
        return ((strlen($_POST['mail']) > 4) && (preg_match("/^.{1,}@.{1,}\..{1,}$/", $_POST['mail']) > 0) && (strlen($_POST['mail']) < 59));
    else
        return false;
}

function spravny_telefon() {
    return (preg_match("/^\+[0-9]{12}$/", $_POST['telefon']) > 0);
}

function spravny_datum_narodenia() {
    $rok = $_POST['datum_narodenia'];
    if ((strlen($rok) > 7) && (strlen($rok) < 11)) {
        if (preg_match("/^[0-9]{1,2}\.[0-9]{1,2}\.[0-9]{4}$/", $rok) > 0) {
            $poz = strpos($rok, '.');
            $den = substr($rok, 0, $poz);
            $rok = substr($rok, $poz + 1);
            $poz = strpos($rok, '.');
            $mesiac = substr($rok, 0, $poz);
            $rok = substr($rok, $poz + 1);
            $ano = true;
            if (($rok > MAX_ROK) || ($rok < MIN_ROK))
                $ano = false;
            if (($mesiac > 12) || ($mesiac < 1))
                $ano = false;
            if (($den > 31) || ($den < 1))
                $ano = false;
            if ($mesiac == 2 && $den == 29 && ($rok % 4 != 0))
                $ano = false;
            if ($mesiac == 2 && $den > 28 && ($rok % 4 != 0))
                $ano = false;
            if ($mesiac == 2 && $den > 29)
                $ano = false;
            $setM = array(4, 6, 9, 11);
            if (in_array($mesiac, $setM) && $den == 31)
                $ano = false;
            if ($ano)
                return true;
            else
                return false;
        } else
            return false;
    } else
        return false;
}

function spravny_pouzivatel() {
    if (!spravny_text_pismena_cisla($_POST['login'], 2, 50))
        return false;
    $heslo = $_POST['heslo'];
    $_POST['heslo'] = addslashes(htmlspecialchars(strip_tags(trim($_POST['heslo'])), ENT_QUOTES));
    if (strlen($_POST['heslo']) != strlen($heslo))
        return false;
    $row = daj_udaje_z_db("SELECT * FROM users WHERE LOWER(username)='" . strtolower($_POST['login']) . "'");
    if ((strtolower($row['username']) == strtolower($_POST['login'])) && ($row['heslo'] == hash_heslo($row['salt'], $row['username'], $_POST['heslo'])))
        return true;
    else
        return false;
}

function viac_select_check($co, $session, $tabulka) {
    $pocet_pomlciek = 0;
    for ($i = 1; $i <= $_SESSION[$session]; $i++) {
        if (isset($_POST[$co . $i]) && ($_POST[$co . $i] == '-'))
            $pocet_pomlciek++;
        if (pocet_zaznamov("SELECT * FROM " . $tabulka . " WHERE nazov='" . $_POST[$co . $i] . "'") == 0)
            return false;
    }
    return ($pocet_pomlciek < $_SESSION[$session]);
}

function viac_input_check($co, $session) {
    $pocet_empty = 0;
    for ($i = 1; $i <= $_SESSION[$session]; $i++) {
        if (isset($_POST[$co . $i]) && ($_POST[$co . $i] != '') && !spravny_text($co . $i, MIN_TEXT, MAX_TEXT))
            return false;
        if ((isset($_POST[$co . $i]) && ($_POST[$co . $i] == '')) || !isset($_POST[$co . $i]))
            $pocet_empty++;
        if (isset($_POST[$co . $i]) && strpos($_POST[$co . $i], "@") !== false)
            return false;
    }
    return ($pocet_empty < $_SESSION[$session]);
}

function check_vyber_dve($radio_name, $pm, $dm, $pm_name, $dm_name, $spin, $tabulka) {
    if ($_POST[$radio_name] == $pm) {
        return ($_POST[$pm_name] == '-' || (spravny_text($pm_name, MIN_TEXT, MAX_TEXT) && ($_POST[$pm_name] == '-' || pocet_zaznamov("SELECT * FROM " . $tabulka . " WHERE nazov='" . $_POST[$pm_name] . "'") > 0)));
    } elseif ($_POST[$radio_name] == $dm) {
        if (!$spin)
            return (isset($_POST[$dm_name]) && (spravny_text($dm_name, MIN_TEXT, MAX_TEXT) || $_POST[$dm_name] == ''));
        else
            return (isset($_POST[$dm_name]) && is_numeric($_POST[$dm_name]) && ($_POST[$dm_name] >= 1) && ($_POST[$dm_name] <= 100000));
    }
    else
        return false;
}

function spravny_obrazok() {
    $koncovky = array('jpg', 'jpeg', 'png', 'gif');
    if (!$_FILES || $_FILES["obr"]["error"] == UPLOAD_ERR_INI_SIZE)
        return false;
    elseif ($_FILES["obr"]["error"] == UPLOAD_ERR_NO_FILE)
        return false;
    elseif ($_FILES["obr"]["error"])
        return false;
    elseif (!in_array(strtolower(pathinfo($_FILES["obr"]["name"], PATHINFO_EXTENSION)), $koncovky))
        return false;
    elseif (!($imagesize = getimagesize($_FILES["obr"]["tmp_name"])) || $imagesize[2] > 3)
        return false;
    elseif ((list($width, $height, $type, $attr) = getimagesize($_FILES["obr"]["tmp_name"])) && (($width > 500) || ($height > 500)))
        return false;
    else
        return true;
}

function check_UserUdaje($ktore) {
    switch ($ktore) {
        case "username": return (isset($_POST['username']) && spravny_text_pismena_cisla($_POST['username'], MIN_TEXT, MAX_TEXT));
        case "heslo": return (isset($_POST['heslo']) && spravny_text_cisty($_POST['heslo'], MIN_HESLO, MAX_HESLO));
        case "pass": return (isset($_POST['pass']) && spravny_text_cisty($_POST['pass'], MIN_HESLO, MAX_HESLO));
        case "pass2": return (isset($_POST['pass2']) && spravny_text_cisty($_POST['pass2'], MIN_HESLO, MAX_HESLO));
        case "potvrdenie": return (isset($_POST['potvrdenie']));
        case "meno": return ((isset($_POST['meno']) && spravny_text('meno', MIN_TEXT, MAX_TEXT)) || ($_POST['meno'] == ''));
        case "priezvisko": return ((isset($_POST['priezvisko']) && spravny_text('priezvisko', MIN_TEXT, MAX_TEXT)) || ($_POST['priezvisko'] == ''));
        case "pohlavie": return (isset($_POST['pohlavie']));
        case "mail": return (isset($_POST['mail']) && spravny_mail());
        case "kraj": return (isset($_POST['kraj']));
        case "zamestnanie": return ((isset($_POST['zamestnanie']) && spravny_text('zamestnanie', MIN_TEXT, MAX_TEXT)) || ($_POST['zamestnanie'] == ''));
        case "telefon": return ((isset($_POST['telefon']) && spravny_telefon()) || ($_POST['telefon'] == ''));
        case "datum_narodenia": return ((isset($_POST['datum_narodenia']) && spravny_datum_narodenia()) || ($_POST['datum_narodenia'] == ''));
        case "fav_film": return ((isset($_POST['fav_film']) && spravny_text('fav_film', MIN_TEXT, MAX_TEXT)) || ($_POST['fav_film'] == ''));
        case "fav_actor": return ((isset($_POST['fav_actor']) && spravny_text('fav_actor', MIN_TEXT, MAX_TEXT)) || ($_POST['fav_actor'] == ''));
        case "fav_zaner": return ((isset($_POST['fav_zaner']) && spravny_text('fav_zaner', MIN_TEXT, MAX_TEXT)) || ($_POST['fav_zaner'] == ''));
        case "zaluby": return ((isset($_POST['zaluby']) && spravny_text('zaluby', MIN_TEXT, MAX_BIGTEXT)) || ($_POST['zaluby'] == ''));
        default: return false;
    }
}                                                                                                      

function check_user_udaje() {
    return (
            check_UserUdaje('username') &&
            check_UserUdaje('pass') &&
            check_UserUdaje('pass2') &&
            check_UserUdaje('potvrdenie') &&
            check_UserUdaje('meno') &&
            check_UserUdaje('priezvisko') &&
            check_UserUdaje('pohlavie') &&
            check_UserUdaje('mail') &&
            check_UserUdaje('kraj') &&
            check_UserUdaje('zamestnanie') &&
            check_UserUdaje('telefon') &&
            check_UserUdaje('datum_narodenia') &&
            check_UserUdaje('fav_film') &&
            check_UserUdaje('fav_actor') &&
            check_UserUdaje('fav_zaner') &&
            check_UserUdaje('zaluby')            
            );
}

function check_FilmPublic($ktore) {
    switch ($ktore) {
        case "cs_name": return (isset($_POST['cs_name']) && spravny_text('cs_name', MIN_TEXT, MAX_TEXT));
        case "original_name": return (isset($_SESSION['original_name']));
        case "rok_vydania": return (isset($_SESSION['rok_vydania']) && is_numeric($_SESSION['rok_vydania']) && $_SESSION['rok_vydania'] >= MIN_ROK && $_SESSION['rok_vydania'] <= MAX_ROK);
        case "obsah": return (isset($_POST['obsah']) && spravny_text('obsah', MIN_TEXT, MAX_HUGETEXT));
        case "zaner": return (viac_select_check('zaner', 'zan', 'zanre'));
        case "natacanie": return (viac_input_check('natacanie', 'nat'));
        case "reziser": return (viac_input_check('reziser', 'rez'));
        case "herec": return (viac_input_check('herec', 'her'));
        case "minutaz": return (isset($_POST['minutaz']) && is_numeric($_POST['minutaz']) && $_POST['minutaz'] > 0 && $_POST['minutaz'] < 1001);
        case "hodnotenie": return (isset($_POST['hodnotenie']) && is_numeric($_POST['hodnotenie']) && $_POST['hodnotenie'] >= 0 && $_POST['hodnotenie'] <= 100);        
        default: return false;
    }
}

function check_film_verejne_info($session_nie = false) {
    $session_cast = ($session_nie) ? true : (check_FilmPublic('original_name') && check_FilmPublic('rok_vydania'));
    return (
            check_FilmPublic('cs_name') &&
            $session_cast &&
            check_FilmPublic('obsah') &&
            check_FilmPublic('zaner') &&
            check_FilmPublic('natacanie') &&
            check_FilmPublic('reziser') &&
            check_FilmPublic('herec') &&
            check_FilmPublic('minutaz') &&
            check_FilmPublic('hodnotenie')
            );
}

function check_FilmPublicAuto($ktore) {
    switch ($ktore) {
        case "cs_name": return (isset($_POST['cs_name']) && spravny_text('cs_name', MIN_TEXT, MAX_TEXT));
        case "original_name": return (isset($_POST['a_original_name']) && spravny_text('a_original_name', MIN_TEXT, MAX_TEXT));
        case "rok_vydania": return (isset($_POST['a_rok']) && is_numeric($_POST['a_rok']) && $_POST['a_rok'] > MIN_ROK && $_POST['a_rok'] < MAX_ROK);
        case "obsah": return (isset($_POST['a_obsah']) && spravny_text('a_obsah', MIN_TEXT, MAX_HUGETEXT));
        case "zaner": return spravny_text('a_zaner', MIN_TEXT, MAX_HUGETEXT);            
        case "natacanie": return (viac_input_check('natacanie', 'nat'));
        case "reziser": return spravny_text('a_reziser', MIN_TEXT, MAX_HUGETEXT);            
        case "herec": return spravny_text('a_herci', MIN_TEXT, MAX_HUGETEXT);            
        case "minutaz": return (isset($_POST['a_minutaz']) && is_numeric($_POST['a_minutaz']) && $_POST['a_minutaz'] > 0 && $_POST['a_minutaz'] < 1001);
        case "hodnotenie": return (isset($_POST['a_hodnotenie']) && is_numeric($_POST['a_hodnotenie']) && $_POST['a_hodnotenie'] >= 0 && $_POST['a_hodnotenie'] <= 100);        
        default: return false;
    }
}

function check_film_auto_verejne_info() {    
    return (
            check_FilmPublicAuto('original_name') && 
            check_FilmPublicAuto('rok_vydania') &&
            check_FilmPublicAuto('cs_name') &&            
            check_FilmPublicAuto('obsah') &&
            check_FilmPublicAuto('zaner') &&
            check_FilmPublicAuto('natacanie') &&
            check_FilmPublicAuto('reziser') &&
            check_FilmPublicAuto('herec') &&
            check_FilmPublicAuto('minutaz') &&
            check_FilmPublicAuto('hodnotenie')
            );
}

function check_FilmPrivate($ktore) {
    switch ($ktore) {
        case "umiestnenie": return ((isset($_POST['umiestnenie']) && spravny_text('umiestnenie', MIN_TEXT, MAX_TEXT)) || ($_POST['umiestnenie'] == ''));
        case "komentar": return ((isset($_POST['komentar']) && spravny_text('komentar', MIN_TEXT, MAX_BIGTEXT)) || ($_POST['komentar'] == ''));
        case "poznamky": return ((isset($_POST['poznamky']) && spravny_text('poznamky', MIN_TEXT, MAX_BIGTEXT)) || ($_POST['poznamky'] == ''));
        case "medium": return (check_vyber_dve('medium_r', 'v_select', 'v_input', 'select_medium', 'input_medium', 0, 'media'));
        case "rozlisenie": return (check_vyber_dve('rozlisenie_r', 'v2_select', 'v2_input', 'select_rozlisenie', 'input_rozlisenie', 0, 'rozlisenia'));
        case "zvuk": return (check_vyber_dve('zvuk_r', 'v4_select', 'v4_input', 'select_zvuk', 'input_zvuk', 0, 'zvuky'));
        case "titulky": return (check_vyber_dve('titulky_r', 'v5_select', 'v5_input', 'select_titulky', 'input_titulky', 0, 'titulky'));
        case "velkost": return (check_vyber_dve('velkost_r', 'v3_select', 'v3_spin', 'select_velkost', 'spinn_velkost', 1, 'velkosti'));
        case "vlastne_hodnotenie": return (isset($_POST['vlastne_hodnotenie']) && is_numeric($_POST['vlastne_hodnotenie']) && ($_POST['vlastne_hodnotenie'] >= 0) && ($_POST['vlastne_hodnotenie'] <= 100));
        case "pozreti": return (isset($_POST['pozreti']) && is_numeric($_POST['pozreti']) && ($_POST['pozreti'] >= 0) && ($_POST['pozreti'] <= 1000));
        case "bonusy": return (isset($_POST['bonusy']) && ($_POST['bonusy'] == 'áno' || $_POST['bonusy'] == 'nie'));
        default: return false;
    }
}

function check_film_sukromne_info() {
    return (
            check_FilmPrivate('umiestnenie') &&
            check_FilmPrivate('komentar') &&
            check_FilmPrivate('poznamky') &&
            check_FilmPrivate('medium') &&
            check_FilmPrivate('rozlisenie') &&
            check_FilmPrivate('zvuk') &&
            check_FilmPrivate('titulky') &&
            check_FilmPrivate('velkost') &&
            check_FilmPrivate('vlastne_hodnotenie') &&
            check_FilmPrivate('pozreti') &&
            check_FilmPrivate('bonusy')
            );
}

function check_vyberove_moznosti() {
    $pocet = pocet_zaznamov("SELECT * FROM " . $_SESSION['adm_vyber_moznost']);
    $pocet_prazdnych = 0;
    if ($link = spoj_s_db()) {
        $sql = "SELECT * FROM " . $_SESSION['adm_vyber_moznost']; // definuj dotaz
        $result = mysql_query($sql, $link); // vykonaj dotaz
        if ($result) {
            // dotaz sa podarilo vykonať
            while ($row = mysql_fetch_assoc($result)) {
                if (!($i == 1 && $_POST[$_SESSION['adm_vyber_moznost'] . $row['id']] == '-')) {
                    if (!((isset($_POST[$_SESSION['adm_vyber_moznost'] . $row['id']]) && spravny_text($_SESSION['adm_vyber_moznost'] . $row['id'], MIN_TEXT, MAX_TEXT)) || ($_POST[$_SESSION['adm_vyber_moznost'] . $row['id']] == ''))) 
                        return false;
                    if ($_POST[$_SESSION['adm_vyber_moznost'] . $row['id']] == '' || !isset($_POST[$_SESSION['adm_vyber_moznost'] . $row['id']]))
                        $pocet_prazdnych++;
                }
            }
            mysql_free_result($result);
        }
        mysql_close($link);
    } else {
        // NEpodarilo sa spojiť s databázovým serverom!
    }
    return ($pocet_prazdnych != $pocet);
}

function check_nova_vyberova_moznost() {
    return (isset($_POST['nova_moznost']) && spravny_text('nova_moznost', MIN_TEXT, MAX_TEXT)); 
}

function check_admin() {
    $row = daj_udaje_z_db("SELECT * FROM users WHERE id=" . $_SESSION['id']);
    return ($row['admin'] == true);
}

function check_superadmin() {
    $row = daj_udaje_z_db("SELECT * FROM users WHERE id=" . $_SESSION['id']);
    return ($row['superadmin'] == true);
}

function check_administrator() {
    return (check_admin() || check_superadmin());
}

function check_user() {
    return (pocet_zaznamov("SELECT * FROM users WHERE id=" . $_SESSION['id']) > 0);
}

function check_posli_kontakt() {
    return ((isset($_POST['kontakt'])) && spravny_text('kontakt', MIN_TEXT, MAX_BIGTEXT));
}

/***************************************
 **       KONTROLA EXISTENCIE         ******************************************************************************************************************************************************************
 ***************************************/

function username_uz_existuje($username) {
    $username = addslashes(htmlspecialchars(strip_tags(trim($username)), ENT_QUOTES));
    $pocet_users = pocet_zaznamov("SELECT * FROM users WHERE LOWER(username)='" . strtolower($username) . "'");
    $pocet_nepotvrdenych_users = pocet_zaznamov("SELECT * FROM nepotvrdeny_users WHERE LOWER(username)='" . strtolower($username) . "'");
    return (($pocet_users > 0) || ($pocet_nepotvrdenych_users > 0)) ? true : false;
}

function mail_uz_existuje($mail) {
    $mail = addslashes(htmlspecialchars(strip_tags(trim($mail)), ENT_QUOTES));
    $pocet_users = pocet_zaznamov("SELECT * FROM users WHERE LOWER(mail)='" . strtolower($mail) . "' OR LOWER(zm_mail)='" . strtolower($mail) . "'");
    $pocet_nepotvrdenych_users = pocet_zaznamov("SELECT * FROM nepotvrdeny_users WHERE LOWER(mail)='" . strtolower($mail) . "'");
    //$pocet_zmena_mailu_users = pocet_zaznamov("SELECT * FROM users WHERE LOWER(zm_mail)='" . strtolower($mail) . "'");
    return (($pocet_users > 0) || ($pocet_nepotvrdenych_users > 0)) ? true : false;
}

function film_uz_existuje_v_db($film, $rok_vydania) {
    $film = addslashes(htmlspecialchars(strip_tags(trim($film)), ENT_QUOTES));
    $rok_vydania = addslashes(htmlspecialchars(strip_tags(trim($rok_vydania)), ENT_QUOTES));
    $pocet_filmov = pocet_zaznamov("SELECT * FROM film_public WHERE LOWER(original_name)='" . strtolower($film) . "' AND vydanie=" . $rok_vydania);
    return ($pocet_filmov > 0) ? true : false;
}

function film_uz_existuje_u_vas($film, $rok_vydania) {
    $film = addslashes(htmlspecialchars(strip_tags(trim($film)), ENT_QUOTES));
    $rok_vydania = addslashes(htmlspecialchars(strip_tags(trim($rok_vydania)), ENT_QUOTES));
    $pocet_filmov = pocet_zaznamov("SELECT * FROM film_public, film_private WHERE LOWER(original_name)='" . strtolower($film) . "' AND film_public.id = film_private.id_film AND film_private.id_user=" . $_SESSION['id'] . " AND vydanie=" . $rok_vydania);
    return ($pocet_filmov > 0) ? true : false;
}

function nazov_skupiny_uz_existuje($name, $povodne_meno = '') {
    if ($povodne_meno == $name)
        return false;
    $name = addslashes(htmlspecialchars(strip_tags(trim($name)), ENT_QUOTES));
    return (pocet_zaznamov("SELECT * FROM skupiny WHERE id_user=" . $_SESSION['id'] . " AND name='" . $name . "'") > 0);
}

/***************************************
 **         PRACA SO SUBORMI          ******************************************************************************************************************************************************************
 ***************************************/

function delete_all_in_directory($dirname) {
    if (is_dir($dirname)) {
        $dir_handle = opendir($dirname);
        if (!$dir_handle)
            return false;
        while ($file = readdir($dir_handle)) {
            if ($file != "." && $file != "..") {
                if (!is_dir($dirname . "/" . $file))
                    unlink($dirname . "/" . $file);
                else
                    delete_directory($dirname . '/' . $file);
            }
        }
        closedir($dir_handle);
        return true;
    } else
        return false;
}

/***************************************
 **            VYPISOVANIE            ******************************************************************************************************************************************************************
 ***************************************/

function vypis_vek($dn) {
    $poz = strpos($dn, '.');
    $den = substr($dn, 0, $poz);
    $dn = substr($dn, $poz + 1);
    $poz = strpos($dn, '.');
    $mesiac = substr($dn, 0, $poz);
    $dn = substr($dn, $poz + 1);
    $vysledok = (date("Y") - $dn);
    if (((date("n") - $mesiac) >= 0) && ((date("j") - $den) >= 0))
        return $vysledok;
    else
        return ($vysledok - 1);
}

function vypis_cas($minut) {
    $hodin = $dni = 0;
    if ($minut / 60 >= 1) {
        $hodin = round($minut / 60);
        $minut %= 60;
        if ($hodin / 24 >= 1) {
            $dni = round($hodin / 24);
            $hodin %= 24;
        }
    }
    if ($dni == 1)
        $dni .= ' deň';
    elseif ($dni == 2 || $dni == 3 || $dni == 4)
        $dni .= ' dni';
    else
        $dni .= ' dní';
    if ($hodin == 1)
        $hodin .= ' hodina';
    elseif ($hodin == 2 || $hodin == 3 || $hodin == 4)
        $hodin .= ' hodiny';
    else
        $hodin .= ' hodín';
    if ($minut == 1)
        $minut .= ' minúta';
    elseif ($minut == 2 || $minut == 3 || $minut == 4)
        $minut .= ' minuty';
    else
        $minut .= ' minút';
    return $dni . '<br />' . $hodin . '<br />' . $minut;
}

function vypis_select($select_name, $zaznamov, $session) {
    ?><select id="<?php echo $select_name; ?>"><?php
    for ($i = 0; $i < $zaznamov; $i++) {
        echo "<option value='" . $i . "'";
        if ($i == $_SESSION[$session . '_strana'])
            echo ' selected="selected"';
        echo ">" . ($i + 1) . "</option>\n";
    }
    ?></select><?php
}

function vypis_viac_veci_z_jedneho($co) {
    $res = '';
    $poc = 0;
    $setM = array();
    while (strpos($co, '@') !== false) {
        $poz = strpos($co, '@');
        $setM[] = substr($co, 0, $poz);
        $co = substr($co, $poz + 1);
    }
    sort($setM);
    foreach ($setM as $value) {
        if ($poc > 0)
            $res .= ', ';
        $res .= $value;
        $poc++;
    }
    return $res;
}

function vypis_th_zoradovanie($session, $id, $title, $in_th) {
    $result = '<th id="' . $id . '" title="' . $title . '">' . $in_th . ' ';
    $is_ordered = ($_SESSION[$session . '_order_by'] == $id);
    $result .= ($is_ordered && $_SESSION[$session . '_order_how'] == 'ASC') ? '<img src="obrazky/up.png" alt="Vzostupné zoradenie" title="Vzostupné zoradenie" width="18" height="18" />' : '';
    $result .= ($is_ordered && $_SESSION[$session . '_order_how'] == 'DESC') ? '<img src="obrazky/down.png" alt="Vzostupné zoradenie" title="Vzostupné zoradenie" width="18" height="18" />' : '';
    $result .= '</th>';
    return $result;
}

/***************************************
 **                MAIL               ******************************************************************************************************************************************************************
 ***************************************/

function posli_mail($mail, $predmet, $sprava) {
    mb_language('Neutral');
    mb_internal_encoding("UTF-8");
    mb_http_input("UTF-8");
    mb_http_output("UTF-8");
    mb_send_mail($mail, $predmet, $sprava, 'From: "Filmový Portál - no reply" <no-reply@' . WEB . '>');
}

/***************************************
 **            SQL - FILMY            ******************************************************************************************************************************************************************
 ***************************************/

function sprav_sql_PrivateInfo($pridat, $kompletne_pridanie, $id_film) {
    $medium = (isset($_POST['medium_r']) && ($_POST['medium_r'] == 'v_select')) ? $_POST['select_medium'] : $_POST['input_medium'];
    $rozlisenie = (isset($_POST['rozlisenie_r']) && ($_POST['rozlisenie_r'] == 'v2_select')) ? $_POST['select_rozlisenie'] : $_POST['input_rozlisenie'];
    $zvuk = (isset($_POST['zvuk_r']) && ($_POST['zvuk_r'] == 'v4_select')) ? $_POST['select_zvuk'] : $_POST['input_zvuk'];
    $titulky = (isset($_POST['titulky_r']) && ($_POST['titulky_r'] == 'v5_select')) ? $_POST['select_titulky'] : $_POST['input_titulky'];
    $velkost = (isset($_POST['velkost_r']) && ($_POST['velkost_r'] == 'v3_select')) ? $_POST['select_velkost'] : $_POST['spinn_velkost'];
    $sql_1 = ($pridat) ? 'INSERT INTO ' : 'UPDATE ';
    $sql_2 = "film_private SET  medium='" . $medium . "', 
                              rozlisenie='" . $rozlisenie . "', 
                              zvuk='" . $zvuk . "', 
                              titulky='" . $titulky . "', 
                              bonusy='" . $_POST['bonusy'] . "', 
                              velkost='" . $velkost . "', 
                              umiestnenie='" . $_POST['umiestnenie'] . "', 
                              pozreti='" . $_POST['pozreti'] . "', 
                              vlastne_hodnotenie='" . $_POST['vlastne_hodnotenie'] . "', 
                              komentar='" . $_POST['komentar'] . "', 
                              poznamky='" . $_POST['poznamky'] . "', 
                              timestamp=" . time();
    $sql_3 = ($pridat) ? ', id_film=' . $id_film . ', id_user=' . $_SESSION['id'] : ' WHERE id_film=' . $id_film . ' AND id_user=' . $_SESSION['id'];
    $sql = $sql_1 . $sql_2 . $sql_3;    
    if (sprav_dotaz($sql)) {        
        unset_pridaj_film();
        if ($kompletne_pridanie)
            presmeruj_na_stranku("uprav_obal.php?id=" . $id_film . "&p=1");
        else
            presmeruj_na_stranku('db.php');
    }
}

/***************************************
 **           STRANKOVANIE            ******************************************************************************************************************************************************************
 ***************************************/

function pocet_stran_zaznamov($sql, $pocet) {
    if (is_numeric($sql)) $zaznamov = $sql;
    else $zaznamov = pocet_zaznamov($sql);
    if ($pocet == 0)
        return 0;
    $zaznamov = ceil($zaznamov / $pocet);
    return $zaznamov;
}

function pocet_zaznamov($sql) {
    $zaznamov = 0;
    if ($link1 = spoj_s_db()) {
        $result1 = mysql_query($sql, $link1); // vykonaj dotaz
        if ($result1) {
            // dotaz sa podarilo vykonať    			
            $zaznamov = mysql_num_rows($result1);
            mysql_free_result($result1);
        }
        mysql_close($link1);
    } else {
        // NEpodarilo sa spojiť s databázovým serverom!
    }
    return $zaznamov;
}

function vypis_strany($nazov_select, $sql, $session, $viac = '') {
    $stran_zaznamov = pocet_stran_zaznamov($sql, $_SESSION[$session . '_pocet_strana']);
    ?><p><?php
    if ($_SESSION[$session . '_strana'] != 0) {
        ?><img id="prva_strana<?php echo $viac; ?>" class="sipka" name="prva" src="obrazky/go_first.png" title="Prejdi na prvú stranu" alt="go first" style="cursor: pointer" />       
            <img id="predchadzajuca_strana<?php echo $viac; ?>" class="sipka" name="predchadzajuca" src="obrazky/go_previous.png" title="Prejdi na predchádzajúcu stranu" alt="go previous" style="cursor: pointer" /><?php
    }
    ?> Strana č. <?php
    vypis_select($nazov_select, $stran_zaznamov, $session);
    ?> z <?php echo $stran_zaznamov; ?> strán <?php
    if ($_SESSION[$session . '_strana'] != $stran_zaznamov - 1) {
        ?><img id="nasledujuca_strana<?php echo $viac; ?>" class="sipka" name="nasledujuca" src="obrazky/go_next.png" title="Prejdi na nasledujúcu stranu" alt="go next" style="cursor: pointer" />
            <img id="posledna_strana<?php echo $viac; ?>" class="sipka" name="posledna" src="obrazky/go_last.png" title="Prejdi na poslednú stranu" alt="go last" style="cursor: pointer" /><?php
    }
    ?></p><?php
}

function vypis_pocet_zaznamov_na_stranu($select_name, $session) {
    ?><p>Počet záznamov na stranu: 
        <select id="<?php echo $select_name; ?>">   
            <option value="5" <?php if ($_SESSION[$session . '_pocet_strana'] == 5) echo 'selected="selected"'; ?>>5</option>
            <option value="10" <?php if ($_SESSION[$session . '_pocet_strana'] == 10) echo 'selected="selected"'; ?>>10</option>
            <option value="15" <?php if ($_SESSION[$session . '_pocet_strana'] == 15) echo 'selected="selected"'; ?>>15</option>
            <option value="20" <?php if ($_SESSION[$session . '_pocet_strana'] == 20) echo 'selected="selected"'; ?>>20</option>
            <option value="25" <?php if ($_SESSION[$session . '_pocet_strana'] == 25) echo 'selected="selected"'; ?>>25</option>
            <option value="50" <?php if ($_SESSION[$session . '_pocet_strana'] == 50) echo 'selected="selected"'; ?>>50</option>		
        </select></p><?php
}

/***************************************
 **        ZOBRAZENIE FILMU           ******************************************************************************************************************************************************************
 ***************************************/

function zobraz_film() {    
    $row = daj_udaje_z_db("SELECT * FROM film_private,film_public WHERE id_user=" . $_SESSION['id'] . " AND film_private.id_film=film_public.id AND id_film=" . $_GET['id']);
    ?><div id="film_vpravo">    
        <p title="oficiálne hodnotenie"><?php echo $row['hodnotenie']; ?>%</p>      
        <p title="vlastné hodnotenie"><?php echo $row['vlastne_hodnotenie']; ?>%</p>
        <p title="počet pozretí" id="pocet_pozreti"><?php echo $row['pozreti']; ?>x                                                                                                                                                             <!-- pridajPozretie('.$row["pozreti"].', '.$row["id_film"].') -->
            <img style="cursor: pointer" width="32" height="32" src="obrazky/plus.png" title="Pridať pozretie" alt="Pridať" onclick="javascript:event.cancelBubble=true;pridajPozretieZobrazFilm(<?php echo $row['pozreti']; ?>, <?php echo $_GET['id']; ?>)" /></p>
    </div>
    <h2><?php echo $row['original_name']; ?> (<?php echo $row['cs_name']; ?>)&nbsp;&nbsp;<a href="uprav_film.php?id=<?php echo $_GET['id']; ?>"><img width="32" height="32" src="obrazky/edit.png" title="Uprav film" alt="Upraviť" /></a>
    <a href="delete_film.php?id=<?php echo $_GET['id']; ?>"><img width="32" height="32" src="obrazky/delete.png" title="Vymaž film" alt="Vymazať" /></a><?php
    if (pocet_zaznamov("SELECT * FROM film_private WHERE id_user=" . $_SESSION['id'] . " AND id_film=" . $_GET['id']) > 0 && (!(isset($_SESSION['admin']) || isset($_SESSION['superadmin'])))) {
        ?>&nbsp;<a href="poziadavka_zmena_public.php?film_id=<?php echo $_GET['id']; ?>"><img width="32" height="32" src="obrazky/change.png" title="Vytvoriť požiadavku na zmenu verejných informácii filmu" alt="Požiadavka na zmenu" /></a><?php
    }    
    if (pocet_zaznamov("SELECT * FROM skupiny WHERE id_user = " . $_SESSION['id'] . "  AND id > 0") > 0) {
        ?> <img id="nastav_viditelnost" alt="Nastav viditeľnosť tohto filmu pre skupiny" src="obrazky/eye.png" title="Nastav viditeľnosť tohto filmu pre skupiny" width="32" height="32" style="cursor: pointer" /> <?php
        if ($_SESSION['rozbalene_filmy']) {
            ?><span id="span_see" style="display: inline"><?php
        } else {
            ?><span id="span_see" style="display: none"><?php
        }
        ?><select name="select_viditelnost" id="select_viditelnost"><?php
        if ($link = spoj_s_db()) {
            $sql = "SELECT id, name FROM skupiny WHERE id_user = " . $_SESSION['id'] . "  AND id > 0 ORDER BY name ASC";
            $result = mysql_query($sql, $link); // vykonaj dotaz
            if ($result) {            
                while ($row_select = mysql_fetch_assoc($result)) {
                    ?><option value="<?php echo $row_select['id']; ?>"><?php echo $row_select['name']; ?></option><?php
                }
                mysql_free_result($result);
            }
            mysql_close($link);
        }
        ?></select><?php 
        //$pom1 = 'checked="checked"';
        echo input('checkbox', 'viditelnost', 0, 0, '');
        ?> <img class="update" alt="Potvrď zmenu viditeľnosti tohto filmu pre vybranú skupinu" src="obrazky/ano.png" title="Potvrď zmenu viditeľnosti tohto filmu pre vybranú skupinu" width="20" height="20" style="cursor: pointer" /> </span><?php
    }
    ?>
    </h2>
    <img class="obal" src="<?php echo $row['obal']; ?>" width="200" height="250" alt="Obal filmu" title="Obal filmu" />
    <h4><?php echo $row['vydanie']; ?>, <?php echo $row['minutaz']; ?> minút</h4>
    <div id="film_obsah">
        <table>
            <tr><th>Zvuk</th><td><?php echo $row['zvuk']; ?></td></tr>
            <tr><th>Titulky</th><td><?php echo $row['titulky']; ?></td></tr>
            <tr><th>Bonusy</th><td><?php echo $row['bonusy']; ?></td></tr>
            <tr><th>Veľkosť</th><td><?php echo $row['velkost']; ?></td></tr>
            <tr><th>Rozlíšenie</th><td><?php echo $row['rozlisenie']; ?></td></tr>
            <tr><th>Médium</th><td><?php echo $row['medium']; ?></td></tr>
            <tr><th>Umiestnenie</th><td><?php echo $row['umiestnenie']; ?></td></tr>
        </table>
    </div>
    <div id="film_obsah2">  
        <table>
            <tr><th>Miesta natáčania</th><td><?php echo vypis_viac_veci_z_jedneho($row['natacanie']); ?></td></tr>
            <tr><th>Žáner</th><td><?php echo vypis_viac_veci_z_jedneho($row['zaner']); ?></td></tr>
            <tr><th>Režiséri</th><td><?php echo vypis_viac_veci_z_jedneho($row['reziser']); ?></td></tr>
            <tr><th>Herci</th><td><?php echo vypis_viac_veci_z_jedneho($row['herci']); ?></td></tr>
            <tr><th>Obsah</th><td><?php echo $row['obsah']; ?></td></tr>
            <tr><th>Komentár</th><td><?php echo $row['komentar']; ?></td></tr>
            <tr><th>Poznámky</th><td><?php echo $row['poznamky']; ?></td></tr> 
        </table><?php
    echo button('go_back', 'Naspäť na zoznam filmov', '', 'onclick="javascript:window.location.href=\'db.php\'"');
    ?></div><?php
}

function zobraz_film_info() {
    $row = daj_udaje_z_db("SELECT * FROM film_public WHERE id=" . $_GET['id']);
    ?><div id="film_vpravo">    
        <p title="oficiálne hodnotenie"><?php echo $row['hodnotenie']; ?>%</p> 
        <p style="display: none"></p>
    </div>
    <h2><?php echo $row['original_name']; ?> (<?php echo $row['cs_name']; ?>)<?php
    if (isset($_SESSION['admin']) || isset($_SESSION['superadmin'])) {
        ?>&nbsp;&nbsp;<a href="administracia.php?film_id=<?php echo $_GET['id']; ?>"><img width="32" height="32" src="obrazky/edit.png" title="Uprav film" alt="Upraviť" /></a>&nbsp;<a href="administracia.php?delete_film=<?php echo $_GET['id']; ?>"><img width="32" height="32" src="obrazky/delete.png" title="Vymaž film" alt="Vymazať" /></a><?php
    }
    if (pocet_zaznamov("SELECT * FROM film_private WHERE id_user=" . $_SESSION['id'] . " AND id_film=" . $_GET['id']) == 0) {
        ?>&nbsp;<a href="pridaj_film2.php?id=<?php echo $_GET['id']; ?>"><img width="32" height="32" src="obrazky/plus.png" title="Pridať film do vlastnej databázy" alt="Pridať" /></a><?php
    }
    if (pocet_zaznamov("SELECT * FROM film_private WHERE id_user=" . $_SESSION['id'] . " AND id_film=" . $_GET['id']) > 0 && (!(isset($_SESSION['admin']) || isset($_SESSION['superadmin'])))) {
        ?>&nbsp;<a href="poziadavka_zmena_public.php?film_id=<?php echo $_GET['id']; ?>"><img width="32" height="32" src="obrazky/change.png" title="Vytvoriť požiadavku na zmenu verejných informácii filmu" alt="Požiadavka na zmenu" /></a><?php
    }
    if (pocet_zaznamov("SELECT * FROM film_private WHERE id_user=" . $_SESSION['id'] . " AND id_film=" . $_GET['id']) == 0) {
        ?>&nbsp;<a href="pozicanie_filmu.php?id=<?php echo $_GET['id']; ?>&amp;rebricek"><img width="32" height="32" src="obrazky/pozicat.png" title="Požičať si tento film" alt="Požiadavka na požíčanie filmu" /></a><?php
    }
    ?></h2>
    <img class="obal" src="<?php echo $row['obal']; ?>" width="200" height="250" alt="Obal filmu" title="Obal filmu" />
    <h4><?php echo $row['vydanie']; ?>, <?php echo $row['minutaz']; ?> minút</h4>
    <div id="film_obsah">  
        <table>
            <tr><th>Miesta natáčania</th><td><?php echo vypis_viac_veci_z_jedneho($row['natacanie']); ?></td></tr>
            <tr><th>Žáner</th><td><?php echo vypis_viac_veci_z_jedneho($row['zaner']); ?></td></tr>
            <tr><th>Režiséri</th><td><?php echo vypis_viac_veci_z_jedneho($row['reziser']); ?></td></tr>
            <tr><th>Herci</th><td><?php echo vypis_viac_veci_z_jedneho($row['herci']); ?></td></tr>
            <tr><th>Obsah</th><td><?php echo $row['obsah']; ?></td></tr>
        </table><?php
    if (isset($_SESSION['admin']) || isset($_SESSION['superadmin'])) {
        ?></div>
        <div id="film_obsah2">  
            <table>
                <tr><th>Dátum pridania</th><td><?php echo date('d.m.Y H:i:s', $row['timestamp']); ?></td></tr>
                <tr><th>Dátum posl. zmeny</th><td><?php echo date('d.m.Y H:i:s', $row['ts_zmena']); ?></td></tr> 
            </table>
            <h3>Požiadavky na zmenu</h3><?php
            if (pocet_zaznamov("SELECT * FROM zmena_filmu WHERE id_film=" . $_GET['id'] . " ORDER BY timestamp DESC") == 0) {
                echo '<p>Na tento film nebola vytvorená žiadna požiadavka.</p>';
            }
            else {
                ?><table>
                    <tr><th></th><th>Username</th><th>Názov filmu</th><th>Dátum podania požiadavky</th></tr><?php
                    if ($link = spoj_s_db()) {
                        $sql = "SELECT * FROM zmena_filmu WHERE id_film=" . $_GET['id'] . " ORDER BY timestamp DESC";
                        $result = mysql_query($sql, $link); // vykonaj dotaz
                        if ($result) {
                            // dotaz sa podarilo vykonať                       
                            $i = 0;
                            while ($row = mysql_fetch_assoc($result)) {
                                $i++;
                                $user = daj_udaje_z_db("SELECT username FROM users WHERE id=" . $row['id_user']);
                                $nazov = daj_udaje_z_db("SELECT original_name FROM film_public WHERE id=" . $row['id_film']);
                                ?><tr>
                                        <td><?php echo $i; ?>.</td>
                                        <td><?php echo $user['username']; ?></td>
                                        <td><?php echo $nazov['original_name']; ?></td>
                                        <td><?php echo date('d.m.Y H:i:s', $row['timestamp']); ?></td>                                    
                                </tr><?php
                            }
                            ?></table><?php
                            mysql_free_result($result);
                        }
                        mysql_close($link);
                    } else {
                        // NEpodarilo sa spojiť s databázovým serverom!
                    }                
                ?></table><?php
            }
    }
    echo button('go_back', 'Naspäť na rebríček', '', 'onclick="javascript:window.location.href=\'rebricek.php\'"');
    ?></div><?php
}

function zobraz_film_view() {
    $row = daj_udaje_z_db("SELECT * FROM film_private,film_public WHERE id_user=" . $_GET['idu'] . " AND film_private.id_film=film_public.id AND id_film=" . $_GET['idf']);
    if (pocet_zaznamov("SELECT * FROM skupiny sk, skupina_users su WHERE sk.id=su.id_skupina AND sk.id_user=" . $_GET['idu'] . " AND su.id_user=" . $_SESSION['id']) > 0) 
        $zdielanie = daj_udaje_z_db("SELECT * FROM skupiny sk, skupina_users su WHERE sk.id=su.id_skupina AND sk.id_user=" . $_GET['idu'] . " AND su.id_user=" . $_SESSION['id']);            
    else 
        $zdielanie = daj_udaje_z_db("SELECT * FROM skupiny WHERE id=0"); 
    $moj_profil = ($_GET['idu'] == $_SESSION['id']);
    ?><div id="film_vpravo">    
        <p title="oficiálne hodnotenie"><?php echo $row['hodnotenie']; ?>%</p>      
        <p title="vlastné hodnotenie"><?php echo ($moj_profil || $zdielanie['vlastne_hodnotenie']) ? $row['vlastne_hodnotenie'] : '?'; ?>%</p>        
    </div>
    <h2><?php echo $row['original_name']; ?> (<?php echo $row['cs_name']; ?>)</h2>
    <img class="obal" src="<?php echo $row['obal']; ?>" width="200" height="250" alt="Obal filmu" title="Obal filmu" />
    <h4><?php echo $row['vydanie']; ?>, <?php echo $row['minutaz']; ?> minút</h4>
    <div id="film_obsah">
        <table>
            <tr><th>Zvuk</th><td><?php echo ($moj_profil || $zdielanie['zvuk']) ? $row['zvuk'] : ''; ?></td></tr>
            <tr><th>Titulky</th><td><?php echo ($moj_profil || $zdielanie['titulky']) ? $row['titulky'] : ''; ?></td></tr>
            <tr><th>Bonusy</th><td><?php echo ($moj_profil || $zdielanie['bonusy']) ? $row['bonusy'] : ''; ?></td></tr>
            <tr><th>Veľkosť</th><td><?php echo ($moj_profil || $zdielanie['velkost']) ? $row['velkost'] : ''; ?></td></tr>
            <tr><th>Rozlíšenie</th><td><?php echo ($moj_profil || $zdielanie['rozlisenie']) ? $row['rozlisenie'] : ''; ?></td></tr>
            <tr><th>Médium</th><td><?php echo ($moj_profil || $zdielanie['medium']) ? $row['medium'] : ''; ?></td></tr>
            <tr><th>Umiestnenie</th><td><?php echo ($moj_profil || $zdielanie['umiestnenie']) ? $row['umiestnenie'] : ''; ?></td></tr>
        </table>
    </div>
    <div id="film_obsah2">  
        <table>
            <tr><th>Miesta natáčania</th><td><?php echo vypis_viac_veci_z_jedneho($row['natacanie']); ?></td></tr>
            <tr><th>Žáner</th><td><?php echo vypis_viac_veci_z_jedneho($row['zaner']); ?></td></tr>
            <tr><th>Režiséri</th><td><?php echo vypis_viac_veci_z_jedneho($row['reziser']); ?></td></tr>
            <tr><th>Herci</th><td><?php echo vypis_viac_veci_z_jedneho($row['herci']); ?></td></tr>
            <tr><th>Obsah</th><td><?php echo $row['obsah']; ?></td></tr>
            <tr><th>Komentár</th><td><?php echo ($moj_profil || $zdielanie['komentar']) ? $row['komentar'] : ''; ?></td></tr>
            <tr><th>Poznámky</th><td><?php echo ($moj_profil || $zdielanie['poznamky']) ? $row['poznamky'] : ''; ?></td></tr> 
        </table><?php
    echo button('go_back', 'Naspäť na zoznam filmov', '', 'onclick="javascript:window.location.href=\'db_view.php?id=' . $_GET['idu'] . '\'"');
    ?></div><?php
}

function rebricek_odkazy() {
    ?><p><a href="rebricek.php?variant=1" title="100 najlepších filmov podľa oficiálnych hodnotení">100 najlepších filmov podľa oficiálnych hodnotení</a></p>
    <p><a href="rebricek.php?variant=2" title="100 najlepších filmov podľa priemerných hodnotení použivateľov">100 najlepších filmov podľa priemerných hodnotení použivateľov</a></p><hr><?php
}

function rebricek($variant) {
    ?><p class="zvyraznene">100 najlepších filmov podľa <?php echo ($variant == 1) ? 'oficiálnych hodnotení' : 'priemerných hodnotení použivateľov'; ?></p><table><?php
    if ($link = spoj_s_db()) {
        $sql = ($variant == 1) ? "SELECT * FROM film_public ORDER BY hodnotenie DESC LIMIT 0, 100" : "SELECT original_name, cs_name, vydanie, AVG(vlastne_hodnotenie) AS priemer FROM film_private, film_public WHERE film_public.id = film_private.id_film GROUP BY id_film ORDER BY vlastne_hodnotenie DESC LIMIT 0, 100";
        $result = mysql_query($sql, $link); // vykonaj dotaz
        if ($result) {
            // dotaz sa podarilo vykonať
            ?><table><tr>
                            <th></th>
                            <th>Originálny názov</th>
                            <th>Český / slovenský názov</th>
                            <th>Rok vydania</th>
                            <th><?php echo ($variant == 1) ? 'Oficiálne hodnotenie' : 'Priemerné hodnotenie používateľov'; ?></th>
                        </tr><?php
            $i = 0;
            while ($row = mysql_fetch_assoc($result)) {
                $i++;
                ?><tr class="obsah_tab">
                                <td><?php echo $i; ?>.</td>
                                <td><?php echo $row['original_name']; ?></td>
                                <td><?php echo $row['cs_name']; ?></td>
                                <td><?php echo $row['vydanie']; ?></td>
                                <td><?php echo ($variant == 1) ? $row['hodnotenie'] : round($row['priemer']); ?> %</td>         				  
                            </tr><?php
            }
            ?></table><?php
            mysql_free_result($result);
        }
        mysql_close($link);
    } else {
        // NEpodarilo sa spojiť s databázovým serverom!
    }
    ?></table><?php
}

/***************************************
 **                INE                ******************************************************************************************************************************************************************
 ***************************************/

function random_gen($length, $salt = false) {
    $random = "";
    srand((double) microtime() * 1000000);
    $char_list = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    $char_list .= "abcdefghijklmnopqrstuvwxyz";
    $char_list .= "1234567890";
    if ($salt) 
        $char_list .= "!@#$%&*?";
    for ($i = 0; $i < $length; $i++)
        $random .= substr($char_list, (rand() % (strlen($char_list))), 1);
    return $random;
}

function hash_heslo($salt, $username, $pass) {
    $heslo = substr($pass, 0, 2) . $username . substr($pass, 2) . $salt;
    $heslo = hash('sha256', $heslo);
    return $heslo;
}

/***************************************
 **            JS FUNKCIE             ******************************************************************************************************************************************************************
 ***************************************/

function presmeruj_na_stranku($kam) {
?><script type="text/javascript"> window.location.href = '<?php echo $kam; ?>'; </script><?php
}

function stringToJS($string) {
    $string = str_replace(chr(13), '\r', $string);
    return str_replace(chr(10), '\n', $string);
}

function rozbehni_js_na_zaciatku($ktore) { // 1 - registracia, 2 - uprav profil, 3 - uprav mail, 4 - uprav heslo, 5 - pred pridaj film, 6 - pridaj film, 7 - pridaj film (len sukr cast) 
    switch ($ktore) {
        case 1:   // REGISTRACIA
            ?><script type="text/javascript">
                        s(<?php echo (isset($_POST['pohlavie'])) ? 1 : 0 ?>,'pohlavie_obr',8,0,0);
                        s(0,'potvrdenie_obr',8,0,0);
                        s('<?php echo (isset($_POST['username'])) ? $_POST['username'] : '' ?>','username_obr',1,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                        s('','pass_obr',1,<?php echo MIN_HESLO; ?>,<?php echo MAX_HESLO; ?>);
                        s('','pass2_obr',1,<?php echo MIN_HESLO; ?>,<?php echo MAX_HESLO; ?>);
                        s('<?php echo (isset($_POST['meno'])) ? $_POST['meno'] : '' ?>','meno_obr',5,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                        s('<?php echo (isset($_POST['priezvisko'])) ? $_POST['priezvisko'] : '' ?>','priezvisko_obr',5,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                        s('<?php echo (isset($_POST['mail'])) ? $_POST['mail'] : '' ?>','mail_obr',2,<?php echo MIN_MAIL; ?>,<?php echo MAX_TEXT; ?>);
                        s('<?php echo (isset($_POST['kraj'])) ? $_POST['kraj'] : '' ?>','kraj_obr',0,0,0);
                        s('<?php echo (isset($_POST['zamestnanie'])) ? $_POST['zamestnanie'] : '' ?>','zamestnanie_obr',5,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                        s('<?php echo (isset($_POST['telefon'])) ? $_POST['telefon'] : '' ?>','telefon_obr',0,0,0);
                        s('<?php echo (isset($_POST['datum_narodenia'])) ? $_POST['datum_narodenia'] : '' ?>','datum_narodenia_obr',0,0,0);
                        s('<?php echo (isset($_POST['fav_film'])) ? $_POST['fav_film'] : '' ?>','fav_film_obr',5,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                        s('<?php echo (isset($_POST['fav_actor'])) ? $_POST['fav_actor'] : '' ?>','fav_actor_obr',5,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                        s('<?php echo (isset($_POST['fav_zaner'])) ? $_POST['fav_zaner'] : '' ?>','fav_zaner_obr',5,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                        s('<?php echo (isset($_POST['zaluby'])) ? $_POST['zaluby'] : '' ?>','zaluby_obr',5,<?php echo MIN_TEXT; ?>,<?php echo MAX_BIGTEXT; ?>);
            </script><?php
        break;
        case 2:   // UPRAV PROFIL
            $row = daj_udaje_z_db("SELECT * FROM users WHERE id=" . $_SESSION['id']);
            ?><script type="text/javascript">
                            s('<?php echo (isset($_POST['meno'])) ? $_POST['meno'] : $row['meno']; ?>','meno_obr',5,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                            s('<?php echo (isset($_POST['priezvisko'])) ? $_POST['priezvisko'] : $row['priezvisko']; ?>','priezvisko_obr',5,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                            s('<?php echo (isset($_POST['kraj'])) ? $_POST['kraj'] : $row['kraj']; ?>','kraj_obr',0,0,0);
                            s('<?php echo (isset($_POST['zamestnanie'])) ? $_POST['zamestnanie'] : $row['zamestnanie']; ?>','zamestnanie_obr',5,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                            s('<?php echo (isset($_POST['telefon'])) ? $_POST['telefon'] : $row['telefon']; ?>','telefon_obr',0,0,0);
                            s('<?php echo (isset($_POST['datum_narodenia'])) ? $_POST['datum_narodenia'] : $row['datum_narodenia']; ?>','datum_narodenia_obr',0,0,0);
                            s('<?php echo (isset($_POST['fav_film'])) ? $_POST['fav_film'] : $row['fav_film']; ?>','fav_film_obr',5,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                            s('<?php echo (isset($_POST['fav_actor'])) ? $_POST['fav_actor'] : $row['fav_actor']; ?>','fav_actor_obr',5,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                            s('<?php echo (isset($_POST['fav_zaner'])) ? $_POST['fav_zaner'] : $row['fav_zaner']; ?>','fav_zaner_obr',5,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                            s('<?php echo (isset($_POST['zaluby'])) ? $_POST['zaluby'] : $row['zaluby']; ?>','zaluby_obr',5,<?php echo MIN_TEXT; ?>,<?php echo MAX_BIGTEXT; ?>);                             
                </script><?php
            break;
        case 3:   // UPRAV MAIL
            $row = daj_udaje_z_db("SELECT * FROM users WHERE id=" . $_SESSION['id']);
            ?><script type="text/javascript">
                            s('<?php echo (isset($_POST['mail'])) ? $_POST['mail'] : $row['mail']; ?>','mail_obr',2,5,<?php echo MAX_TEXT; ?>);        
                </script><?php
            break;
        case 4:   // UPRAV HESLO
            ?><script type="text/javascript">
                            s('','pass_obr',1,<?php echo MIN_HESLO; ?>,<?php echo MAX_HESLO; ?>);
                            s('','pass2_obr',1,<?php echo MIN_HESLO; ?>,<?php echo MAX_HESLO; ?>);
                            s('','heslo_obr',1,<?php echo MIN_HESLO; ?>,<?php echo MAX_HESLO; ?>);
                </script><?php
            break;
        case 5:   // PRED PRIDAJ FILM
            ?><script type="text/javascript">
                            s('<?php echo (isset($_POST['orig_name'])) ? $_POST['orig_name'] : '' ?>','orig_name_obr',1,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                            s('','rok_vydania_obr',0,0,0);
                            s('','pocet_reziserov_obr',0,0,0);
                            s('','pocet_hercov_obr',0,0,0);
                            s('','pocet_zanrov_obr',0,0,0);
                            s('','pocet_natacani_obr',0,0,0);
                </script><?php
            break;
        case 6:   // PRIDAJ FILM        
            ?><script type="text/javascript">
                            //s('','original_name_obr',0,0,0);
                            s('<?php echo (isset($_POST['cs_name'])) ? $_POST['cs_name'] : '' ?>','cs_name_obr',1,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                            s('<?php echo (isset($_POST['obsah'])) ? $_POST['obsah'] : '' ?>','obsah_obr',1,<?php echo MIN_TEXT; ?>,<?php echo MAX_HUGETEXT; ?>);
                            s('','minutaz_obr',0,0,0);
                            //s('','vydanie_obr',0,0,0);
                            s('','hodnotenie_obr',0,0,0);
                            s('<?php echo (isset($_POST['komentar'])) ? $_POST['komentar'] : '' ?>','komentar_obr',5,<?php echo MIN_TEXT; ?>,<?php echo MAX_BIGTEXT; ?>);
                            s('<?php echo (isset($_POST['poznamky'])) ? $_POST['poznamky'] : '' ?>','poznamky_obr',5,<?php echo MIN_TEXT; ?>,<?php echo MAX_BIGTEXT; ?>);
                            s('','pozreti_obr',0,0,0);
                            s('','vlastne_hodnotenie_obr',0,0,0);
                            s('<?php echo (isset($_POST['select_zvuk'])) ? $_POST['select_zvuk'] : '-' ?>','select_zvuk_obr',0,0,0);
                            s('<?php echo (isset($_POST['select_titulky'])) ? $_POST['select_titulky'] : '-' ?>','select_titulky_obr',0,0,0);
                            s('','bonusy_obr',0,0,0);
                            s('<?php echo (isset($_POST['umiestnenie'])) ? $_POST['umiestnenie'] : '' ?>','umiestnenie_obr',5,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                </script><?php
            $r = ($_SESSION['zan'] == 1) ? 0 : 999;
            for ($i = 1; $i <= $_SESSION['zan']; $i++) {
                $p = "zaner" . $i;
                ?><script type="text/javascript">
                                    s('<?php echo (isset($_POST["zaner" . $i])) ? $_POST["zaner" . $i] : '-'; ?>','<?php echo $p; ?>_obr',9, 0, <?php echo $r; ?>);
                    </script><?php
            }
            $r = ($_SESSION['nat'] == 1) ? 1 : 999;
            for ($i = 1; $i <= $_SESSION['nat']; $i++) {
                $p = "natacanie" . $i;
                ?><script type="text/javascript">
                                    s('<?php echo (isset($_POST["natacanie" . $i])) ? $_POST["natacanie" . $i] : ''; ?>','<?php echo $p; ?>_obr',<?php echo $r; ?>,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                    </script><?php
            }
            $r = ($_SESSION['rez'] == 1) ? 1 : 999;
            for ($i = 1; $i <= $_SESSION['rez']; $i++) {
                $p = "reziser" . $i;
                ?><script type="text/javascript">
                                    s('<?php echo (isset($_POST["reziser" . $i])) ? $_POST["reziser" . $i] : ''; ?>','<?php echo $p; ?>_obr',<?php echo $r; ?>,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                    </script><?php
            }
            $r = ($_SESSION['her'] == 1) ? 1 : 999;
            for ($i = 1; $i <= $_SESSION['her']; $i++) {
                $p = "herec" . $i;
                ?><script type="text/javascript">
                                    s('<?php echo (isset($_POST["herec" . $i])) ? $_POST["herec" . $i] : ''; ?>','<?php echo $p; ?>_obr',<?php echo $r; ?>,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                    </script><?php
            }
            break;
        case 7:   // PRIDAJ FILM - LEN SUKROMNU CAST  + UPRAV FILM
            ?><script type="text/javascript">
                            s('','pozreti_obr',0,0,0);
                            s('','vlastne_hodnotenie_obr',0,0,0);                
                            s('<?php echo (isset($_POST['komentar'])) ? $_POST['komentar'] : ''; ?>','komentar_obr',5,<?php echo MIN_TEXT; ?>,<?php echo MAX_BIGTEXT; ?>);
                            s('<?php echo (isset($_POST['poznamky'])) ? $_POST['poznamky'] : ''; ?>','poznamky_obr',5,<?php echo MIN_TEXT; ?>,<?php echo MAX_BIGTEXT; ?>);
                            s('','bonusy_obr',0,0,0);
                            s('<?php echo (isset($_POST['umiestnenie'])) ? $_POST['umiestnenie'] : ''; ?>','umiestnenie_obr',5,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);                
                </script><?php
            break;
        case 8:   // UPRAV FILM - LEN VEREJNA CAST
            $row = daj_udaje_z_db('SELECT * FROM film_public WHERE id=' . $_GET['film_id']);
            ?><script type="text/javascript">
                            s('<?php echo (isset($_POST['cs_name'])) ? $_POST['cs_name'] : $row['cs_name']; ?>','cs_name_obr',1,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                            s('<?php echo (isset($_POST['obsah'])) ? stringToJS($_POST['obsah']) : stringToJS($row['obsah']); ?>','obsah_obr',1,<?php echo MIN_TEXT; ?>,<?php echo MAX_HUGETEXT; ?>);
                            s('','minutaz_obr',0,0,0);
                            s('','hodnotenie_obr',0,0,0);
                </script><?php
            $r = ($_SESSION['zan'] == 1) ? 0 : 999;
            $hodnota = explode("@", $row['zaner']);
            for ($i = 1; $i <= $_SESSION['zan']; $i++) {
                $p = "zaner" . $i;                         
                ?><script type="text/javascript">
                                    s('<?php echo (isset($_POST["zaner" . $i])) ? $_POST["zaner" . $i] : (($hodnota[$i - 1] != '') ? $hodnota[$i - 1] : '-'); ?>','<?php echo $p; ?>_obr',9, 0, <?php echo $r; ?>);
                    </script><?php
            }
            $r = ($_SESSION['nat'] == 1) ? 1 : 999;
            $hodnota = explode("@", $row['natacanie']);
            for ($i = 1; $i <= $_SESSION['nat']; $i++) {
                $p = "natacanie" . $i;
                ?><script type="text/javascript">
                                    s('<?php echo (isset($_POST["natacanie" . $i])) ? $_POST["natacanie" . $i] : (($hodnota[$i - 1] != '') ? $hodnota[$i - 1] : ''); ?>','<?php echo $p; ?>_obr',<?php echo $r; ?>,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                    </script><?php
            }
            $r = ($_SESSION['rez'] == 1) ? 1 : 999;
            $hodnota = explode("@", $row['reziser']);
            for ($i = 1; $i <= $_SESSION['rez']; $i++) {
                $p = "reziser" . $i;
                ?><script type="text/javascript">
                                    s('<?php echo (isset($_POST["reziser" . $i])) ? $_POST["reziser" . $i] : (($hodnota[$i - 1] != '') ? $hodnota[$i - 1] : ''); ?>','<?php echo $p; ?>_obr',<?php echo $r; ?>,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                    </script><?php
            }
            $r = ($_SESSION['her'] == 1) ? 1 : 999;
            $hodnota = explode("@", $row['herci']);
            for ($i = 1; $i <= $_SESSION['her']; $i++) {
                $p = "herec" . $i;
                ?><script type="text/javascript">
                                    s('<?php echo (isset($_POST["herec" . $i])) ? $_POST["herec" . $i] : (($hodnota[$i - 1] != '') ? $hodnota[$i - 1] : ''); ?>','<?php echo $p; ?>_obr',<?php echo $r; ?>,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                    </script><?php
            }
            break;
        case 9:   // KONTAKT NA POZICANIE FILMU
            ?><script type="text/javascript">
                            s('<?php echo (isset($_POST['kontakt'])) ? $_POST['kontakt'] : ''; ?>','kontakt_obr',1,<?php echo MIN_TEXT; ?>,<?php echo MAX_BIGTEXT; ?>);
                </script><?php
            break;
        case 66:   // AUTO PRIDAJ FILM        
            ?><script type="text/javascript">
                            s('<?php echo (isset($_POST['cs_name'])) ? $_POST['cs_name'] : '' ?>','cs_name_obr',1,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                            //s('<?php echo (isset($_POST['obsah'])) ? $_POST['obsah'] : '' ?>','obsah_obr',1,<?php echo MIN_TEXT; ?>,<?php echo MAX_HUGETEXT; ?>);
                            s('<?php echo (isset($_POST['komentar'])) ? $_POST['komentar'] : '' ?>','komentar_obr',5,<?php echo MIN_TEXT; ?>,<?php echo MAX_BIGTEXT; ?>);
                            s('<?php echo (isset($_POST['poznamky'])) ? $_POST['poznamky'] : '' ?>','poznamky_obr',5,<?php echo MIN_TEXT; ?>,<?php echo MAX_BIGTEXT; ?>);
                            s('','pozreti_obr',0,0,0);
                            s('','vlastne_hodnotenie_obr',0,0,0);
                            s('<?php echo (isset($_POST['select_zvuk'])) ? $_POST['select_zvuk'] : '-' ?>','select_zvuk_obr',0,0,0);
                            s('<?php echo (isset($_POST['select_titulky'])) ? $_POST['select_titulky'] : '-' ?>','select_titulky_obr',0,0,0);
                            s('','bonusy_obr',0,0,0);
                            s('<?php echo (isset($_POST['umiestnenie'])) ? $_POST['umiestnenie'] : '' ?>','umiestnenie_obr',5,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                </script><?php            
            $r = ($_SESSION['nat'] == 1) ? 1 : 999;
            for ($i = 1; $i <= $_SESSION['nat']; $i++) {
                $p = "natacanie" . $i;
                ?><script type="text/javascript">
                                    s('<?php echo (isset($_POST["natacanie" . $i])) ? $_POST["natacanie" . $i] : ''; ?>','<?php echo $p; ?>_obr',<?php echo $r; ?>,<?php echo MIN_TEXT; ?>,<?php echo MAX_TEXT; ?>);
                    </script><?php
            }                       
            break;
        default:
            break;
    }
}
?>